-- reference relationships
CREATE INDEX reference_relationship_artifact_id_from_index ON reference_relationships (reference_relationship_artifact_id_from);
CREATE INDEX reference_relationship_artifact_id_to_index ON reference_relationships (reference_relationship_artifact_id_to);
-- history
DROP INDEX reference_relationships_history_arti_id_from_json_data_index;
CREATE INDEX reference_relationship_history_artifact_id_from_to_index ON reference_relationships_history (reference_relationship_artifact_id_from, reference_relationship_artifact_id_to);
CREATE INDEX reference_relationship_history_artifact_id_from_index ON reference_relationships_history (reference_relationship_artifact_id_from);
CREATE INDEX reference_relationship_history_artifact_id_to_index ON reference_relationships_history (reference_relationship_artifact_id_to);

-- uploaded files relationships
CREATE INDEX uploaded_file_relationship_artifact_id_index ON uploaded_file_relationships (uploaded_file_relationship_artifact_id);
CREATE INDEX uploaded_file_relationship_uploaded_file_id_index ON uploaded_file_relationships (uploaded_file_relationship_uploaded_file_id);
-- history
DROP INDEX uploaded_file_relationships_history_artifact_id_json_data_index;
CREATE INDEX uploaded_file_relationship_history_a_id_uf_id_index ON uploaded_file_relationships_history (uploaded_file_relationship_artifact_id, uploaded_file_relationship_uploaded_file_id);
CREATE INDEX uploaded_file_relationship_history_artifact_id_index ON uploaded_file_relationships_history (uploaded_file_relationship_artifact_id);
CREATE INDEX uploaded_file_relationship_history_uploaded_file_id_index ON uploaded_file_relationships_history (uploaded_file_relationship_uploaded_file_id);

-- timeseries relationships
ALTER INDEX time_series_relationships_artifact_id_time_series_id_index RENAME TO time_series_relationship_artifact_id_time_series_id_index;
CREATE INDEX time_series_relationships_artifact_id_index ON time_series_relationships (time_series_relationship_artifact_id);
CREATE INDEX time_series_relationships_time_series_id_index ON time_series_relationships (time_series_relationship_time_series_id);
-- history
DROP INDEX time_series_relationships_history_artifact_id_json_data_index;
CREATE INDEX time_series_relationship_history_a_id_ts_id_index ON time_series_relationships_history (time_series_relationship_artifact_id, time_series_relationship_time_series_id);
CREATE INDEX time_series_relationship_history_artifact_id_index ON time_series_relationships_history (time_series_relationship_artifact_id);
CREATE INDEX time_series_relationship_history_time_series_id_index ON time_series_relationships_history (time_series_relationship_time_series_id);

-- some artifact fields
CREATE INDEX artifact_archived_index ON artifacts ((artifact_json #>> '{status, archived}'));
CREATE INDEX artifact_step_id_index ON artifacts ((artifact_json #>> '{status, stepId}'));

-- some dataiku artifact fields
CREATE INDEX artifact_dataiku_node_id_index ON artifacts ((artifact_json #>> '{fields, node_id}'));
CREATE INDEX artifact_dataiku_project_key_index ON artifacts ((artifact_json #>> '{fields, project_key}'));
CREATE INDEX artifact_dataiku_node_id_project_key_index ON artifacts ((artifact_json #>> '{fields, node_id}'), (artifact_json #> '{fields, project_key}'));
CREATE INDEX artifact_dataiku_governed_by_index ON artifacts ((artifact_json #>> '{fields, governed_by}'));
CREATE INDEX artifact_dataiku_hidden_index ON artifacts ((artifact_json #>> '{fields, hidden_in_governable_items_table}'));
