from dataiku.project_standards import (
    ProjectStandardsCheckRunResult,
    ProjectStandardsCheckSpec,
)


class FlowZoneCheckSpec(ProjectStandardsCheckSpec):

    def run(self):
        flow = self.project.get_flow()
        flow_zones = flow.list_zones()
        if len(flow_zones) == 0:
            return ProjectStandardsCheckRunResult.failure(4, "At least one flow zone is required, but none were found.")

        require_desc = self.config.get("requireFlowZonesDesc", False)
        if not require_desc:
            return ProjectStandardsCheckRunResult.success("A flow zone has been found.")

        for zone in flow_zones:
            settings = zone.get_settings().get_raw()
            description = settings.get("description", "")
            short_description = settings.get("shortDesc", "")
            if len(description) == 0 and len(short_description) == 0:
                return ProjectStandardsCheckRunResult.failure(
                    3, "The flow zone '{}' has no description".format(zone.name)
                )

        return ProjectStandardsCheckRunResult.success("All flow zones have a description.")
