/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.prefetch;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.impl.prefetch.BufferData;
import org.apache.hadoop.fs.impl.prefetch.FilePosition;
import org.apache.hadoop.fs.s3a.S3AInputStream;
import org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.prefetch.S3ARemoteInputStream;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3AInMemoryInputStream
extends S3ARemoteInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(S3AInMemoryInputStream.class);
    private ByteBuffer buffer;

    public S3AInMemoryInputStream(S3AReadOpContext context, S3ObjectAttributes s3Attributes, S3AInputStream.InputStreamCallbacks client, S3AInputStreamStatistics streamStatistics) {
        super(context, s3Attributes, client, streamStatistics);
        int fileSize = (int)s3Attributes.getLen();
        this.buffer = ByteBuffer.allocate(fileSize);
        LOG.debug("Created in-memory input stream for {} (size = {})", (Object)this.getName(), (Object)fileSize);
    }

    @Override
    protected boolean ensureCurrentBuffer() throws IOException {
        if (this.isClosed()) {
            return false;
        }
        if (this.getBlockData().getFileSize() == 0L) {
            return false;
        }
        FilePosition filePosition = this.getFilePosition();
        if (filePosition.isValid()) {
            filePosition.setAbsolute(this.getNextReadPos());
        } else {
            this.buffer.clear();
            int numBytesRead = this.getReader().read(this.buffer, 0L, this.buffer.capacity());
            if (numBytesRead <= 0) {
                return false;
            }
            BufferData data = new BufferData(0, this.buffer);
            filePosition.setData(data, 0L, this.getNextReadPos());
        }
        return filePosition.buffer().hasRemaining();
    }
}

