/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glue.model.SchemaVersionNumber;

@SdkInternalApi
public class SchemaVersionNumberMarshaller {
    private static final MarshallingInfo<Boolean> LATESTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestVersion").build();
    private static final MarshallingInfo<Long> VERSIONNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionNumber").build();
    private static final SchemaVersionNumberMarshaller instance = new SchemaVersionNumberMarshaller();

    public static SchemaVersionNumberMarshaller getInstance() {
        return instance;
    }

    public void marshall(SchemaVersionNumber schemaVersionNumber, ProtocolMarshaller protocolMarshaller) {
        if (schemaVersionNumber == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)schemaVersionNumber.getLatestVersion(), LATESTVERSION_BINDING);
            protocolMarshaller.marshall((Object)schemaVersionNumber.getVersionNumber(), VERSIONNUMBER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

