/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands.convert;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.Footer;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.SerializableFileStatus;
import org.apache.spark.sql.delta.commands.convert.ConvertTargetFile;
import org.apache.spark.sql.delta.commands.convert.ConvertTargetFileManifest;
import org.apache.spark.sql.delta.commands.convert.ConvertUtils$;
import org.apache.spark.sql.delta.commands.convert.ParquetSchemaFetchConfig;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.PartitionUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001\u0002\t\u0012\u0001\u0001B\u0001B\u0007\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\to\u0001\u0011)\u0019!C!q!Aa\t\u0001B\u0001B\u0003%\u0011\b\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011!\u0001\u0006A!A!\u0002\u0013\t\u0006\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011m\u0003!\u0011!Q\u0001\nqCQA\u0019\u0001\u0005\u0002\rDqa\u001b\u0001C\u0002\u0013%A\u000e\u0003\u0004r\u0001\u0001\u0006I!\u001c\u0005\te\u0002A)\u0019!C\u0005g\"9\u0011q\u0001\u0001\u0005\u0012\u0005%\u0001BCA\r\u0001!\u0015\r\u0011\"\u0011\u0002\u001c!Q\u0011Q\u0005\u0001\t\u0006\u0004%\t%a\n\t\u000f\u0005=\u0002\u0001\"\u0011\u00022\t\u00192)\u0019;bY><g)\u001b7f\u001b\u0006t\u0017NZ3ti*\u0011!cE\u0001\bG>tg/\u001a:u\u0015\t!R#\u0001\u0005d_6l\u0017M\u001c3t\u0015\t1r#A\u0003eK2$\u0018M\u0003\u0002\u00193\u0005\u00191/\u001d7\u000b\u0005iY\u0012!B:qCJ\\'B\u0001\u000f\u001e\u0003\u0019\t\u0007/Y2iK*\ta$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001C%j\u0003C\u0001\u0012(\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0011a\u0017M\\4\u000b\u0003\u0019\nAA[1wC&\u0011\u0001f\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005)ZS\"A\t\n\u00051\n\"!G\"p]Z,'\u000f\u001e+be\u001e,GOR5mK6\u000bg.\u001b4fgR\u0004\"AL\u0019\u000e\u0003=R!\u0001M\u000b\u0002\u00115,G/\u001a:j]\u001eL!AM\u0018\u0003\u0019\u0011+G\u000e^1M_\u001e<\u0017N\\4\u0011\u0005Q*T\"A\f\n\u0005Y:\"\u0001D*qCJ\\7+Z:tS>t\u0017\u0001\u00032bg\u0016\u0004\u0016\r\u001e5\u0016\u0003e\u0002\"AO\"\u000f\u0005m\n\u0005C\u0001\u001f@\u001b\u0005i$B\u0001  \u0003\u0019a$o\\8u})\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\u00051\u0001K]3eK\u001aL!\u0001R#\u0003\rM#(/\u001b8h\u0015\t\u0011u(A\u0005cCN,\u0007+\u0019;iA\u0005a1-\u0019;bY><G+\u00192mKB\u0011\u0011JT\u0007\u0002\u0015*\u00111\nT\u0001\bG\u0006$\u0018\r\\8h\u0015\tiu#\u0001\u0005dCR\fG._:u\u0013\ty%J\u0001\u0007DCR\fGn\\4UC\ndW-A\bqCJ$\u0018\u000e^5p]N\u001b\u0007.Z7b!\t\u0011V+D\u0001T\u0015\t!v#A\u0003usB,7/\u0003\u0002W'\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u00021A\f'/];fiN\u001b\u0007.Z7b\r\u0016$8\r[\"p]\u001aLw\r\u0005\u0002+3&\u0011!,\u0005\u0002\u0019!\u0006\u0014\u0018/^3u'\u000eDW-\\1GKR\u001c\u0007nQ8oM&<\u0017\u0001E:fe&\fG.\u001b>bE2,7i\u001c8g!\ti\u0006-D\u0001_\u0015\ty\u0016$\u0001\u0003vi&d\u0017BA1_\u0005e\u0019VM]5bY&T\u0018M\u00197f\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u001d!WMZ4iS*\u0004\"A\u000b\u0001\t\u000biA\u0001\u0019A\u001a\t\u000b]B\u0001\u0019A\u001d\t\u000b\u001dC\u0001\u0019\u0001%\t\u000bAC\u0001\u0019A)\t\u000b]C\u0001\u0019\u0001-\t\u000bmC\u0001\u0019\u0001/\u0002!U\u001cXmQ1uC2|wmU2iK6\fW#A7\u0011\u00059|W\"A \n\u0005A|$a\u0002\"p_2,\u0017M\\\u0001\u0012kN,7)\u0019;bY><7k\u00195f[\u0006\u0004\u0013!\u00049beRLG/[8o\u0019&\u001cH/F\u0001u!\r)\bP_\u0007\u0002m*\u0011qoP\u0001\u000bG>dG.Z2uS>t\u0017BA=w\u0005\r\u0019V-\u001d\t\u0005]nLT0\u0003\u0002}\u007f\t1A+\u001e9mKJ\u0002RA`A\u0002sej\u0011a \u0006\u0004\u0003\u00031\u0018!C5n[V$\u0018M\u00197f\u0013\r\t)a \u0002\u0004\u001b\u0006\u0004\u0018A\u00023p\u0019&\u001cH\u000f\u0006\u0002\u0002\fA)A'!\u0004\u0002\u0012%\u0019\u0011qB\f\u0003\u000f\u0011\u000bG/Y:fiB!\u00111CA\u000b\u001b\u0005)\u0012bAA\f+\t12+\u001a:jC2L'0\u00192mK\u001aKG.Z*uCR,8/\u0001\u0005bY24\u0015\u000e\\3t+\t\ti\u0002E\u00035\u0003\u001b\ty\u0002E\u0002+\u0003CI1!a\t\u0012\u0005E\u0019uN\u001c<feR$\u0016M]4fi\u001aKG.Z\u0001\u000ea\u0006\u0014\u0018/^3u'\u000eDW-\\1\u0016\u0005\u0005%\u0002\u0003\u00028\u0002,EK1!!\f@\u0005\u0019y\u0005\u000f^5p]\u0006)1\r\\8tKR\u0011\u00111\u0007\t\u0004]\u0006U\u0012bAA\u001c\u007f\t!QK\\5u\u0001")
public class CatalogFileManifest
implements ConvertTargetFileManifest,
DeltaLogging {
    private Seq<Tuple2<String, Map<String, String>>> partitionList;
    private Dataset<ConvertTargetFile> allFiles;
    private Option<StructType> parquetSchema;
    private final SparkSession spark;
    private final String basePath;
    private final CatalogTable catalogTable;
    private final StructType partitionSchema;
    private final ParquetSchemaFetchConfig parquetSchemaFetchConfig;
    private final SerializableConfiguration serializableConf;
    private final boolean useCatalogSchema;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Iterator<ConvertTargetFile> getFiles() {
        return ConvertTargetFileManifest.getFiles$(this);
    }

    @Override
    public long numFiles() {
        return ConvertTargetFileManifest.numFiles$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String basePath() {
        return this.basePath;
    }

    private boolean useCatalogSchema() {
        return this.useCatalogSchema;
    }

    private Seq<Tuple2<String, Map<String, String>>> partitionList$lzycompute() {
        CatalogFileManifest catalogFileManifest = this;
        synchronized (catalogFileManifest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Seq seq;
                if (this.catalogTable.partitionSchema().isEmpty()) {
                    seq = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.basePath()), (Object)Predef$.MODULE$.Map().empty()), (List)Nil$.MODULE$);
                } else {
                    Seq partitions = this.spark.sessionState().catalog().listPartitions(this.catalogTable.identifier(), this.spark.sessionState().catalog().listPartitions$default$2());
                    seq = (Seq)partitions.map((Function1 & Serializable & scala.Serializable)partition -> {
                        String partitionDir = (String)partition.storage().locationUri().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                            String partitionDir = PartitionUtils$.MODULE$.getPathFragment((Map<String, String>)partition.spec(), $this.catalogTable.partitionSchema());
                            return new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(this.basePath())).stripSuffix("/")).append("/").append(partitionDir).toString();
                        });
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionDir), (Object)partition.spec());
                    }, Seq$.MODULE$.canBuildFrom());
                }
                this.partitionList = seq;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.partitionList;
    }

    private Seq<Tuple2<String, Map<String, String>>> partitionList() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.partitionList$lzycompute();
        }
        return this.partitionList;
    }

    public Dataset<SerializableFileStatus> doList() {
        if (this.partitionList().isEmpty()) {
            throw DeltaErrors$.MODULE$.convertToDeltaNoPartitionFound(this.catalogTable.identifier().unquotedString());
        }
        return ConvertUtils$.MODULE$.listDirsInParallel(this.spark, this.basePath(), (Seq<String>)((Seq)this.partitionList().map((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3._1(), Seq$.MODULE$.canBuildFrom())), this.serializableConf);
    }

    private Dataset<ConvertTargetFile> allFiles$lzycompute() {
        CatalogFileManifest catalogFileManifest = this;
        synchronized (catalogFileManifest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Broadcast conf = this.spark.sparkContext().broadcast((Object)this.serializableConf, ClassTag$.MODULE$.apply(SerializableConfiguration.class));
                boolean useParquetSchema = !this.useCatalogSchema();
                Map dirToPartitionSpec = this.partitionList().toMap(Predef$.MODULE$.$conforms());
                ParquetSchemaFetchConfig fetchConfig = this.parquetSchemaFetchConfig;
                Dataset files = this.doList().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
                    Seq fileStatuses = iter.toSeq();
                    if (useParquetSchema) {
                        Map pathToFile = ((TraversableOnce)fileStatuses.map((Function1 & Serializable & scala.Serializable)fileStatus -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fileStatus.path()), fileStatus), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                        Seq<Footer> footerSeq = DeltaFileOperations$.MODULE$.readParquetFootersInParallel(((SerializableConfiguration)conf.value()).value(), (Seq<FileStatus>)((Seq)fileStatuses.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toFileStatus(), Seq$.MODULE$.canBuildFrom())), fetchConfig.ignoreCorruptFiles());
                        ParquetToSparkSchemaConverter schemaConverter = new ParquetToSparkSchemaConverter(fetchConfig.assumeBinaryIsString(), fetchConfig.assumeInt96IsTimestamp(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$4(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$5());
                        return ((IterableLike)footerSeq.map((Function1 & Serializable & scala.Serializable)footer -> {
                            StructType schema = ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, schemaConverter);
                            SerializableFileStatus fileStatus = (SerializableFileStatus)pathToFile.apply((Object)footer.getFile().toString());
                            return new ConvertTargetFile(fileStatus, (Option<Map<String, String>>)dirToPartitionSpec.get((Object)footer.getFile().getParent().toString()), (Option<String>)new Some((Object)schema.toDDL()));
                        }, Seq$.MODULE$.canBuildFrom())).toIterator();
                    }
                    return ((IterableLike)fileStatuses.map((Function1 & Serializable & scala.Serializable)fileStatus -> new ConvertTargetFile((SerializableFileStatus)fileStatus, (Option<Map<String, String>>)dirToPartitionSpec.get((Object)fileStatus.getHadoopPath().getParent().toString()), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom())).toIterator();
                }, package$.MODULE$.convertTargetFileEncoder());
                files.cache();
                this.allFiles = files;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.allFiles;
    }

    @Override
    public Dataset<ConvertTargetFile> allFiles() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.allFiles$lzycompute();
        }
        return this.allFiles;
    }

    private Option<StructType> parquetSchema$lzycompute() {
        CatalogFileManifest catalogFileManifest = this;
        synchronized (catalogFileManifest) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.parquetSchema = this.useCatalogSchema() ? new Some((Object)this.catalogTable.schema()) : (Option)this.recordDeltaOperationForTablePath(this.basePath(), "delta.convert.schemaInference", this.recordDeltaOperationForTablePath$default$3(), (Function0 & Serializable & scala.Serializable)() -> new Some((Object)ConvertUtils$.MODULE$.mergeSchemasInParallel($this.spark, $this.partitionSchema, this.allFiles())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.parquetSchema;
    }

    @Override
    public Option<StructType> parquetSchema() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.parquetSchema$lzycompute();
        }
        return this.parquetSchema;
    }

    @Override
    public void close() {
        this.allFiles().unpersist();
    }

    public CatalogFileManifest(SparkSession spark, String basePath, CatalogTable catalogTable, StructType partitionSchema, ParquetSchemaFetchConfig parquetSchemaFetchConfig, SerializableConfiguration serializableConf) {
        this.spark = spark;
        this.basePath = basePath;
        this.catalogTable = catalogTable;
        this.partitionSchema = partitionSchema;
        this.parquetSchemaFetchConfig = parquetSchemaFetchConfig;
        this.serializableConf = serializableConf;
        ConvertTargetFileManifest.$init$(this);
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        this.useCatalogSchema = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_CONVERT_USE_CATALOG_SCHEMA()));
    }
}

