/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.resource;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.TaskResourceProfile;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SparkListenerResourceProfileAdded;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Evolving
@ScalaSignature(bytes="\u0006\u0001\u0005Ud!B\u0011#\u0001\u0011R\u0003\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011u\u0002!\u0011!Q\u0001\nyBQ\u0001\u0012\u0001\u0005\u0002\u0015CqA\u0013\u0001C\u0002\u0013%1\n\u0003\u0004[\u0001\u0001\u0006I\u0001\u0014\u0005\u000b7\u0002\u0001\n\u0011aA!\u0002\u0013a\u0006b\u00029\u0001\u0005\u0004%I!\u001d\u0005\u0007e\u0002\u0001\u000b\u0011B0\t\u000fM\u0004!\u0019!C\u0005i\"1Q\u000f\u0001Q\u0001\n5DqA\u001e\u0001C\u0002\u0013%q\u000f\u0003\u0004y\u0001\u0001\u0006Ia\u0016\u0005\u0006s\u0002!\ta\u001e\u0005\bu\u0002\u0011\r\u0011\"\u0003|\u0011\u0019y\b\u0001)A\u0005y\"I\u0011\u0011\u0001\u0001C\u0002\u0013%\u00111\u0001\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u0006!A\u00111\u0005\u0001C\u0002\u0013%1\u0010C\u0004\u0002&\u0001\u0001\u000b\u0011\u0002?\t\u0011\u0005\u001d\u0002A1A\u0005\nmDq!!\u000b\u0001A\u0003%A\u0010\u0003\u0005\u0002,\u0001\u0011\r\u0011\"\u0003|\u0011\u001d\ti\u0003\u0001Q\u0001\nqD\u0001\"a\f\u0001\u0005\u0004%Ia\u001f\u0005\b\u0003c\u0001\u0001\u0015!\u0003}\u0011!\t\u0019\u0004\u0001b\u0001\n\u0013Y\bbBA\u001b\u0001\u0001\u0006I\u0001 \u0005\t\u0003o\u0001A\u0011\u0001\u0013\u0002:!A\u0011q\b\u0001\u0005\u0002\u0011\n\t\u0005C\u0004\u0002L\u0001!\t!!\u0014\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z!9\u0011q\f\u0001\u0005\u0002\u0005\u0005$A\u0006*fg>,(oY3Qe>4\u0017\u000e\\3NC:\fw-\u001a:\u000b\u0005\r\"\u0013\u0001\u0003:fg>,(oY3\u000b\u0005\u00152\u0013!B:qCJ\\'BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001e\u001c2\u0001A\u00162!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0019\te.\u001f*fMB\u0011!'N\u0007\u0002g)\u0011A\u0007J\u0001\tS:$XM\u001d8bY&\u0011ag\r\u0002\b\u0019><w-\u001b8h\u0003%\u0019\b/\u0019:l\u0007>tgm\u0001\u0001\u0011\u0005iZT\"\u0001\u0013\n\u0005q\"#!C*qCJ\\7i\u001c8g\u0003-a\u0017n\u001d;f]\u0016\u0014()^:\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005#\u0013!C:dQ\u0016$W\u000f\\3s\u0013\t\u0019\u0005IA\bMSZ,G*[:uK:,'OQ;t\u0003\u0019a\u0014N\\5u}Q\u0019a\tS%\u0011\u0005\u001d\u0003Q\"\u0001\u0012\t\u000b]\u001a\u0001\u0019A\u001d\t\u000bu\u001a\u0001\u0019\u0001 \u0002EI,7o\\;sG\u0016\u0004&o\u001c4jY\u0016LE\rV8SKN|WO]2f!J|g-\u001b7f+\u0005a\u0005\u0003B'S)^k\u0011A\u0014\u0006\u0003\u001fB\u000bq!\\;uC\ndWM\u0003\u0002R[\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Ms%a\u0002%bg\"l\u0015\r\u001d\t\u0003YUK!AV\u0017\u0003\u0007%sG\u000f\u0005\u0002H1&\u0011\u0011L\t\u0002\u0010%\u0016\u001cx.\u001e:dKB\u0013xNZ5mK\u0006\u0019#/Z:pkJ\u001cW\r\u0015:pM&dW-\u00133U_J+7o\\;sG\u0016\u0004&o\u001c4jY\u0016\u0004\u0013a\u0001=%cA!A&X0n\u0013\tqVF\u0001\u0004UkBdWM\r\t\u0003A.l\u0011!\u0019\u0006\u0003E\u000e\faCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m\u001b\u0006\u0003I\u0016\fQ\u0001\\8dWNT!AZ4\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002iS\u0006!Q\u000f^5m\u0015\u0005Q\u0017\u0001\u00026bm\u0006L!\u0001\\1\u0003\u0011I+\u0017\r\u001a'pG.\u0004\"\u0001\u00198\n\u0005=\f'!C,sSR,Gj\\2l\u0003!\u0011X-\u00193M_\u000e\\W#A0\u0002\u0013I,\u0017\r\u001a'pG.\u0004\u0013!C<sSR,Gj\\2l+\u0005i\u0017AC<sSR,Gj\\2lA\u0005qA-\u001a4bk2$\bK]8gS2,W#A,\u0002\u001f\u0011,g-Y;miB\u0013xNZ5mK\u0002\na\u0003Z3gCVdGOU3t_V\u00148-\u001a)s_\u001aLG.Z\u0001\u000fIft\u0017-\\5d\u000b:\f'\r\\3e+\u0005a\bC\u0001\u0017~\u0013\tqXFA\u0004C_>dW-\u00198\u0002\u001f\u0011Lh.Y7jG\u0016s\u0017M\u00197fI\u0002\na!\\1ti\u0016\u0014XCAA\u0003!\u0015a\u0013qAA\u0006\u0013\r\tI!\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u00055\u00111\u0004\b\u0005\u0003\u001f\t9\u0002E\u0002\u0002\u00125j!!a\u0005\u000b\u0007\u0005U\u0001(\u0001\u0004=e>|GOP\u0005\u0004\u00033i\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001e\u0005}!AB*ue&twMC\u0002\u0002\u001a5\nq!\\1ti\u0016\u0014\b%\u0001\u0004jgf\u000b'O\\\u0001\bSNL\u0016M\u001d8!\u0003\u0015I7o\u0013\u001dt\u0003\u0019I7o\u0013\u001dtA\u0005Q\u0012n]*uC:$\u0017\r\\8oK>\u0013Hj\\2bY\u000ecWo\u001d;fe\u0006Y\u0012n]*uC:$\u0017\r\\8oK>\u0013Hj\\2bY\u000ecWo\u001d;fe\u0002\n1C\\8u%Vtg.\u001b8h+:LG\u000fV3tiN\fAC\\8u%Vtg.\u001b8h+:LG\u000fV3tiN\u0004\u0013a\u0005;fgR,\u0005pY3qi&|g\u000e\u00165s_^t\u0017\u0001\u0006;fgR,\u0005pY3qi&|g\u000e\u00165s_^t\u0007%A\u0006jgN+\b\u000f]8si\u0016$Gc\u0001?\u0002<!1\u0011Q\b\u000fA\u0002]\u000b!A\u001d9\u0002\u001d\r\fgNQ3TG\",G-\u001e7fIR)A0a\u0011\u0002H!1\u0011QI\u000fA\u0002Q\u000b\u0001\u0002^1tWJ\u0003\u0018\n\u001a\u0005\u0007\u0003\u0013j\u0002\u0019\u0001+\u0002\u0019\u0015DXmY;u_J\u0014\u0006/\u00133\u0002%\u0005$GMU3t_V\u00148-\u001a)s_\u001aLG.\u001a\u000b\u0005\u0003\u001f\n)\u0006E\u0002-\u0003#J1!a\u0015.\u0005\u0011)f.\u001b;\t\r\u0005ub\u00041\u0001X\u0003U\u0011Xm]8ve\u000e,\u0007K]8gS2,gI]8n\u0013\u0012$2aVA.\u0011\u0019\tif\ba\u0001)\u0006!!\u000f]%e\u0003Q9W\r^#rk&4\u0018\r\\3oiB\u0013xNZ5mKR!\u00111MA3!\u0011a\u0013qA,\t\r\u0005u\u0002\u00051\u0001XQ\r\u0001\u0011\u0011\u000e\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011q\u000e\u0013\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002t\u00055$\u0001C#w_24\u0018N\\4")
public class ResourceProfileManager
implements Logging {
    private final SparkConf sparkConf;
    private final LiveListenerBus listenerBus;
    private final HashMap<Object, ResourceProfile> resourceProfileIdToResourceProfile;
    private final /* synthetic */ Tuple2 x$1;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ResourceProfile defaultProfile;
    private final boolean dynamicEnabled;
    private final Option<String> master;
    private final boolean isYarn;
    private final boolean isK8s;
    private final boolean isStandaloneOrLocalCluster;
    private final boolean notRunningUnitTests;
    private final boolean testExceptionThrown;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private HashMap<Object, ResourceProfile> resourceProfileIdToResourceProfile() {
        return this.resourceProfileIdToResourceProfile;
    }

    private ReentrantReadWriteLock.ReadLock readLock() {
        return this.readLock;
    }

    private ReentrantReadWriteLock.WriteLock writeLock() {
        return this.writeLock;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    public ResourceProfile defaultResourceProfile() {
        return this.defaultProfile();
    }

    private boolean dynamicEnabled() {
        return this.dynamicEnabled;
    }

    private Option<String> master() {
        return this.master;
    }

    private boolean isYarn() {
        return this.isYarn;
    }

    private boolean isK8s() {
        return this.isK8s;
    }

    private boolean isStandaloneOrLocalCluster() {
        return this.isStandaloneOrLocalCluster;
    }

    private boolean notRunningUnitTests() {
        return this.notRunningUnitTests;
    }

    private boolean testExceptionThrown() {
        return this.testExceptionThrown;
    }

    public boolean isSupported(ResourceProfile rp) {
        block3: {
            boolean YarnOrK8sOrStandaloneNotDynAllocAndNotDefaultProfile;
            block2: {
                if (!(rp instanceof TaskResourceProfile) || this.dynamicEnabled()) break block2;
                if (!(!this.notRunningUnitTests() && !this.testExceptionThrown() || this.isStandaloneOrLocalCluster() || this.isYarn() || this.isK8s())) {
                    throw new SparkException("TaskResourceProfiles are only supported for Standalone, Yarn and Kubernetes cluster for now when dynamic allocation is disabled.");
                }
                break block3;
            }
            boolean isNotDefaultProfile = rp.id() != ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
            boolean notYarnOrK8sOrStandaloneAndNotDefaultProfile = isNotDefaultProfile && !this.isYarn() && !this.isK8s() && !this.isStandaloneOrLocalCluster();
            boolean bl = YarnOrK8sOrStandaloneNotDynAllocAndNotDefaultProfile = isNotDefaultProfile && (this.isYarn() || this.isK8s() || this.isStandaloneOrLocalCluster()) && !this.dynamicEnabled();
            if ((this.notRunningUnitTests() || this.testExceptionThrown()) && (notYarnOrK8sOrStandaloneAndNotDefaultProfile || YarnOrK8sOrStandaloneNotDynAllocAndNotDefaultProfile)) {
                throw new SparkException("ResourceProfiles are only supported on YARN and Kubernetes and Standalone with dynamic allocation enabled.");
            }
            if (!this.isStandaloneOrLocalCluster() || !this.dynamicEnabled() || !rp.getExecutorCores().isEmpty() || !this.sparkConf.getOption(package$.MODULE$.EXECUTOR_CORES().key()).isEmpty()) break block3;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Neither executor cores is set for resource profile, nor spark.executor.cores is explicitly set, you may get more executors allocated than expected. It's recommended to set executor cores explicitly. Please check SPARK-30299 for more details.");
        }
        return true;
    }

    public boolean canBeScheduled(int taskRpId, int executorRpId) {
        Predef$.MODULE$.assert(this.resourceProfileIdToResourceProfile().contains((Object)BoxesRunTime.boxToInteger((int)taskRpId)) && this.resourceProfileIdToResourceProfile().contains((Object)BoxesRunTime.boxToInteger((int)executorRpId)), (Function0 & Serializable & scala.Serializable)() -> "Tasks and executors must have valid resource profile id");
        ResourceProfile taskRp = this.resourceProfileFromId(taskRpId);
        return taskRpId == executorRpId || !this.dynamicEnabled() && taskRp instanceof TaskResourceProfile;
    }

    public void addResourceProfile(ResourceProfile rp) {
        this.isSupported(rp);
        boolean putNewProfile = false;
        this.writeLock().lock();
        try {
            Option prev;
            if (!this.resourceProfileIdToResourceProfile().contains((Object)BoxesRunTime.boxToInteger((int)rp.id())) && (prev = this.resourceProfileIdToResourceProfile().put((Object)BoxesRunTime.boxToInteger((int)rp.id()), (Object)rp)).isEmpty()) {
                putNewProfile = true;
            }
        }
        finally {
            this.writeLock().unlock();
        }
        if (putNewProfile) {
            rp.limitingResource(this.sparkConf);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Added ResourceProfile id: ").append(rp.id()).toString());
            this.listenerBus.post(new SparkListenerResourceProfileAdded(rp));
            return;
        }
    }

    public ResourceProfile resourceProfileFromId(int rpId) {
        ResourceProfile resourceProfile;
        this.readLock().lock();
        try {
            resourceProfile = (ResourceProfile)this.resourceProfileIdToResourceProfile().getOrElse((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable & scala.Serializable)() -> {
                throw new SparkException(new StringBuilder(29).append("ResourceProfileId ").append(rpId).append(" not found!").toString());
            });
        }
        finally {
            this.readLock().unlock();
        }
        return resourceProfile;
    }

    public Option<ResourceProfile> getEquivalentProfile(ResourceProfile rp) {
        Option option;
        this.readLock().lock();
        try {
            option = this.resourceProfileIdToResourceProfile().find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ResourceProfileManager.$anonfun$getEquivalentProfile$1(rp, x0$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> (ResourceProfile)x$2._2());
        }
        finally {
            this.readLock().unlock();
        }
        return option;
    }

    public static final /* synthetic */ boolean $anonfun$getEquivalentProfile$1(ResourceProfile rp$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ResourceProfile rpEntry = (ResourceProfile)tuple2._2();
            return rpEntry.resourcesEqual(rp$2);
        }
        throw new MatchError((Object)tuple2);
    }

    public ResourceProfileManager(SparkConf sparkConf, LiveListenerBus listenerBus) {
        this.sparkConf = sparkConf;
        this.listenerBus = listenerBus;
        Logging.$init$((Logging)this);
        this.resourceProfileIdToResourceProfile = new HashMap();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Tuple2 tuple2 = new Tuple2((Object)lock.readLock(), (Object)lock.writeLock());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReentrantReadWriteLock.ReadLock readLock = (ReentrantReadWriteLock.ReadLock)tuple2._1();
        ReentrantReadWriteLock.WriteLock writeLock = (ReentrantReadWriteLock.WriteLock)tuple2._2();
        this.x$1 = new Tuple2((Object)readLock, (Object)writeLock);
        this.readLock = (ReentrantReadWriteLock.ReadLock)this.x$1._1();
        this.writeLock = (ReentrantReadWriteLock.WriteLock)this.x$1._2();
        this.defaultProfile = ResourceProfile$.MODULE$.getOrCreateDefaultProfile(sparkConf);
        this.addResourceProfile(this.defaultProfile());
        this.dynamicEnabled = Utils$.MODULE$.isDynamicAllocationEnabled(sparkConf);
        this.master = sparkConf.getOption("spark.master");
        this.isYarn = this.master().isDefined() && ((String)this.master().get()).equals("yarn");
        this.isK8s = this.master().isDefined() && ((String)this.master().get()).startsWith("k8s://");
        this.isStandaloneOrLocalCluster = this.master().isDefined() && (((String)this.master().get()).startsWith("spark://") || ((String)this.master().get()).startsWith("local-cluster"));
        this.notRunningUnitTests = !Utils$.MODULE$.isTesting();
        this.testExceptionThrown = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(Tests$.MODULE$.RESOURCE_PROFILE_MANAGER_TESTING()));
    }
}

