/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.catalog.metastore;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.glue.catalog.converters.CatalogToHiveConverter;
import com.amazonaws.glue.catalog.converters.CatalogToHiveConverterFactory;
import com.amazonaws.glue.catalog.converters.GlueInputConverter;
import com.amazonaws.glue.catalog.converters.HiveToCatalogConverter;
import com.amazonaws.glue.catalog.converters.PartitionNameParser;
import com.amazonaws.glue.catalog.util.BatchCreatePartitionsHelper;
import com.amazonaws.glue.catalog.util.ExpressionHelper;
import com.amazonaws.glue.catalog.util.MetastoreClientUtils;
import com.amazonaws.glue.catalog.util.PartitionKey;
import com.amazonaws.glue.shims.AwsGlueHiveShims;
import com.amazonaws.glue.shims.ShimsLoader;
import com.amazonaws.services.glue.AWSGlue;
import com.amazonaws.services.glue.model.BatchGetPartitionRequest;
import com.amazonaws.services.glue.model.BatchGetPartitionResult;
import com.amazonaws.services.glue.model.Column;
import com.amazonaws.services.glue.model.ColumnStatistics;
import com.amazonaws.services.glue.model.CreateDatabaseRequest;
import com.amazonaws.services.glue.model.CreateTableRequest;
import com.amazonaws.services.glue.model.CreateUserDefinedFunctionRequest;
import com.amazonaws.services.glue.model.DatabaseInput;
import com.amazonaws.services.glue.model.DeleteColumnStatisticsForPartitionRequest;
import com.amazonaws.services.glue.model.DeleteColumnStatisticsForTableRequest;
import com.amazonaws.services.glue.model.DeleteDatabaseRequest;
import com.amazonaws.services.glue.model.DeletePartitionRequest;
import com.amazonaws.services.glue.model.DeleteTableRequest;
import com.amazonaws.services.glue.model.DeleteUserDefinedFunctionRequest;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.GetColumnStatisticsForPartitionRequest;
import com.amazonaws.services.glue.model.GetColumnStatisticsForPartitionResult;
import com.amazonaws.services.glue.model.GetColumnStatisticsForTableRequest;
import com.amazonaws.services.glue.model.GetColumnStatisticsForTableResult;
import com.amazonaws.services.glue.model.GetDatabaseRequest;
import com.amazonaws.services.glue.model.GetDatabaseResult;
import com.amazonaws.services.glue.model.GetDatabasesRequest;
import com.amazonaws.services.glue.model.GetDatabasesResult;
import com.amazonaws.services.glue.model.GetPartitionRequest;
import com.amazonaws.services.glue.model.GetPartitionResult;
import com.amazonaws.services.glue.model.GetPartitionsRequest;
import com.amazonaws.services.glue.model.GetPartitionsResult;
import com.amazonaws.services.glue.model.GetTableRequest;
import com.amazonaws.services.glue.model.GetTableResult;
import com.amazonaws.services.glue.model.GetTablesRequest;
import com.amazonaws.services.glue.model.GetTablesResult;
import com.amazonaws.services.glue.model.GetUserDefinedFunctionRequest;
import com.amazonaws.services.glue.model.GetUserDefinedFunctionResult;
import com.amazonaws.services.glue.model.GetUserDefinedFunctionsRequest;
import com.amazonaws.services.glue.model.GetUserDefinedFunctionsResult;
import com.amazonaws.services.glue.model.Partition;
import com.amazonaws.services.glue.model.PartitionInput;
import com.amazonaws.services.glue.model.PartitionValueList;
import com.amazonaws.services.glue.model.Segment;
import com.amazonaws.services.glue.model.TableInput;
import com.amazonaws.services.glue.model.UpdateColumnStatisticsForPartitionRequest;
import com.amazonaws.services.glue.model.UpdateColumnStatisticsForPartitionResult;
import com.amazonaws.services.glue.model.UpdateColumnStatisticsForTableRequest;
import com.amazonaws.services.glue.model.UpdateColumnStatisticsForTableResult;
import com.amazonaws.services.glue.model.UpdateDatabaseRequest;
import com.amazonaws.services.glue.model.UpdatePartitionRequest;
import com.amazonaws.services.glue.model.UpdateTableRequest;
import com.amazonaws.services.glue.model.UpdateUserDefinedFunctionRequest;
import com.amazonaws.services.glue.model.UserDefinedFunction;
import com.amazonaws.services.glue.model.UserDefinedFunctionInput;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class GlueMetastoreClientDelegate {
    private static final Logger logger = Logger.getLogger(GlueMetastoreClientDelegate.class);
    private static final List<Role> implicitRoles = Lists.newArrayList((Object[])new Role[]{new Role("public", 0, "public")});
    public static final int MILLISECOND_TO_SECOND_FACTOR = 1000;
    public static final Long NO_MAX = -1L;
    public static final String MATCH_ALL = ".*";
    private static final int BATCH_CREATE_PARTITIONS_MAX_REQUEST_SIZE = 100;
    private static final int BATCH_GET_PARTITIONS_MAX_REQUEST_SIZE = 1000;
    public static final int GET_PARTITIONS_MAX_SIZE = 1000;
    public static final int GET_COLUMNS_STAT_MAX_SIZE = 100;
    public static final int UPDATE_COLUMNS_STAT_MAX_SIZE = 25;
    private static final int NUM_EXECUTOR_THREADS = 5;
    static final String GLUE_METASTORE_DELEGATE_THREADPOOL_NAME_FORMAT = "glue-metastore-delegate-%d";
    private static final ExecutorService GLUE_METASTORE_DELEGATE_THREAD_POOL = Executors.newFixedThreadPool(5, new ThreadFactoryBuilder().setNameFormat("glue-metastore-delegate-%d").setDaemon(true).build());
    public static final int DEFAULT_NUM_PARTITION_SEGMENTS = 5;
    public static final int MAX_NUM_PARTITION_SEGMENTS = 10;
    private final AWSGlue glueClient;
    private final Configuration conf;
    private final Warehouse wh;
    private final AwsGlueHiveShims hiveShims = ShimsLoader.getHiveShims();
    private final CatalogToHiveConverter catalogToHiveConverter;
    private final String catalogId;
    private final int numPartitionSegments;
    public static final String CATALOG_ID_CONF = "hive.metastore.glue.catalogid";
    public static final String NUM_PARTITION_SEGMENTS_CONF = "aws.glue.partition.num.segments";

    public GlueMetastoreClientDelegate(Configuration conf, AWSGlue glueClient, Warehouse wh) throws MetaException {
        Preconditions.checkNotNull((Object)conf, (Object)"Hive Config cannot be null");
        Preconditions.checkNotNull((Object)glueClient, (Object)"glueClient cannot be null");
        Preconditions.checkNotNull((Object)wh, (Object)"Warehouse cannot be null");
        this.numPartitionSegments = conf.getInt(NUM_PARTITION_SEGMENTS_CONF, 5);
        Preconditions.checkArgument((this.numPartitionSegments <= 10 ? 1 : 0) != 0, (Object)String.format("Hive Config [%s] can't exceed %d", NUM_PARTITION_SEGMENTS_CONF, 10));
        this.catalogToHiveConverter = CatalogToHiveConverterFactory.getCatalogToHiveConverter();
        this.conf = conf;
        this.glueClient = glueClient;
        this.wh = wh;
        this.catalogId = MetastoreClientUtils.getCatalogId(conf);
    }

    public void createDatabase(Database database) throws TException {
        Preconditions.checkNotNull((Object)database, (Object)"database cannot be null");
        if (StringUtils.isEmpty((CharSequence)database.getLocationUri())) {
            database.setLocationUri(this.wh.getDefaultDatabasePath(database.getName()).toString());
        } else {
            database.setLocationUri(this.wh.getDnsPath(new Path(database.getLocationUri())).toString());
        }
        Path dbPath = new Path(database.getLocationUri());
        boolean madeDir = MetastoreClientUtils.makeDirs(this.wh, dbPath);
        try {
            DatabaseInput catalogDatabase = GlueInputConverter.convertToDatabaseInput(database);
            CreateDatabaseRequest createDatabaseRequest = new CreateDatabaseRequest().withDatabaseInput(catalogDatabase).withCatalogId(this.catalogId);
            this.glueClient.createDatabase(createDatabaseRequest);
        }
        catch (AmazonServiceException e) {
            if (madeDir) {
                this.hiveShims.deleteDir(this.wh, dbPath, true, false);
            }
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to create database: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public Database getDatabase(String name) throws TException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)name), (Object)"name cannot be null or empty");
        try {
            GetDatabaseRequest getDatabaseRequest = new GetDatabaseRequest().withName(name).withCatalogId(this.catalogId);
            GetDatabaseResult result = this.glueClient.getDatabase(getDatabaseRequest);
            com.amazonaws.services.glue.model.Database catalogDatabase = result.getDatabase();
            return this.catalogToHiveConverter.convertDatabase(catalogDatabase);
        }
        catch (AmazonServiceException e) {
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to get database object: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public List<String> getDatabases(String pattern) throws TException {
        if (pattern == null || pattern.equals("*")) {
            pattern = MATCH_ALL;
        }
        try {
            ArrayList ret = Lists.newArrayList();
            String nextToken = null;
            do {
                GetDatabasesRequest getDatabasesRequest = new GetDatabasesRequest().withNextToken(nextToken).withCatalogId(this.catalogId);
                GetDatabasesResult result = this.glueClient.getDatabases(getDatabasesRequest);
                nextToken = result.getNextToken();
                for (com.amazonaws.services.glue.model.Database db : result.getDatabaseList()) {
                    String name = db.getName();
                    if (!Pattern.matches(pattern, name)) continue;
                    ret.add(name);
                }
            } while (nextToken != null);
            return ret;
        }
        catch (AmazonServiceException e) {
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to get databases: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public void alterDatabase(String databaseName, Database database) throws TException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)databaseName), (Object)"databaseName cannot be null or empty");
        Preconditions.checkNotNull((Object)database, (Object)"database cannot be null");
        try {
            DatabaseInput catalogDatabase = GlueInputConverter.convertToDatabaseInput(database);
            UpdateDatabaseRequest updateDatabaseRequest = new UpdateDatabaseRequest().withName(databaseName).withDatabaseInput(catalogDatabase).withCatalogId(this.catalogId);
            this.glueClient.updateDatabase(updateDatabaseRequest);
        }
        catch (AmazonServiceException e) {
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to alter database: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws TException {
        String dbLocation;
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)name), (Object)"name cannot be null or empty");
        try {
            List<String> tables = this.getTables(name, MATCH_ALL);
            boolean isEmptyDatabase = tables.isEmpty();
            Database db = this.getDatabase(name);
            dbLocation = db.getLocationUri();
            if (!isEmptyDatabase && !cascade) {
                throw new InvalidOperationException("Database " + name + " is not empty.");
            }
            DeleteDatabaseRequest deleteDatabaseRequest = new DeleteDatabaseRequest().withName(name).withCatalogId(this.catalogId);
            this.glueClient.deleteDatabase(deleteDatabaseRequest);
        }
        catch (NoSuchObjectException e) {
            if (ignoreUnknownDb) {
                return;
            }
            throw e;
        }
        catch (AmazonServiceException e) {
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to drop database: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
        if (deleteData) {
            try {
                this.hiveShims.deleteDir(this.wh, new Path(dbLocation), true, false);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to remove database directory " + dbLocation), (Throwable)e);
            }
        }
    }

    public boolean databaseExists(String dbName) throws TException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)dbName), (Object)"dbName cannot be null or empty");
        try {
            this.getDatabase(dbName);
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (AmazonServiceException e) {
            throw new TException((Throwable)e);
        }
        catch (Exception e) {
            throw new MetaException(e.getMessage());
        }
        return true;
    }

    public void createTable(Table tbl) throws TException {
        Preconditions.checkNotNull((Object)tbl, (Object)"tbl cannot be null");
        boolean dirCreated = this.validateNewTableAndCreateDirectory(tbl);
        try {
            tbl.setParameters(MetastoreClientUtils.deepCopyMap(tbl.getParameters()));
            tbl.getParameters().put("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
            TableInput tableInput = GlueInputConverter.convertToTableInput(tbl);
            CreateTableRequest createTableRequest = new CreateTableRequest().withTableInput(tableInput).withDatabaseName(tbl.getDbName()).withCatalogId(this.catalogId);
            this.glueClient.createTable(createTableRequest);
        }
        catch (AmazonServiceException e) {
            if (dirCreated) {
                Path tblPath = new Path(tbl.getSd().getLocation());
                this.hiveShims.deleteDir(this.wh, tblPath, true, false);
            }
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to create table: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public boolean tableExists(String databaseName, String tableName) throws TException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)databaseName), (Object)"databaseName cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tableName), (Object)"tableName cannot be null or empty");
        if (!this.databaseExists(databaseName)) {
            throw new UnknownDBException("Database: " + databaseName + " does not exist.");
        }
        try {
            GetTableRequest getTableRequest = new GetTableRequest().withDatabaseName(databaseName).withName(tableName).withCatalogId(this.catalogId);
            this.glueClient.getTable(getTableRequest);
            return true;
        }
        catch (EntityNotFoundException e) {
            return false;
        }
        catch (AmazonServiceException e) {
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to check table exist: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public Table getTable(String dbName, String tableName) throws TException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)dbName), (Object)"dbName cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tableName), (Object)"tableName cannot be null or empty");
        try {
            GetTableRequest getTableRequest = new GetTableRequest().withDatabaseName(dbName).withName(tableName).withCatalogId(this.catalogId);
            GetTableResult result = this.glueClient.getTable(getTableRequest);
            MetastoreClientUtils.validateGlueTable(result.getTable());
            return this.catalogToHiveConverter.convertTable(result.getTable(), dbName);
        }
        catch (AmazonServiceException e) {
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to get table: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public List<String> getTables(String dbname, String tablePattern) throws TException {
        return this.getGlueTables(dbname, tablePattern).stream().map(com.amazonaws.services.glue.model.Table::getName).collect(Collectors.toList());
    }

    private List<com.amazonaws.services.glue.model.Table> getGlueTables(String dbName, String tblPattern) throws TException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)dbName), (Object)"dbName cannot be null or empty");
        tblPattern = tblPattern.toLowerCase();
        ArrayList tables = Lists.newArrayList();
        try {
            GetTablesResult result;
            String nextToken = null;
            do {
                GetTablesRequest getTablesRequest = new GetTablesRequest().withDatabaseName(dbName).withExpression(tblPattern).withNextToken(nextToken).withCatalogId(this.catalogId);
                result = this.glueClient.getTables(getTablesRequest);
                tables.addAll(result.getTableList());
            } while ((nextToken = result.getNextToken()) != null);
            return tables;
        }
        catch (AmazonServiceException e) {
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to get tables: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public List<TableMeta> getTableMeta(String dbPatterns, String tablePatterns, List<String> tableTypes) throws TException {
        ArrayList<TableMeta> tables = new ArrayList<TableMeta>();
        List<String> databases = this.getDatabases(dbPatterns);
        for (String dbName : databases) {
            GetTablesResult result;
            String nextToken = null;
            do {
                GetTablesRequest getTablesRequest = new GetTablesRequest().withDatabaseName(dbName).withExpression(tablePatterns).withNextToken(nextToken).withCatalogId(this.catalogId);
                result = this.glueClient.getTables(getTablesRequest);
                for (com.amazonaws.services.glue.model.Table catalogTable : result.getTableList()) {
                    if (tableTypes != null && !tableTypes.isEmpty() && !tableTypes.contains(catalogTable.getTableType())) continue;
                    tables.add(this.catalogToHiveConverter.convertTableMeta(catalogTable, dbName));
                }
            } while ((nextToken = result.getNextToken()) != null);
        }
        return tables;
    }

    public void alterTable(String dbName, String oldTableName, Table newTable, EnvironmentContext environmentContext) throws TException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)dbName), (Object)"dbName cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)oldTableName), (Object)"oldTableName cannot be null or empty");
        Preconditions.checkNotNull((Object)newTable, (Object)"newTable cannot be null");
        if (!oldTableName.equalsIgnoreCase(newTable.getTableName())) {
            throw new UnsupportedOperationException("Table rename is not supported");
        }
        MetastoreClientUtils.validateTableObject(newTable, this.conf);
        if (!this.tableExists(dbName, oldTableName)) {
            throw new UnknownTableException("Table: " + oldTableName + " does not exists");
        }
        boolean isExternal = Boolean.parseBoolean((String)newTable.getParameters().get("EXTERNAL"));
        if (TableType.MANAGED_TABLE.toString().equals(newTable.getTableType()) && isExternal) {
            newTable.setTableType(TableType.EXTERNAL_TABLE.toString());
        } else if (TableType.EXTERNAL_TABLE.toString().equals(newTable.getTableType()) && !isExternal) {
            newTable.setTableType(TableType.MANAGED_TABLE.toString());
        }
        if (this.hiveShims.requireCalStats(this.conf, null, null, newTable, environmentContext) && newTable.getPartitionKeys().isEmpty()) {
            Database db = this.getDatabase(newTable.getDbName());
            this.hiveShims.updateTableStatsFast(db, newTable, this.wh, false, true, environmentContext);
        }
        TableInput newTableInput = GlueInputConverter.convertToTableInput(newTable);
        try {
            UpdateTableRequest updateTableRequest = new UpdateTableRequest().withDatabaseName(dbName).withTableInput(newTableInput).withCatalogId(this.catalogId);
            this.glueClient.updateTable(updateTableRequest);
        }
        catch (AmazonServiceException e) {
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to alter table: " + oldTableName;
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
        if (!newTable.getPartitionKeys().isEmpty() && this.isCascade(environmentContext)) {
            List<Object> partitions;
            logger.info((Object)"Only column related changes can be cascaded in alterTable.");
            try {
                partitions = this.getCatalogPartitions(dbName, oldTableName, null, -1L);
            }
            catch (TException e) {
                String msg = "Failed to fetch partitions from metastore during alterTable cascade operation.";
                logger.error((Object)msg, (Throwable)e);
                throw new MetaException(msg + (Object)((Object)e));
            }
            try {
                partitions = ((Stream)partitions.parallelStream().unordered()).distinct().collect(Collectors.toList());
                this.alterPartitionsColumnsParallel(dbName, oldTableName, partitions, newTableInput.getStorageDescriptor().getColumns());
            }
            catch (TException e) {
                String msg = "Failed to alter partitions during alterTable cascade operation.";
                logger.error((Object)msg, (Throwable)e);
                throw new MetaException(msg + (Object)((Object)e));
            }
        }
    }

    private boolean isCascade(EnvironmentContext environmentContext) {
        return environmentContext != null && environmentContext.isSetProperties() && "true".equals(environmentContext.getProperties().get("CASCADE"));
    }

    public void dropTable(String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTbl, boolean ifPurge) throws TException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)dbName), (Object)"dbName cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tableName), (Object)"tableName cannot be null or empty");
        if (!this.tableExists(dbName, tableName)) {
            if (!ignoreUnknownTbl) {
                throw new UnknownTableException("Cannot find table: " + dbName + "." + tableName);
            }
            return;
        }
        Table tbl = this.getTable(dbName, tableName);
        String tblLocation = tbl.getSd().getLocation();
        boolean isExternal = MetastoreClientUtils.isExternalTable(tbl);
        this.dropPartitionsForTable(dbName, tableName, deleteData && !isExternal);
        try {
            DeleteTableRequest deleteTableRequest = new DeleteTableRequest().withDatabaseName(dbName).withName(tableName).withCatalogId(this.catalogId);
            this.glueClient.deleteTable(deleteTableRequest);
        }
        catch (AmazonServiceException e) {
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to drop table: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
        if (StringUtils.isNotEmpty((CharSequence)tblLocation) && deleteData && !isExternal) {
            Path tblPath = new Path(tblLocation);
            try {
                this.hiveShims.deleteDir(this.wh, tblPath, true, ifPurge);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to remove table directory " + tblPath), (Throwable)e);
            }
        }
    }

    private void dropPartitionsForTable(String dbName, String tableName, boolean deleteData) throws TException {
        List<org.apache.hadoop.hive.metastore.api.Partition> partitionsToDelete = this.getPartitions(dbName, tableName, null, NO_MAX);
        for (org.apache.hadoop.hive.metastore.api.Partition part : partitionsToDelete) {
            this.dropPartition(dbName, tableName, part.getValues(), true, deleteData, false);
        }
    }

    public List<String> getTables(String dbname, String tablePattern, TableType tableType) throws TException {
        return this.getGlueTables(dbname, tablePattern).stream().filter(table -> tableType.toString().equals(table.getTableType())).map(com.amazonaws.services.glue.model.Table::getName).collect(Collectors.toList());
    }

    public List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws TException {
        throw new UnsupportedOperationException("listTableNamesByFilter is not supported");
    }

    public boolean validateNewTableAndCreateDirectory(Table tbl) throws TException {
        Preconditions.checkNotNull((Object)tbl, (Object)"tbl cannot be null");
        if (this.tableExists(tbl.getDbName(), tbl.getTableName())) {
            throw new AlreadyExistsException("Table " + tbl.getTableName() + " already exists.");
        }
        MetastoreClientUtils.validateTableObject(tbl, this.conf);
        if (TableType.VIRTUAL_VIEW.toString().equals(tbl.getTableType())) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)tbl.getSd().getLocation())) {
            Database db = this.getDatabase(tbl.getDbName());
            tbl.getSd().setLocation(this.hiveShims.getDefaultTablePath(db, tbl.getTableName(), this.wh).toString());
        } else {
            tbl.getSd().setLocation(this.wh.getDnsPath(new Path(tbl.getSd().getLocation())).toString());
        }
        Path tblPath = new Path(tbl.getSd().getLocation());
        return MetastoreClientUtils.makeDirs(this.wh, tblPath);
    }

    public org.apache.hadoop.hive.metastore.api.Partition appendPartition(String dbName, String tblName, List<String> values) throws TException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)dbName), (Object)"dbName cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tblName), (Object)"tblName cannot be null or empty");
        Preconditions.checkNotNull(values, (Object)"partition values cannot be null");
        Table table = this.getTable(dbName, tblName);
        Preconditions.checkNotNull((Object)table.getSd(), (Object)("StorageDescriptor cannot be null for Table " + tblName));
        org.apache.hadoop.hive.metastore.api.Partition partition = this.buildPartitionFromValues(table, values);
        this.addPartitions(Lists.newArrayList((Object[])new org.apache.hadoop.hive.metastore.api.Partition[]{partition}), false, true);
        return partition;
    }

    private org.apache.hadoop.hive.metastore.api.Partition buildPartitionFromValues(Table table, List<String> values) throws MetaException {
        org.apache.hadoop.hive.metastore.api.Partition partition = new org.apache.hadoop.hive.metastore.api.Partition();
        partition.setDbName(table.getDbName());
        partition.setTableName(table.getTableName());
        partition.setValues(values);
        partition.setSd(table.getSd().deepCopy());
        Path partLocation = new Path(table.getSd().getLocation(), Warehouse.makePartName((List)table.getPartitionKeys(), values));
        partition.getSd().setLocation(partLocation.toString());
        long timeInSecond = System.currentTimeMillis() / 1000L;
        partition.setCreateTime((int)timeInSecond);
        partition.putToParameters("transient_lastDdlTime", Long.toString(timeInSecond));
        return partition;
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> addPartitions(List<org.apache.hadoop.hive.metastore.api.Partition> partitions, boolean ifNotExists, boolean needResult) throws TException {
        Preconditions.checkNotNull(partitions, (Object)"partitions cannot be null");
        List<Partition> partitionsCreated = this.batchCreatePartitions(partitions, ifNotExists);
        if (!needResult) {
            return null;
        }
        return this.catalogToHiveConverter.convertPartitions(partitionsCreated);
    }

    private List<Partition> batchCreatePartitions(List<org.apache.hadoop.hive.metastore.api.Partition> hivePartitions, final boolean ifNotExists) throws TException {
        if (hivePartitions.isEmpty()) {
            return Lists.newArrayList();
        }
        final String dbName = hivePartitions.get(0).getDbName();
        final String tableName = hivePartitions.get(0).getTableName();
        Table tbl = this.getTable(dbName, tableName);
        this.validateInputForBatchCreatePartitions(tbl, hivePartitions);
        ArrayList catalogPartitions = Lists.newArrayList();
        HashMap addedPath = Maps.newHashMap();
        try {
            for (org.apache.hadoop.hive.metastore.api.Partition partition : hivePartitions) {
                Path location = this.getPartitionLocation(tbl, partition);
                boolean partDirCreated = false;
                if (location != null) {
                    partition.getSd().setLocation(location.toString());
                    partDirCreated = MetastoreClientUtils.makeDirs(this.wh, location);
                }
                Partition catalogPartition = HiveToCatalogConverter.convertPartition(partition);
                catalogPartitions.add(catalogPartition);
                if (!partDirCreated) continue;
                addedPath.put(new PartitionKey(catalogPartition), new Path(partition.getSd().getLocation()));
            }
        }
        catch (MetaException e) {
            for (Path path : addedPath.values()) {
                this.deletePath(path);
            }
            throw e;
        }
        ArrayList batchCreatePartitionsFutures = Lists.newArrayList();
        for (int i = 0; i < catalogPartitions.size(); i += 100) {
            int j = Math.min(i + 100, catalogPartitions.size());
            final List partitionsOnePage = catalogPartitions.subList(i, j);
            batchCreatePartitionsFutures.add(GLUE_METASTORE_DELEGATE_THREAD_POOL.submit(new Callable<BatchCreatePartitionsHelper>(){

                @Override
                public BatchCreatePartitionsHelper call() throws Exception {
                    return new BatchCreatePartitionsHelper(GlueMetastoreClientDelegate.this.glueClient, dbName, tableName, GlueMetastoreClientDelegate.this.catalogId, partitionsOnePage, ifNotExists).createPartitions();
                }
            }));
        }
        TException tException = null;
        ArrayList partitionsCreated = Lists.newArrayList();
        for (Future future : batchCreatePartitionsFutures) {
            try {
                BatchCreatePartitionsHelper batchCreatePartitionsHelper = (BatchCreatePartitionsHelper)future.get();
                partitionsCreated.addAll(batchCreatePartitionsHelper.getPartitionsCreated());
                tException = tException == null ? batchCreatePartitionsHelper.getFirstTException() : tException;
                this.deletePathForPartitions(batchCreatePartitionsHelper.getPartitionsFailed(), addedPath);
            }
            catch (Exception e) {
                logger.error((Object)"Exception thrown by BatchCreatePartitions thread pool. ", (Throwable)e);
            }
        }
        if (tException != null) {
            throw tException;
        }
        return partitionsCreated;
    }

    private void validateInputForBatchCreatePartitions(Table tbl, List<org.apache.hadoop.hive.metastore.api.Partition> hivePartitions) {
        Preconditions.checkNotNull((Object)tbl.getPartitionKeys(), (Object)"Partition keys cannot be null");
        for (org.apache.hadoop.hive.metastore.api.Partition partition : hivePartitions) {
            Preconditions.checkArgument((boolean)tbl.getDbName().equals(partition.getDbName()), (Object)"Partitions must be in the same DB");
            Preconditions.checkArgument((boolean)tbl.getTableName().equals(partition.getTableName()), (Object)"Partitions must be in the same table");
            Preconditions.checkNotNull((Object)partition.getValues(), (Object)"Partition values cannot be null");
            Preconditions.checkArgument((tbl.getPartitionKeys().size() == partition.getValues().size() ? 1 : 0) != 0, (Object)"Number of table partition keys must match number of partition values");
        }
    }

    private void deletePathForPartitions(List<Partition> partitions, Map<PartitionKey, Path> addedPath) {
        for (Partition partition : partitions) {
            Path path = addedPath.get(new PartitionKey(partition));
            if (path == null) continue;
            this.deletePath(path);
        }
    }

    private void deletePath(Path path) {
        try {
            this.hiveShims.deleteDir(this.wh, path, true, false);
        }
        catch (MetaException e) {
            logger.error((Object)"Warehouse delete directory failed. ", (Throwable)e);
        }
    }

    private Path getPartitionLocation(Table tbl, org.apache.hadoop.hive.metastore.api.Partition part) throws MetaException {
        Path partLocation = null;
        String partLocationStr = null;
        if (part.getSd() != null) {
            partLocationStr = part.getSd().getLocation();
        }
        if (StringUtils.isEmpty(partLocationStr)) {
            if (tbl.getSd().getLocation() != null) {
                partLocation = new Path(tbl.getSd().getLocation(), Warehouse.makePartName((List)tbl.getPartitionKeys(), (List)part.getValues()));
            }
        } else {
            if (tbl.getSd().getLocation() == null) {
                throw new MetaException("Cannot specify location for a view partition");
            }
            partLocation = this.wh.getDnsPath(new Path(partLocationStr));
        }
        return partLocation;
    }

    public List<String> listPartitionNames(String databaseName, String tableName, List<String> values, short max) throws TException {
        String expression = null;
        Table table = this.getTable(databaseName, tableName);
        if (values != null) {
            expression = ExpressionHelper.buildExpressionFromPartialSpecification(table, values);
        }
        ArrayList names = Lists.newArrayList();
        List<org.apache.hadoop.hive.metastore.api.Partition> partitions = this.getPartitions(databaseName, tableName, expression, max);
        for (org.apache.hadoop.hive.metastore.api.Partition p : partitions) {
            names.add(Warehouse.makePartName((List)table.getPartitionKeys(), (List)p.getValues()));
        }
        return names;
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) throws TException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)databaseName), (Object)"databaseName cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tableName), (Object)"tableName cannot be null or empty");
        Preconditions.checkNotNull(partitionNames, (Object)"partitionNames cannot be null");
        ArrayList partitionsToGet = Lists.newArrayList();
        for (String partitionName : partitionNames) {
            partitionsToGet.add(new PartitionValueList().withValues(this.partitionNameToVals(partitionName)));
        }
        List batchedPartitionsToGet = Lists.partition((List)partitionsToGet, (int)1000);
        ArrayList batchGetPartitionFutures = Lists.newArrayList();
        for (Object batch : batchedPartitionsToGet) {
            final BatchGetPartitionRequest request = new BatchGetPartitionRequest().withDatabaseName(databaseName).withTableName(tableName).withPartitionsToGet((Collection)batch).withCatalogId(this.catalogId);
            batchGetPartitionFutures.add(GLUE_METASTORE_DELEGATE_THREAD_POOL.submit(new Callable<BatchGetPartitionResult>(){

                @Override
                public BatchGetPartitionResult call() throws Exception {
                    return GlueMetastoreClientDelegate.this.glueClient.batchGetPartition(request);
                }
            }));
        }
        ArrayList result = Lists.newArrayList();
        try {
            for (Future future : batchGetPartitionFutures) {
                result.addAll(this.catalogToHiveConverter.convertPartitions(((BatchGetPartitionResult)future.get()).getPartitions()));
            }
        }
        catch (ExecutionException e) {
            throw this.catalogToHiveConverter.wrapInHiveException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return result;
    }

    public org.apache.hadoop.hive.metastore.api.Partition getPartition(String dbName, String tblName, String partitionName) throws TException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)dbName), (Object)"dbName cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tblName), (Object)"tblName cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)partitionName), (Object)"partitionName cannot be null or empty");
        List<String> values = this.partitionNameToVals(partitionName);
        return this.getPartition(dbName, tblName, values);
    }

    public org.apache.hadoop.hive.metastore.api.Partition getPartition(String dbName, String tblName, List<String> values) throws TException {
        Partition partition;
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)dbName), (Object)"dbName cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tblName), (Object)"tblName cannot be null or empty");
        Preconditions.checkNotNull(values, (Object)"values cannot be null");
        GetPartitionRequest request = new GetPartitionRequest().withDatabaseName(dbName).withTableName(tblName).withPartitionValues(values).withCatalogId(this.catalogId);
        try {
            GetPartitionResult res = this.glueClient.getPartition(request);
            partition = res.getPartition();
            if (partition == null) {
                logger.debug((Object)("No partitions were return for dbName = " + dbName + ", tblName = " + tblName + ", values = " + values));
                return null;
            }
        }
        catch (AmazonServiceException e) {
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to get partition with values: " + StringUtils.join(values, (String)"/");
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
        return this.catalogToHiveConverter.convertPartition(partition);
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> getPartitions(String databaseName, String tableName, String filter, long max) throws TException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)databaseName), (Object)"databaseName cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tableName), (Object)"tableName cannot be null or empty");
        List<Partition> partitions = this.getCatalogPartitions(databaseName, tableName, filter, max);
        return this.catalogToHiveConverter.convertPartitions(partitions);
    }

    public List<Partition> getCatalogPartitions(String databaseName, String tableName, String expression, long max) throws TException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)databaseName), (Object)"databaseName cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tableName), (Object)"tableName cannot be null or empty");
        if (max == 0L) {
            return Collections.emptyList();
        }
        if (max < 0L || max > 1000L) {
            return this.getPartitionsParallel(databaseName, tableName, expression, max);
        }
        return this.getCatalogPartitions(databaseName, tableName, expression, max, null);
    }

    private List<Partition> getPartitionsParallel(final String databaseName, final String tableName, final String expression, final long max) throws TException {
        ArrayList segments = Lists.newArrayList();
        for (int i = 0; i < this.numPartitionSegments; ++i) {
            segments.add(new Segment().withSegmentNumber(Integer.valueOf(i)).withTotalSegments(Integer.valueOf(this.numPartitionSegments)));
        }
        ArrayList futures = Lists.newArrayList();
        for (Object segment : segments) {
            futures.add(GLUE_METASTORE_DELEGATE_THREAD_POOL.submit(new Callable<List<Partition>>((Segment)segment){
                final /* synthetic */ Segment val$segment;
                {
                    this.val$segment = segment;
                }

                @Override
                public List<Partition> call() throws Exception {
                    return GlueMetastoreClientDelegate.this.getCatalogPartitions(databaseName, tableName, expression, max, this.val$segment);
                }
            }));
        }
        ArrayList partitions = Lists.newArrayList();
        try {
            for (Future future : futures) {
                List segmentPartitions = (List)future.get();
                if ((long)(partitions.size() + segmentPartitions.size()) >= max && max > 0L) {
                    long remaining = max - (long)partitions.size();
                    partitions.addAll(segmentPartitions.subList(0, (int)remaining));
                    break;
                }
                partitions.addAll(segmentPartitions);
            }
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), TException.class);
            Throwables.propagate((Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return partitions;
    }

    private void alterPartitionsColumnsParallel(String databaseName, String tableName, List<Partition> partitions, List<Column> newCols) throws TException {
        List<Pair> partitionFuturePairs = Collections.synchronizedList(Lists.newArrayList());
        partitions.parallelStream().forEach(partition -> partitionFuturePairs.add(Pair.of((Object)partition, GLUE_METASTORE_DELEGATE_THREAD_POOL.submit(() -> this.alterPartitionColumns(databaseName, tableName, (Partition)partition, newCols)))));
        ArrayList<List> failedPartitionValues = new ArrayList<List>();
        for (Pair partitionFuturePair : partitionFuturePairs) {
            try {
                ((Future)partitionFuturePair.getRight()).get();
            }
            catch (ExecutionException e) {
                String msg = "Failed while attempting to alterPartition: " + ((Partition)partitionFuturePair.getLeft()).getValues() + ". Because of: ";
                logger.error((Object)msg, (Throwable)e);
                failedPartitionValues.add(((Partition)partitionFuturePair.getLeft()).getValues());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!failedPartitionValues.isEmpty()) {
            throw new MetaException("AlterPartitions has failed for the partitions: " + failedPartitionValues);
        }
    }

    private void alterPartitionColumns(String databaseName, String tableName, Partition origPartition, List<Column> newCols) {
        origPartition.setParameters(MetastoreClientUtils.deepCopyMap(origPartition.getParameters()));
        if (origPartition.getParameters().get("transient_lastDdlTime") == null || Integer.parseInt((String)origPartition.getParameters().get("transient_lastDdlTime")) == 0) {
            origPartition.getParameters().put("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
        }
        origPartition.getStorageDescriptor().setColumns(newCols);
        PartitionInput partitionInput = GlueInputConverter.convertToPartitionInput(origPartition);
        UpdatePartitionRequest request = new UpdatePartitionRequest().withDatabaseName(databaseName).withTableName(tableName).withPartitionInput(partitionInput).withPartitionValueList((Collection)origPartition.getValues()).withCatalogId(this.catalogId);
        this.glueClient.updatePartition(request);
    }

    private List<Partition> getCatalogPartitions(String databaseName, String tableName, String expression, long max, Segment segment) throws TException {
        ArrayList partitions = Lists.newArrayList();
        String nextToken = null;
        do {
            GetPartitionsRequest request = new GetPartitionsRequest().withDatabaseName(databaseName).withTableName(tableName).withExpression(expression).withNextToken(nextToken).withCatalogId(this.catalogId).withSegment(segment);
            try {
                GetPartitionsResult res = this.glueClient.getPartitions(request);
                List list = res.getPartitions();
                if ((long)(partitions.size() + list.size()) >= max && max > 0L) {
                    long remaining = max - (long)partitions.size();
                    partitions.addAll(list.subList(0, (int)remaining));
                    break;
                }
                partitions.addAll(list);
                nextToken = res.getNextToken();
            }
            catch (AmazonServiceException e) {
                throw this.catalogToHiveConverter.wrapInHiveException(e);
            }
            catch (Exception e) {
                String msg = "Unable to get partitions with expression: " + expression;
                logger.error((Object)msg, (Throwable)e);
                throw new MetaException(msg + e);
            }
        } while (nextToken != null);
        return partitions;
    }

    public boolean dropPartition(String dbName, String tblName, List<String> values, boolean ifExist, boolean deleteData, boolean purgeData) throws TException {
        org.apache.hadoop.hive.metastore.api.Partition partition;
        block5: {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)dbName), (Object)"dbName cannot be null or empty");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tblName), (Object)"tblName cannot be null or empty");
            Preconditions.checkNotNull(values, (Object)"values cannot be null");
            partition = null;
            try {
                partition = this.getPartition(dbName, tblName, values);
            }
            catch (NoSuchObjectException e) {
                if (!ifExist) break block5;
                return true;
            }
        }
        try {
            DeletePartitionRequest request = new DeletePartitionRequest().withDatabaseName(dbName).withTableName(tblName).withPartitionValues(values).withCatalogId(this.catalogId);
            this.glueClient.deletePartition(request);
        }
        catch (AmazonServiceException e) {
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to drop partition with values: " + StringUtils.join(values, (String)"/");
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
        this.performDropPartitionPostProcessing(dbName, tblName, partition, deleteData, purgeData);
        return true;
    }

    private void performDropPartitionPostProcessing(String dbName, String tblName, org.apache.hadoop.hive.metastore.api.Partition partition, boolean deleteData, boolean ifPurge) throws TException {
        if (deleteData && partition.getSd() != null && partition.getSd().getLocation() != null) {
            Path partPath = new Path(partition.getSd().getLocation());
            Table table = this.getTable(dbName, tblName);
            if (MetastoreClientUtils.isExternalTable(table)) {
                return;
            }
            boolean mustPurge = this.isMustPurge(table, ifPurge);
            this.hiveShims.deleteDir(this.wh, partPath, true, mustPurge);
            try {
                List values = partition.getValues();
                this.deleteParentRecursive(partPath.getParent(), values.size() - 1, mustPurge);
            }
            catch (IOException e) {
                throw new MetaException(e.getMessage());
            }
        }
    }

    private boolean isMustPurge(Table table, boolean ifPurge) {
        return ifPurge || "true".equalsIgnoreCase((String)table.getParameters().get("auto.purge"));
    }

    private void deleteParentRecursive(Path parent, int depth, boolean mustPurge) throws IOException, MetaException {
        if (depth > 0 && parent != null && this.wh.isWritable(parent) && this.wh.isEmpty(parent)) {
            this.hiveShims.deleteDir(this.wh, parent, true, mustPurge);
            this.deleteParentRecursive(parent.getParent(), depth - 1, mustPurge);
        }
    }

    public void alterPartitions(String dbName, String tblName, List<org.apache.hadoop.hive.metastore.api.Partition> partitions) throws TException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)dbName), (Object)"dbName cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tblName), (Object)"tblName cannot be null or empty");
        Preconditions.checkNotNull(partitions, (Object)"partitions cannot be null");
        for (org.apache.hadoop.hive.metastore.api.Partition part : partitions) {
            part.setParameters(MetastoreClientUtils.deepCopyMap(part.getParameters()));
            if (part.getParameters().get("transient_lastDdlTime") == null || Integer.parseInt((String)part.getParameters().get("transient_lastDdlTime")) == 0) {
                part.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
            }
            PartitionInput partitionInput = GlueInputConverter.convertToPartitionInput(part);
            UpdatePartitionRequest request = new UpdatePartitionRequest().withDatabaseName(dbName).withTableName(tblName).withPartitionInput(partitionInput).withPartitionValueList((Collection)part.getValues()).withCatalogId(this.catalogId);
            try {
                this.glueClient.updatePartition(request);
            }
            catch (AmazonServiceException e) {
                throw this.catalogToHiveConverter.wrapInHiveException(e);
            }
            catch (Exception e) {
                String msg = "Unable to alter partition: ";
                logger.error((Object)msg, (Throwable)e);
                throw new MetaException(msg + e);
            }
        }
    }

    public List<String> partitionNameToVals(String name) throws TException {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        if (name.isEmpty()) {
            return Lists.newArrayList();
        }
        LinkedHashMap map = Warehouse.makeSpecFromName((String)name);
        ArrayList vals = Lists.newArrayList();
        vals.addAll(map.values());
        return vals;
    }

    public boolean createRole(Role role) throws TException {
        throw new UnsupportedOperationException("createRole is not supported");
    }

    public boolean dropRole(String roleName) throws TException {
        throw new UnsupportedOperationException("dropRole is not supported");
    }

    public List<Role> listRoles(String principalName, PrincipalType principalType) throws TException {
        if (principalType == PrincipalType.USER) {
            return implicitRoles;
        }
        throw new UnsupportedOperationException("listRoles is only supported for " + PrincipalType.USER + " Principal type");
    }

    public List<String> listRoleNames() throws TException {
        return Lists.newArrayList((Object[])new String[]{"public"});
    }

    public GetPrincipalsInRoleResponse getPrincipalsInRole(GetPrincipalsInRoleRequest request) throws TException {
        throw new UnsupportedOperationException("getPrincipalsInRole is not supported");
    }

    public GetRoleGrantsForPrincipalResponse getRoleGrantsForPrincipal(GetRoleGrantsForPrincipalRequest request) throws TException {
        throw new UnsupportedOperationException("getRoleGrantsForPrincipal is not supported");
    }

    public boolean grantRole(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws TException {
        throw new UnsupportedOperationException("grantRole is not supported");
    }

    public boolean revokeRole(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws TException {
        throw new UnsupportedOperationException("revokeRole is not supported");
    }

    public boolean revokePrivileges(PrivilegeBag privileges, boolean grantOption) throws TException {
        throw new UnsupportedOperationException("revokePrivileges is not supported");
    }

    public boolean grantPrivileges(PrivilegeBag privileges) throws TException {
        throw new UnsupportedOperationException("grantPrivileges is not supported");
    }

    public PrincipalPrivilegeSet getPrivilegeSet(HiveObjectRef objectRef, String user, List<String> groups) throws TException {
        return null;
    }

    public List<HiveObjectPrivilege> listPrivileges(String principal, PrincipalType principalType, HiveObjectRef objectRef) throws TException {
        throw new UnsupportedOperationException("listPrivileges is not supported");
    }

    public boolean deletePartitionColumnStatistics(String dbName, String tblName, String partName, String colName) throws TException {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)dbName) ? 1 : 0) != 0, (Object)"Database name cannot be equal to null or empty");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)tblName) ? 1 : 0) != 0, (Object)"Table name cannot be equal to null or empty");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)colName) ? 1 : 0) != 0, (Object)"Column name cannot be equal to null or empty");
        List<String> partValues = PartitionNameParser.getPartitionValuesFromName(partName);
        for (String partitionValue : partValues) {
            Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)partitionValue) ? 1 : 0) != 0, (Object)"Partition name cannot be equal to null or empty");
        }
        try {
            DeleteColumnStatisticsForPartitionRequest request = new DeleteColumnStatisticsForPartitionRequest().withCatalogId(this.catalogId).withDatabaseName(dbName).withTableName(tblName).withPartitionValues(partValues).withColumnName(colName);
            this.glueClient.deleteColumnStatisticsForPartition(request);
            return true;
        }
        catch (AmazonServiceException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to delete partition column statistics: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public boolean deleteTableColumnStatistics(String dbName, String tblName, String colName) throws TException {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)dbName) ? 1 : 0) != 0, (Object)"Database name cannot be equal to null or empty");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)tblName) ? 1 : 0) != 0, (Object)"Table name cannot be equal to null or empty");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)colName) ? 1 : 0) != 0, (Object)"Column name cannot be equal to null or empty");
        try {
            DeleteColumnStatisticsForTableRequest request = new DeleteColumnStatisticsForTableRequest().withCatalogId(this.catalogId).withDatabaseName(dbName).withTableName(tblName).withColumnName(colName);
            this.glueClient.deleteColumnStatisticsForTable(request);
            return true;
        }
        catch (AmazonServiceException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to delete table column statistics: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tblName, List<String> partNames, List<String> colNames) throws TException {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)dbName) ? 1 : 0) != 0, (Object)"Database name cannot be equal to null or empty");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)tblName) ? 1 : 0) != 0, (Object)"Table name cannot be equal to null or empty");
        for (String partitionName : partNames) {
            Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)partitionName) ? 1 : 0) != 0, (Object)"Partition name cannot be equal to null or empty");
        }
        for (String columnName : colNames) {
            Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)columnName) ? 1 : 0) != 0, (Object)"Column name cannot be equal to null or empty");
        }
        HashMap<String, List<ColumnStatisticsObj>> hivePartitionStatistics = new HashMap<String, List<ColumnStatisticsObj>>();
        List pagedColNames = Lists.partition(colNames, (int)100);
        for (String partName : partNames) {
            List<String> partValues = PartitionNameParser.getPartitionValuesFromName(partName);
            ArrayList<Future<GetColumnStatisticsForPartitionResult>> pagedResult = new ArrayList<Future<GetColumnStatisticsForPartitionResult>>();
            for (List cols : pagedColNames) {
                final GetColumnStatisticsForPartitionRequest getColumnStatisticsForPartitionRequest = new GetColumnStatisticsForPartitionRequest().withCatalogId(this.catalogId).withDatabaseName(dbName).withTableName(tblName).withPartitionValues(partValues).withColumnNames((Collection)cols);
                pagedResult.add(GLUE_METASTORE_DELEGATE_THREAD_POOL.submit(new Callable<GetColumnStatisticsForPartitionResult>(){

                    @Override
                    public GetColumnStatisticsForPartitionResult call() throws Exception {
                        return GlueMetastoreClientDelegate.this.glueClient.getColumnStatisticsForPartition(getColumnStatisticsForPartitionRequest);
                    }
                }));
            }
            ArrayList<ColumnStatisticsObj> hiveResult = new ArrayList<ColumnStatisticsObj>();
            for (Future future : pagedResult) {
                try {
                    hiveResult.addAll(this.catalogToHiveConverter.convertColumnStatisticsList(((GetColumnStatisticsForPartitionResult)future.get()).getColumnStatisticsList()));
                }
                catch (ExecutionException e) {
                    logger.error((Object)("Unable to get some partition column statistics for partition " + partName), (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            hivePartitionStatistics.put(partName, hiveResult);
        }
        return hivePartitionStatistics;
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tblName, List<String> colNames) throws TException {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)dbName) ? 1 : 0) != 0, (Object)"Database name cannot be equal to null or empty");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)tblName) ? 1 : 0) != 0, (Object)"Table name cannot be equal to null or empty");
        for (String columnName : colNames) {
            Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)columnName) ? 1 : 0) != 0, (Object)"Column name cannot be equal to null or empty");
        }
        List pagedColNames = Lists.partition(colNames, (int)100);
        ArrayList<Future<GetColumnStatisticsForTableResult>> pagedResult = new ArrayList<Future<GetColumnStatisticsForTableResult>>();
        for (List cols : pagedColNames) {
            final GetColumnStatisticsForTableRequest getColumnStatisticsForTableRequest = new GetColumnStatisticsForTableRequest().withCatalogId(this.catalogId).withDatabaseName(dbName).withTableName(tblName).withColumnNames((Collection)cols);
            pagedResult.add(GLUE_METASTORE_DELEGATE_THREAD_POOL.submit(new Callable<GetColumnStatisticsForTableResult>(){

                @Override
                public GetColumnStatisticsForTableResult call() throws Exception {
                    return GlueMetastoreClientDelegate.this.glueClient.getColumnStatisticsForTable(getColumnStatisticsForTableRequest);
                }
            }));
        }
        ArrayList<ColumnStatisticsObj> results = new ArrayList<ColumnStatisticsObj>();
        for (Future future : pagedResult) {
            try {
                results.addAll(this.catalogToHiveConverter.convertColumnStatisticsList(((GetColumnStatisticsForTableResult)future.get()).getColumnStatisticsList()));
            }
            catch (ExecutionException e) {
                logger.error((Object)"Unable to get table column statistics", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return results;
    }

    public boolean updatePartitionColumnStatistics(org.apache.hadoop.hive.metastore.api.ColumnStatistics columnStatistics) throws TException {
        String dbName = columnStatistics.getStatsDesc().getDbName();
        String tblName = columnStatistics.getStatsDesc().getTableName();
        List<String> partValues = PartitionNameParser.getPartitionValuesFromName(columnStatistics.getStatsDesc().getPartName());
        List<ColumnStatistics> statisticsList = HiveToCatalogConverter.convertColumnStatisticsObjList(columnStatistics);
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)dbName) ? 1 : 0) != 0, (Object)"Database name cannot be equal to null or empty");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)tblName) ? 1 : 0) != 0, (Object)"Table name cannot be equal to null or empty");
        Preconditions.checkArgument((statisticsList != null && !statisticsList.isEmpty() ? 1 : 0) != 0, (Object)"List of column statistics objects cannot be equal to null or empty");
        for (String partitionValue : partValues) {
            Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)partitionValue) ? 1 : 0) != 0, (Object)"Partition name cannot be equal to null or empty");
        }
        for (ColumnStatistics statistics : statisticsList) {
            Preconditions.checkArgument((statistics != null ? 1 : 0) != 0, (Object)"Column statistics object cannot be equal to null");
        }
        List statisticsListPaged = Lists.partition(statisticsList, (int)25);
        ArrayList<Future<UpdateColumnStatisticsForPartitionResult>> pagedResult = new ArrayList<Future<UpdateColumnStatisticsForPartitionResult>>();
        for (Object statList : statisticsListPaged) {
            final UpdateColumnStatisticsForPartitionRequest updateColumnStatisticsForPartitionRequest = new UpdateColumnStatisticsForPartitionRequest().withCatalogId(this.catalogId).withDatabaseName(dbName).withTableName(tblName).withPartitionValues(partValues).withColumnStatisticsList((Collection)statList);
            pagedResult.add(GLUE_METASTORE_DELEGATE_THREAD_POOL.submit(new Callable<UpdateColumnStatisticsForPartitionResult>(){

                @Override
                public UpdateColumnStatisticsForPartitionResult call() throws Exception {
                    return GlueMetastoreClientDelegate.this.glueClient.updateColumnStatisticsForPartition(updateColumnStatisticsForPartitionRequest);
                }
            }));
        }
        ArrayList columnStatisticsErrors = new ArrayList();
        try {
            for (Future future : pagedResult) {
                Optional.ofNullable(((UpdateColumnStatisticsForPartitionResult)future.get()).getErrors()).ifPresent(error -> columnStatisticsErrors.addAll(error));
            }
            if (columnStatisticsErrors.size() > 0) {
                logger.error((Object)("Cannot update all provided column statistics. List of failures: " + ((Object)columnStatisticsErrors).toString()));
                return false;
            }
            return true;
        }
        catch (ExecutionException e) {
            throw this.catalogToHiveConverter.wrapInHiveException(e.getCause());
        }
        catch (Exception e) {
            String string = "Unable to update partition column statistics: ";
            logger.error((Object)string, (Throwable)e);
            throw new MetaException(string + e);
        }
    }

    public boolean updateTableColumnStatistics(org.apache.hadoop.hive.metastore.api.ColumnStatistics columnStatistics) throws TException {
        String dbName = columnStatistics.getStatsDesc().getDbName();
        String tblName = columnStatistics.getStatsDesc().getTableName();
        List<ColumnStatistics> statisticsList = HiveToCatalogConverter.convertColumnStatisticsObjList(columnStatistics);
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)dbName) ? 1 : 0) != 0, (Object)"Database name cannot be equal to null or empty");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)tblName) ? 1 : 0) != 0, (Object)"Table name cannot be equal to null or empty");
        Preconditions.checkArgument((statisticsList != null && !statisticsList.isEmpty() ? 1 : 0) != 0, (Object)"List of column statistics objects cannot be equal to null or empty");
        for (ColumnStatistics statistics : statisticsList) {
            Preconditions.checkArgument((statistics != null ? 1 : 0) != 0, (Object)"Column statistics object cannot be equal to null");
        }
        List statisticsListPaged = Lists.partition(statisticsList, (int)25);
        ArrayList<Future<UpdateColumnStatisticsForTableResult>> pagedResult = new ArrayList<Future<UpdateColumnStatisticsForTableResult>>();
        for (Object statList : statisticsListPaged) {
            final UpdateColumnStatisticsForTableRequest updateColumnStatisticsForTableRequest = new UpdateColumnStatisticsForTableRequest().withCatalogId(this.catalogId).withDatabaseName(dbName).withTableName(tblName).withColumnStatisticsList((Collection)statList);
            pagedResult.add(GLUE_METASTORE_DELEGATE_THREAD_POOL.submit(new Callable<UpdateColumnStatisticsForTableResult>(){

                @Override
                public UpdateColumnStatisticsForTableResult call() throws Exception {
                    return GlueMetastoreClientDelegate.this.glueClient.updateColumnStatisticsForTable(updateColumnStatisticsForTableRequest);
                }
            }));
        }
        ArrayList columnStatisticsErrors = new ArrayList();
        try {
            for (Future future : pagedResult) {
                Optional.ofNullable(((UpdateColumnStatisticsForTableResult)future.get()).getErrors()).ifPresent(error -> columnStatisticsErrors.addAll(error));
            }
            if (columnStatisticsErrors.size() > 0) {
                logger.error((Object)("Cannot update all provided column statistics. List of failures: " + ((Object)columnStatisticsErrors).toString()));
                return false;
            }
            return true;
        }
        catch (ExecutionException e) {
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String string = "Unable to update table column statistics: ";
            logger.error((Object)string, (Throwable)e);
            throw new MetaException(string + e);
        }
    }

    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partName) throws TException {
        throw new UnsupportedOperationException("getAggrColStatsFor is not supported");
    }

    public void cancelDelegationToken(String tokenStrForm) throws TException {
        throw new UnsupportedOperationException("cancelDelegationToken is not supported");
    }

    public String getTokenStrForm() throws IOException {
        throw new UnsupportedOperationException("getTokenStrForm is not supported");
    }

    public boolean addToken(String tokenIdentifier, String delegationToken) throws TException {
        throw new UnsupportedOperationException("addToken is not supported");
    }

    public boolean removeToken(String tokenIdentifier) throws TException {
        throw new UnsupportedOperationException("removeToken is not supported");
    }

    public String getToken(String tokenIdentifier) throws TException {
        throw new UnsupportedOperationException("getToken is not supported");
    }

    public List<String> getAllTokenIdentifiers() throws TException {
        throw new UnsupportedOperationException("getAllTokenIdentifiers is not supported");
    }

    public int addMasterKey(String key) throws TException {
        throw new UnsupportedOperationException("addMasterKey is not supported");
    }

    public void updateMasterKey(Integer seqNo, String key) throws TException {
        throw new UnsupportedOperationException("updateMasterKey is not supported");
    }

    public boolean removeMasterKey(Integer keySeq) throws TException {
        throw new UnsupportedOperationException("removeMasterKey is not supported");
    }

    public String[] getMasterKeys() throws TException {
        throw new UnsupportedOperationException("getMasterKeys is not supported");
    }

    public LockResponse checkLock(long lockId) throws TException {
        throw new UnsupportedOperationException("checkLock is not supported");
    }

    public void commitTxn(long txnId) throws TException {
        throw new UnsupportedOperationException("commitTxn is not supported");
    }

    public void replCommitTxn(long srcTxnid, String replPolicy) {
        throw new UnsupportedOperationException("replCommitTxn is not supported");
    }

    public void abortTxns(List<Long> txnIds) throws TException {
        throw new UnsupportedOperationException("abortTxns is not supported");
    }

    public void compact(String dbName, String tblName, String partitionName, CompactionType compactionType) throws TException {
        throw new UnsupportedOperationException("compact is not supported");
    }

    public void compact(String dbName, String tblName, String partitionName, CompactionType compactionType, Map<String, String> tblProperties) throws TException {
        throw new UnsupportedOperationException("compact is not supported");
    }

    public CompactionResponse compact2(String dbName, String tblName, String partitionName, CompactionType compactionType, Map<String, String> tblProperties) throws TException {
        throw new UnsupportedOperationException("compact2 is not supported");
    }

    public ValidTxnList getValidTxns() throws TException {
        throw new UnsupportedOperationException("getValidTxns is not supported");
    }

    public ValidTxnList getValidTxns(long currentTxn) throws TException {
        throw new UnsupportedOperationException("getValidTxns is not supported");
    }

    public org.apache.hadoop.hive.metastore.api.Partition exchangePartition(Map<String, String> partitionSpecs, String srcDb, String srcTbl, String dstDb, String dstTbl) throws TException {
        throw new UnsupportedOperationException("exchangePartition not yet supported.");
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> exchangePartitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTbl, String destDb, String destTbl) throws TException {
        throw new UnsupportedOperationException("exchangePartitions is not yet supported");
    }

    public String getDelegationToken(String owner, String renewerKerberosPrincipalName) throws TException {
        throw new UnsupportedOperationException("getDelegationToken is not supported");
    }

    public void heartbeat(long txnId, long lockId) throws TException {
        throw new UnsupportedOperationException("heartbeat is not supported");
    }

    public HeartbeatTxnRangeResponse heartbeatTxnRange(long min, long max) throws TException {
        throw new UnsupportedOperationException("heartbeatTxnRange is not supported");
    }

    public boolean isPartitionMarkedForEvent(String dbName, String tblName, Map<String, String> partKVs, PartitionEventType eventType) throws TException {
        throw new UnsupportedOperationException("isPartitionMarkedForEvent is not supported");
    }

    public PartitionValuesResponse listPartitionValues(PartitionValuesRequest partitionValuesRequest) throws TException {
        throw new UnsupportedOperationException("listPartitionValues is not yet supported");
    }

    public int getNumPartitionsByFilter(String dbName, String tableName, String filter) throws TException {
        throw new UnsupportedOperationException("getNumPartitionsByFilter is not supported.");
    }

    public PartitionSpecProxy listPartitionSpecs(String dbName, String tblName, int max) throws TException {
        throw new UnsupportedOperationException("listPartitionSpecs is not supported.");
    }

    public PartitionSpecProxy listPartitionSpecsByFilter(String dbName, String tblName, String filter, int max) throws TException {
        throw new UnsupportedOperationException("listPartitionSpecsByFilter is not supported");
    }

    public LockResponse lock(LockRequest lockRequest) throws TException {
        throw new UnsupportedOperationException("lock is not supported");
    }

    public void markPartitionForEvent(String dbName, String tblName, Map<String, String> partKeyValues, PartitionEventType eventType) throws TException {
        throw new UnsupportedOperationException("markPartitionForEvent is not supported");
    }

    public long openTxn(String user) throws TException {
        throw new UnsupportedOperationException("openTxn is not supported");
    }

    public OpenTxnsResponse openTxns(String user, int numTxns) throws TException {
        throw new UnsupportedOperationException("openTxns is not supported");
    }

    public long renewDelegationToken(String tokenStrForm) throws TException {
        throw new UnsupportedOperationException("renewDelegationToken is not supported");
    }

    public void rollbackTxn(long txnId) throws TException {
        throw new UnsupportedOperationException("rollbackTxn is not supported");
    }

    public void createTableWithConstraints(Table table, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys) throws AlreadyExistsException, TException {
        throw new UnsupportedOperationException("createTableWithConstraints is not supported");
    }

    public void dropConstraint(String dbName, String tblName, String constraintName) throws TException {
        throw new UnsupportedOperationException("dropConstraint is not supported");
    }

    public void addPrimaryKey(List<SQLPrimaryKey> primaryKeyCols) throws TException {
        throw new UnsupportedOperationException("addPrimaryKey is not supported");
    }

    public void addForeignKey(List<SQLForeignKey> foreignKeyCols) throws TException {
        throw new UnsupportedOperationException("addForeignKey is not supported");
    }

    public ShowCompactResponse showCompactions() throws TException {
        throw new UnsupportedOperationException("showCompactions is not supported");
    }

    public void addDynamicPartitions(long txnId, String dbName, String tblName, List<String> partNames) throws TException {
        throw new UnsupportedOperationException("addDynamicPartitions is not supported");
    }

    public void addDynamicPartitions(long txnId, String dbName, String tblName, List<String> partNames, DataOperationType operationType) throws TException {
        throw new UnsupportedOperationException("addDynamicPartitions is not supported");
    }

    public void insertTable(Table table, boolean overwrite) throws MetaException {
        throw new UnsupportedOperationException("insertTable is not supported");
    }

    public NotificationEventResponse getNextNotification(long lastEventId, int maxEvents, IMetaStoreClient.NotificationFilter notificationFilter) throws TException {
        throw new UnsupportedOperationException("getNextNotification is not supported");
    }

    public CurrentNotificationEventId getCurrentNotificationEventId() throws TException {
        throw new UnsupportedOperationException("getCurrentNotificationEventId is not supported");
    }

    public FireEventResponse fireListenerEvent(FireEventRequest fireEventRequest) throws TException {
        throw new UnsupportedOperationException("fireListenerEvent is not supported");
    }

    public ShowLocksResponse showLocks() throws TException {
        throw new UnsupportedOperationException("showLocks is not supported");
    }

    public ShowLocksResponse showLocks(ShowLocksRequest showLocksRequest) throws TException {
        throw new UnsupportedOperationException("showLocks is not supported");
    }

    public GetOpenTxnsInfoResponse showTxns() throws TException {
        throw new UnsupportedOperationException("showTxns is not supported");
    }

    public void unlock(long lockId) throws TException {
        throw new UnsupportedOperationException("unlock is not supported");
    }

    public Iterable<Map.Entry<Long, ByteBuffer>> getFileMetadata(List<Long> fileIds) throws TException {
        throw new UnsupportedOperationException("getFileMetadata is not supported");
    }

    public Iterable<Map.Entry<Long, MetadataPpdResult>> getFileMetadataBySarg(List<Long> fileIds, ByteBuffer sarg, boolean doGetFooters) throws TException {
        throw new UnsupportedOperationException("getFileMetadataBySarg is not supported");
    }

    public void clearFileMetadata(List<Long> fileIds) throws TException {
        throw new UnsupportedOperationException("clearFileMetadata is not supported");
    }

    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata) throws TException {
        throw new UnsupportedOperationException("putFileMetadata is not supported");
    }

    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws TException {
        for (org.apache.hadoop.hive.metastore.api.ColumnStatistics colStat : request.getColStats()) {
            if (colStat.getStatsDesc().getPartName() != null) {
                this.updatePartitionColumnStatistics(colStat);
                continue;
            }
            this.updateTableColumnStatistics(colStat);
        }
        return true;
    }

    public boolean cacheFileMetadata(String dbName, String tblName, String partName, boolean allParts) throws TException {
        throw new UnsupportedOperationException("cacheFileMetadata is not supported");
    }

    public int addPartitionsSpecProxy(PartitionSpecProxy pSpec) throws TException {
        throw new UnsupportedOperationException("addPartitionsSpecProxy is unsupported");
    }

    public void setUGI(String username) throws TException {
        throw new UnsupportedOperationException("setUGI is unsupported");
    }

    public Function getFunction(String dbName, String functionName) throws TException {
        try {
            GetUserDefinedFunctionRequest getUserDefinedFunctionRequest = new GetUserDefinedFunctionRequest().withDatabaseName(dbName).withFunctionName(functionName).withCatalogId(this.catalogId);
            GetUserDefinedFunctionResult result = this.glueClient.getUserDefinedFunction(getUserDefinedFunctionRequest);
            return this.catalogToHiveConverter.convertFunction(dbName, result.getUserDefinedFunction());
        }
        catch (AmazonServiceException e) {
            logger.error((Object)e);
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to get Function: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public List<String> getFunctions(String dbName, String pattern) throws TException {
        if (this.conf.getBoolean("aws.glue.disable-udf", false)) {
            return new ArrayList<String>();
        }
        try {
            ArrayList functionNames = Lists.newArrayList();
            String nextToken = null;
            do {
                GetUserDefinedFunctionsRequest getUserDefinedFunctionsRequest = new GetUserDefinedFunctionsRequest().withDatabaseName(dbName).withPattern(pattern).withNextToken(nextToken).withCatalogId(this.catalogId);
                GetUserDefinedFunctionsResult result = this.glueClient.getUserDefinedFunctions(getUserDefinedFunctionsRequest);
                nextToken = result.getNextToken();
                for (UserDefinedFunction catalogFunction : result.getUserDefinedFunctions()) {
                    functionNames.add(catalogFunction.getFunctionName());
                }
            } while (nextToken != null);
            return functionNames;
        }
        catch (AmazonServiceException e) {
            logger.error((Object)e);
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to get Functions: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public GetAllFunctionsResponse getAllFunctions() throws MetaException, TException {
        ArrayList<Function> result = new ArrayList<Function>();
        try {
            String nextToken = null;
            do {
                GetUserDefinedFunctionsRequest getUserDefinedFunctionsRequest = new GetUserDefinedFunctionsRequest().withPattern(MATCH_ALL).withCatalogId(this.catalogId).withNextToken(nextToken);
                GetUserDefinedFunctionsResult udfResult = this.glueClient.getUserDefinedFunctions(getUserDefinedFunctionsRequest);
                List catalogFunctions = udfResult.getUserDefinedFunctions();
                nextToken = udfResult.getNextToken();
                for (UserDefinedFunction catalogFunction : catalogFunctions) {
                    result.add(this.catalogToHiveConverter.convertFunction(catalogFunction.getDatabaseName(), catalogFunction));
                }
            } while (nextToken != null);
        }
        catch (AmazonServiceException e) {
            logger.error((Object)e);
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to get Functions: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
        GetAllFunctionsResponse response = new GetAllFunctionsResponse();
        response.setFunctions(result);
        return response;
    }

    public void createFunction(Function function) throws InvalidObjectException, TException {
        try {
            UserDefinedFunctionInput functionInput = GlueInputConverter.convertToUserDefinedFunctionInput(function);
            CreateUserDefinedFunctionRequest createUserDefinedFunctionRequest = new CreateUserDefinedFunctionRequest().withDatabaseName(function.getDbName()).withFunctionInput(functionInput).withCatalogId(this.catalogId);
            this.glueClient.createUserDefinedFunction(createUserDefinedFunctionRequest);
        }
        catch (AmazonServiceException e) {
            logger.error((Object)e);
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to create Function: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public void dropFunction(String dbName, String functionName) throws NoSuchObjectException, InvalidObjectException, InvalidInputException, TException {
        try {
            DeleteUserDefinedFunctionRequest deleteUserDefinedFunctionRequest = new DeleteUserDefinedFunctionRequest().withDatabaseName(dbName).withFunctionName(functionName).withCatalogId(this.catalogId);
            this.glueClient.deleteUserDefinedFunction(deleteUserDefinedFunctionRequest);
        }
        catch (AmazonServiceException e) {
            logger.error((Object)e);
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to drop Function: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public void alterFunction(String dbName, String functionName, Function newFunction) throws InvalidObjectException, MetaException, TException {
        try {
            UserDefinedFunctionInput functionInput = GlueInputConverter.convertToUserDefinedFunctionInput(newFunction);
            UpdateUserDefinedFunctionRequest updateUserDefinedFunctionRequest = new UpdateUserDefinedFunctionRequest().withDatabaseName(dbName).withFunctionName(functionName).withFunctionInput(functionInput).withCatalogId(this.catalogId);
            this.glueClient.updateUserDefinedFunction(updateUserDefinedFunctionRequest);
        }
        catch (AmazonServiceException e) {
            logger.error((Object)e);
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to alter Function: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public List<FieldSchema> getFields(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        try {
            GetTableRequest getTableRequest = new GetTableRequest().withDatabaseName(db).withName(tableName).withCatalogId(this.catalogId);
            GetTableResult result = this.glueClient.getTable(getTableRequest);
            com.amazonaws.services.glue.model.Table table = result.getTable();
            return this.catalogToHiveConverter.convertFieldSchemaList(table.getStorageDescriptor().getColumns());
        }
        catch (AmazonServiceException e) {
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to get field from table: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public List<FieldSchema> getSchema(String db, String tableName) throws TException, UnknownTableException, UnknownDBException {
        try {
            GetTableRequest getTableRequest = new GetTableRequest().withDatabaseName(db).withName(tableName).withCatalogId(this.catalogId);
            GetTableResult result = this.glueClient.getTable(getTableRequest);
            com.amazonaws.services.glue.model.Table table = result.getTable();
            List schemas = table.getStorageDescriptor().getColumns();
            if (table.getPartitionKeys() != null && !table.getPartitionKeys().isEmpty()) {
                schemas.addAll(table.getPartitionKeys());
            }
            return this.catalogToHiveConverter.convertFieldSchemaList(schemas);
        }
        catch (AmazonServiceException e) {
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
        catch (Exception e) {
            String msg = "Unable to get field from table: ";
            logger.error((Object)msg, (Throwable)e);
            throw new MetaException(msg + e);
        }
    }

    public void renamePartitionInCatalog(String databaseName, String tableName, List<String> partitionValues, org.apache.hadoop.hive.metastore.api.Partition newPartition) throws InvalidOperationException, TException {
        try {
            UpdatePartitionRequest updatePartitionRequest = new UpdatePartitionRequest().withDatabaseName(databaseName).withTableName(tableName).withPartitionValueList(partitionValues).withPartitionInput(GlueInputConverter.convertToPartitionInput(newPartition)).withCatalogId(this.catalogId);
            this.glueClient.updatePartition(updatePartitionRequest);
        }
        catch (AmazonServiceException e) {
            throw this.catalogToHiveConverter.wrapInHiveException(e);
        }
    }
}

