/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.MockableSystem;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.server.JettyUtils;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.ServletUtils;
import com.dataiku.dip.utils.MainUtils;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Connector;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.HttpConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.HttpConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Server;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ServerConnector;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread.QueuedThreadPool;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread.ThreadPool;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.BuiltinsLoader;
import com.dataiku.gh.GHBackendInitializer;
import jakarta.servlet.ServletException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class GovernServerMain {
    public static final long BACKEND_STARTUP_TIME = System.currentTimeMillis();
    private static Logger logger;

    public static void main(String[] args) throws Exception {
        System.setProperty("DIP_HOME", System.getenv("DIP_HOME"));
        ApplicationConfigurator.autoconfigure();
        MainLoggingConfigurator.configure((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.GOVERN);
        Logger.getLogger((String)"com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebAppClassLoader").setLevel(Level.INFO);
        if (System.getenv("DKU_GOVERNSERVER_PORT") == null) {
            throw new IllegalArgumentException("Missing DKU_GOVERNSERVER_PORT environment variable");
        }
        if (System.getenv("DKUINSTALLDIR") == null) {
            throw new IllegalArgumentException("Missing DKUINSTALLDIR environment variable");
        }
        ApplicationConfigurator.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.GOVERN);
        MainUtils.printHello((String)"governserver");
        BuiltinsLoader.load();
        MainLoggingConfigurator.configureLimits();
        Integer backendPort = Integer.parseInt(System.getenv("DKU_GOVERNSERVER_PORT"));
        logger.info((Object)("Starting on port " + backendPort));
        int minThreads = DKUApp.getParams().getIntParam("dku.backend.server.threadPool.minThreads", Integer.valueOf(8));
        int maxThreads = DKUApp.getParams().getIntParam("dku.backend.server.threadPool.maxThreads", Integer.valueOf(400));
        QueuedThreadPool tp = new QueuedThreadPool(maxThreads, minThreads);
        Server server = new Server((ThreadPool)tp);
        server.setOpenEarly(false);
        HttpConfiguration config = JettyUtils.createHttpConfiguration();
        String requestHeaderSize = DKUApp.getIniValue((String)"server", (String)"backend_max_request_headers_size_kb");
        if (requestHeaderSize != null) {
            int requestHeaderSizeKB = Integer.valueOf(requestHeaderSize) * 1024;
            if (requestHeaderSizeKB < 8192) {
                logger.warn((Object)"backend_max_request_headers_size_kb must be higher than 8KB, the configuration will be ignored ");
            }
            config.setRequestHeaderSize(Math.max(8192, requestHeaderSizeKB));
        }
        ServerConnector sc = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(config)});
        sc.setIdleTimeout(-1L);
        sc.setPort(backendPort.intValue());
        server.setConnectors(new Connector[]{sc});
        logger.info((Object)"Creating the Dataiku Govern servlet context");
        ServletContextHandler sch = ServletUtils.createServletContext((int)500000000, (String)"/dip");
        GovernServerMain.registerInitializer(sch);
        JettyUtils.addHandlers((Server)server, (ServletContextHandler)sch);
        SharedSecretUtils.getSharedSecret((boolean)true);
        DSSMetrics.registerJVMMetrics();
        DSSMetrics.startJMXReporter();
        try {
            server.start();
        }
        catch (Exception e) {
            logger.error((Object)"Server start failed", (Throwable)e);
            System.exit(1);
        }
        SpringUtils.onDSSStarted();
        server.join();
    }

    private static void registerInitializer(ServletContextHandler contextHandler) throws ServletException {
        contextHandler.addServletContainerInitializer((webAppInitializerClasses, servletContext) -> {
            GHBackendInitializer initializer = new GHBackendInitializer();
            initializer.onStartup(servletContext);
        });
    }

    static {
        System.setProperty("DIP_HOME", MockableSystem.getenv((String)"DIP_HOME"));
        logger = Logger.getLogger((String)"dku");
    }
}

