/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.custom_pages.CustomPage;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.import_export.CustomPageVisibilityImportBehavior;
import com.dataiku.gh.core.models.import_export.ExportedEntity;
import com.dataiku.gh.core.services.custom_pages.IAdminCustomPagesService;
import com.dataiku.gh.core.services.import_export.IExportedEntityMigrationService;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.security.auth.UIAuthService;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdminCustomPagesController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IAdminCustomPagesService adminCustomPagesService;
    @Autowired
    private IExportedEntityMigrationService importExportMigrationService;

    @AuditInline
    @RequestMapping(value={"/api/admin/custom-pages/create"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.CUSTOM_PAGE_CREATE)
    @ResponseBody
    public CustomPage create(HttpServletRequest req, @RequestParam CustomPage customPage, @RequestParam String newIdentifier) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            CustomPage createdCustomPage = this.adminCustomPagesService.createCustomPage(authCtx, customPage, newIdentifier);
            this.auditTrailService.generic("admin-custom-page-create").with("customPageId", createdCustomPage.id).emit();
            return createdCustomPage;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-custom-page-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/custom-pages/save"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.CUSTOM_PAGE_SAVE)
    @ResponseBody
    public CustomPage save(HttpServletRequest req, @RequestParam CustomPage customPage) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            CustomPage updatedCustomPage = this.adminCustomPagesService.saveCustomPage(authCtx, customPage);
            this.auditTrailService.generic("admin-custom-page-save").with("customPageId", updatedCustomPage.id).emit();
            return updatedCustomPage;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-custom-page-save", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-custom-page-delete", "customPageId", "${customPageId}"})
    @RequestMapping(value={"/api/admin/custom-pages/delete"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.CUSTOM_PAGE_DELETE)
    public void delete(HttpServletRequest req, HttpServletResponse resp, @RequestParam String customPageId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.adminCustomPagesService.deleteCustomPage(authCtx, customPageId);
        AdminCustomPagesController.writeEmptyJSONObj((HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "admin-custom-page-order-save"})
    @RequestMapping(value={"/api/admin/custom-pages/order"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.CUSTOM_PAGE_ORDER_SAVE)
    @ResponseBody
    public List<String> saveOrder(HttpServletRequest req, @RequestParam List<String> customPageIds) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.adminCustomPagesService.saveOrder(authCtx, customPageIds);
    }

    @AuditedCall(value={"msgType", "admin-custom-page-order-get"})
    @RequestMapping(value={"/api/admin/custom-pages/order"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getOrder(HttpServletRequest req) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.adminCustomPagesService.getOrder(authCtx);
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/custom-pages/import"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.CUSTOM_PAGE_IMPORT)
    @ResponseBody
    @GHWriteTransaction
    public List<CustomPage> importCustomPages(HttpServletRequest req, @RequestParam JsonArray toImport, @RequestParam(required=false) CustomPageVisibilityImportBehavior customPagesVisibility) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            ArrayList<CustomPage> customPagesImported = new ArrayList<CustomPage>();
            for (JsonElement element : toImport) {
                JsonObject obj = element.getAsJsonObject();
                CustomPage customPageImport = this.importExportMigrationService.unwrapAndMigrateExportedEntity(obj, CustomPage.class);
                CustomPage imported = this.adminCustomPagesService.importCustomPage(authCtx, customPageImport, Optional.ofNullable(customPagesVisibility).orElse(CustomPageVisibilityImportBehavior.HIDDEN));
                customPagesImported.add(imported);
            }
            this.auditTrailService.generic("admin-custom-page-import").with("ids", String.join((CharSequence)",", customPagesImported.stream().map(cp -> cp.id).toList())).emit();
            return customPagesImported;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-custom-page-import", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/custom-pages/export"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ExportedEntity<CustomPage>> exportCustomPages(HttpServletRequest req, @RequestParam List<String> customPageIds) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            ArrayList<ExportedEntity<CustomPage>> exportCustomPages = new ArrayList<ExportedEntity<CustomPage>>();
            for (String customPageId : customPageIds) {
                CustomPage page = this.adminCustomPagesService.getCustomPage(authCtx, customPageId);
                ExportedEntity<CustomPage> exportCustomPage = this.importExportMigrationService.wrapToExportedEntity(page);
                exportCustomPages.add(exportCustomPage);
            }
            this.auditTrailService.generic("admin-custom-page-export").with("ids", String.join((CharSequence)",", customPageIds)).emit();
            return exportCustomPages;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-custom-page-export", (Throwable)e).emit();
            throw e;
        }
    }
}

