/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.blueprints;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.gh.core.models.analysis.AnalysisDefinition;
import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.blueprints.StepDefinition;
import com.dataiku.gh.core.models.blueprints.ui.View;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.system.SystemProvidedEnrichedBlueprint;
import com.dataiku.gh.core.models.ui.UIBlueprintVersion;
import com.dataiku.gh.core.services.blueprints.IAdminBlueprintsAnalysisService;
import com.dataiku.gh.core.services.blueprints.IBlueprintsService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.security.IPermissionsService;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminBlueprintsAnalysisService
implements IAdminBlueprintsAnalysisService {
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private IBlueprintsService blueprintsService;

    @Override
    @GHReadonlyTransaction
    public InfoMessage.InfoMessages analysis(AuthCtx authCtx, BlueprintVersionId blueprintVersionId) throws DKUSecurityException, IOException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        UIBlueprintVersion blueprintVersion = this.blueprintsService.getBlueprintVersion(authCtx, blueprintVersionId);
        return this.analysis(authCtx, blueprintVersion.blueprintVersion);
    }

    @Override
    @GHReadonlyTransaction
    public InfoMessage.InfoMessages analysis(AuthCtx authCtx, BlueprintVersion blueprintVersion) throws DKUSecurityException, IOException {
        UIBlueprintVersion originBlueprintVersion;
        SystemProvidedEnrichedBlueprint systemProvidedEnrichedBlueprint;
        this.permissionsService.checkIsGovernArchitect(authCtx);
        InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
        infoMessages.messages = new TreeSet<InfoMessage>(Comparator.comparing(im -> im.severity).reversed().thenComparing(im -> im.title).thenComparing(im -> im.message));
        if (IdentifiersUtils.getSourceFromBlueprintId(blueprintVersion.id.blueprintId).equals((Object)IdentifiersUtils.ItemSource.SYSTEM) && (systemProvidedEnrichedBlueprint = SystemProvidedConstants.SYSTEM_BLUEPRINT_BY_ID.get(blueprintVersion.id.blueprintId)) instanceof SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint) {
            UIBlueprintVersion defaultBlueprintVersion = this.blueprintsService.getBlueprintVersion(authCtx, ((SystemProvidedEnrichedBlueprint.SingleSystemProvidedEnrichedBlueprint)systemProvidedEnrichedBlueprint).getSingleDefaultBlueprintVersionId());
            infoMessages.mergeFrom(this.analysis(blueprintVersion, defaultBlueprintVersion.blueprintVersion));
        }
        UIBlueprintVersion uiBlueprintVersion = this.blueprintsService.getBlueprintVersion(authCtx, blueprintVersion.id);
        if (StringUtils.isNotBlank((CharSequence)uiBlueprintVersion.blueprintVersionTrace.originVersionId) && (originBlueprintVersion = this.blueprintsService.getBlueprintVersion(authCtx, BlueprintVersionId.build(blueprintVersion.id.blueprintId, uiBlueprintVersion.blueprintVersionTrace.originVersionId))) != null) {
            infoMessages.mergeFrom(this.analysis(blueprintVersion, originBlueprintVersion.blueprintVersion));
        }
        return infoMessages;
    }

    @VisibleForTesting
    protected InfoMessage.InfoMessages analysis(BlueprintVersion forkedBlueprintVersion, BlueprintVersion baseBlueprintVersion) {
        AnalysisDefinition analysisDefinition;
        InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
        if (baseBlueprintVersion == null) {
            return infoMessages;
        }
        Object baseBPVDisplayName = baseBlueprintVersion.name;
        baseBPVDisplayName = StringUtils.isBlank((CharSequence)baseBPVDisplayName) ? (IdentifiersUtils.getSourceFromBlueprintVersionId(baseBlueprintVersion.id.versionId) == IdentifiersUtils.ItemSource.SYSTEM ? "Standard(" + baseBlueprintVersion.id.versionId + ")" : baseBlueprintVersion.id.versionId) : (String)baseBPVDisplayName + " (" + baseBlueprintVersion.id.versionId + ")";
        for (Map.Entry<String, FieldDefinition> entry : baseBlueprintVersion.fieldDefinitions.entrySet()) {
            String fieldId = entry.getKey();
            FieldDefinition standardFieldDefinition = entry.getValue();
            analysisDefinition = standardFieldDefinition.analysisDefinition;
            if (analysisDefinition == null) continue;
            FieldDefinition customFieldDefinition = forkedBlueprintVersion.fieldDefinitions.get(fieldId);
            if (customFieldDefinition == null) {
                if (analysisDefinition.missing == null) continue;
                infoMessages.addMessage(new InfoMessage(analysisDefinition.missing, standardFieldDefinition.label + " field (" + fieldId + ") from " + (String)baseBPVDisplayName + " not found on custom blueprint version", analysisDefinition.hint));
                continue;
            }
            if (customFieldDefinition.fieldType != standardFieldDefinition.fieldType && analysisDefinition.definitionMismatch != null) {
                infoMessages.addMessage(new InfoMessage(analysisDefinition.definitionMismatch, standardFieldDefinition.label + " field (" + fieldId + ") from " + (String)baseBPVDisplayName + " has a different type on custom blueprint version", analysisDefinition.hint));
                continue;
            }
            if (customFieldDefinition.sourceType != standardFieldDefinition.sourceType && analysisDefinition.definitionMismatch != null) {
                infoMessages.addMessage(new InfoMessage(analysisDefinition.definitionMismatch, standardFieldDefinition.label + " field (" + fieldId + ") from " + (String)baseBPVDisplayName + " has different source type on custom blueprint version", analysisDefinition.hint));
                continue;
            }
            if (!Objects.equals(customFieldDefinition.listConfig, standardFieldDefinition.listConfig) && analysisDefinition.definitionMismatch != null) {
                infoMessages.addMessage(new InfoMessage(analysisDefinition.definitionMismatch, standardFieldDefinition.label + " field (" + fieldId + ") from " + (String)baseBPVDisplayName + " has different list configuration on custom blueprint version", analysisDefinition.hint));
                continue;
            }
            if (this.equals(standardFieldDefinition, customFieldDefinition) || analysisDefinition.definitionMismatch == null) continue;
            infoMessages.addMessage(new InfoMessage(analysisDefinition.definitionMismatch, standardFieldDefinition.label + " field (" + fieldId + ") from " + (String)baseBPVDisplayName + " has different definition on custom blueprint version", analysisDefinition.hint));
        }
        for (Map.Entry<String, Object> entry : baseBlueprintVersion.uiDefinition.views.entrySet()) {
            View customView;
            String viewId = entry.getKey();
            View view = (View)entry.getValue();
            analysisDefinition = view.analysisDefinition;
            if (analysisDefinition == null || (customView = forkedBlueprintVersion.uiDefinition.views.get(viewId)) != null || analysisDefinition.missing == null) continue;
            infoMessages.addMessage(new InfoMessage(analysisDefinition.missing, view.label + " view (" + viewId + ") from " + (String)baseBPVDisplayName + " not found on custom blueprint version", analysisDefinition.hint));
        }
        for (StepDefinition stepDefinition : baseBlueprintVersion.workflowDefinition.stepDefinitions) {
            AnalysisDefinition analysisDefinition2 = stepDefinition.analysisDefinition;
            if (analysisDefinition2 == null || analysisDefinition2.missing == null || !forkedBlueprintVersion.workflowDefinition.stepDefinitions.stream().noneMatch(sd -> sd.id.equals(standardStepDefinition.id))) continue;
            infoMessages.addMessage(new InfoMessage(analysisDefinition2.missing, stepDefinition.name + " workflow step (" + stepDefinition.id + ") from " + (String)baseBPVDisplayName + " not found on custom blueprint version", analysisDefinition2.hint));
        }
        return infoMessages;
    }

    private boolean equals(FieldDefinition field1, FieldDefinition field2) {
        return JSON.jsonEquals((Object)((FieldDefinition)JSON.deepCopyExcept((Object)field1, (String[])new String[]{"analysisDefinition", "label", "description"})), (Object)((FieldDefinition)JSON.deepCopyExcept((Object)field2, (String[])new String[]{"analysisDefinition", "label", "description"})));
    }
}

