/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.utils;

import com.dataiku.gh.core.utils.Either;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class DateUtils {
    public static String now() {
        return OffsetDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static boolean isValidDateString(String dateAsString) {
        try {
            return DateUtils.parseDate(dateAsString) != null;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    public static Either<OffsetDateTime, LocalDate> parseDate(String dateAsString) {
        if (dateAsString == null) {
            throw new DateTimeParseException("Cannot parse null date", "null", 0);
        }
        if (dateAsString.length() == 10) {
            return Either.right(LocalDate.parse(dateAsString));
        }
        if (dateAsString.contains("[")) {
            return Either.left(ZonedDateTime.parse(dateAsString).toOffsetDateTime());
        }
        if (dateAsString.matches(".*([+-]\\d{2}(:?\\d{2})?|Z)")) {
            return Either.left(OffsetDateTime.parse(dateAsString));
        }
        return Either.left(LocalDateTime.parse(dateAsString).atOffset(ZoneOffset.UTC));
    }
}

