/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.security;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.security.GHAuthCtx;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthCtxCreationService {
    @Autowired
    private UsersDAO usersDAO;

    public AuthCtx create_autoTxn(String identifier) throws DKUSecurityException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.create(identifier);
        }
        TransactionService ts = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = ts.beginRead();){
            AuthCtx authCtx = this.create(identifier);
            return authCtx;
        }
    }

    public AuthCtx create(String identifier) throws DKUSecurityException {
        if (identifier.startsWith("api:")) {
            throw new DKUSecurityException("Unable to create AuthCtx from global or project API key: " + identifier + ". You must use a personal API key.");
        }
        try {
            UsersDAO.User u = this.usersDAO.getOrNullUnsafe(identifier);
            if (u == null) {
                throw new DKUSecurityException("Unknown AuthCtx identifier: " + identifier);
            }
            return GHAuthCtx.forUserLogin(u);
        }
        catch (IOException e) {
            throw new DKUSecurityException("Failed to create an AuthCtx from identifier: " + identifier, (Throwable)e);
        }
    }

    public AuthCtx createOrNull(String identifier) {
        try {
            return this.create(identifier);
        }
        catch (Exception e) {
            return null;
        }
    }
}

