/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.fs;

import com.dataiku.dip.fs.FSPathOrDirectory;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class FSPathUtils {
    public static List<FSPathOrDirectory> recursiveRerootedList(String root, File f, Set<String> excluded) throws IOException {
        ArrayList l = Lists.newArrayList();
        if (excluded.contains(f.getName())) {
            return l;
        }
        String path = FSPathUtils.getRooted(root, f);
        if (f.isDirectory()) {
            File[] children;
            if (!path.equals("/")) {
                l.add(new FSPathOrDirectory(path, 0L, f.lastModified(), true));
            }
            if ((children = f.listFiles()) != null) {
                for (File child : children) {
                    l.addAll(FSPathUtils.recursiveRerootedList(root, child, excluded));
                }
            }
        } else if (f.isFile()) {
            l.add(new FSPathOrDirectory(path, f.length(), f.lastModified(), false));
        }
        return l;
    }

    private static String getRooted(String r, File f) throws IOException {
        String p = f.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
        if (p.startsWith(r)) {
            p = p.substring(r.length());
        }
        return StringUtils.defaultIfEmpty((String)p, (String)"/");
    }
}

