/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.input.formats.AbstractBasicFormatExtractor;
import com.dataiku.dip.input.formats.BasicCSVFormatConfig;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.formats.vendor.opencsv.CSVReader;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.io.CountingInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;

public class BasicCSVFormatExtractor
extends AbstractBasicFormatExtractor {
    private BasicCSVFormatConfig conf;
    long log_count = 0L;
    long max_log = 100L;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.format.csv");

    public BasicCSVFormatExtractor(BasicCSVFormatConfig conf) {
        this.conf = conf;
    }

    protected void log_line_warn(String msg) {
        ++this.log_count;
        if (this.log_count == this.max_log) {
            logger.warn((Object)"Maximum log count (other info ignore)");
        } else if (this.log_count < this.max_log) {
            logger.warn((Object)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean run(StreamsInputSplit in, ProcessorOutput out, ProcessorOutput err, ColumnFactory cf, RowFactory rf, ExtractionLimit limit) throws Exception {
        EnrichedInputStream stream;
        long totalBytes = 0L;
        long totalRecords = 0L;
        while ((stream = in.nextStream()) != null) {
            logger.info((Object)("CSV starting to process one stream: " + stream.desc() + "  " + stream.size()));
            InputStream is = stream.decompressedHeadStream(limit != null ? limit.maxBytes : -1L);
            CountingInputStream cis = new CountingInputStream(is);
            CSVReader reader = null;
            reader = this.conf.escapeChar != null ? new CSVReader((Reader)new InputStreamReader((InputStream)cis, this.conf.charset), this.conf.separator, this.conf.quoteChar, this.conf.escapeChar.charValue()) : new CSVReader(new InputStreamReader((InputStream)cis, this.conf.charset), this.conf.separator, this.conf.quoteChar);
            try {
                String[] line;
                ArrayList<Column> columns = new ArrayList<Column>();
                long fileLines = 0L;
                long nintern = 0L;
                while ((line = reader.readNext()) != null) {
                    if (limit != null) {
                        if (limit.maxBytes > 0L && limit.maxBytes < totalBytes + cis.getCount()) {
                            boolean bl = false;
                            return bl;
                        }
                        if (limit.maxRecords > 0L && limit.maxRecords <= totalRecords) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    if (fileLines >= (long)this.conf.skipRowsBeforeHeader) {
                        if (fileLines == (long)this.conf.skipRowsBeforeHeader && this.conf.parseHeaderRow) {
                            if (line[0].startsWith("#")) {
                                line[0] = line[0].substring(1);
                            }
                            for (String string : line) {
                                void var24_32;
                                String string2 = string.trim();
                                if (string2.isEmpty()) {
                                    String string3 = "col_" + columns.size();
                                }
                                Column cd = cf.column((String)var24_32);
                                columns.add(cd);
                            }
                        } else {
                            if (columns.size() > 0 && line.length != columns.size() && Math.abs(line.length - columns.size()) > 2) {
                                this.log_line_warn("Line has an unexpected number of columns, line has " + line.length + " columns, extractor has " + columns.size());
                            }
                            if (line.length > columns.size()) {
                                for (int i = columns.size(); i < line.length; ++i) {
                                    String name = null;
                                    name = "col_" + i;
                                    Column cd = cf.column(name);
                                    columns.add(cd);
                                }
                            }
                            Row r = rf.row();
                            for (int i = 0; i < line.length; ++i) {
                                String s;
                                line[i] = line[i].trim();
                                if (line[i].length() > 3000) {
                                    this.log_line_warn("Unusually large column (quoting issue ?) : " + line[i].substring(0, 500));
                                }
                                if ((s = line[i]).equals("null")) {
                                    s = "null";
                                    ++nintern;
                                } else if (s.equals("NULL")) {
                                    s = "NULL";
                                    ++nintern;
                                } else if (s.equals("\\N")) {
                                    s = "\\N";
                                    ++nintern;
                                } else if (s.equals("true")) {
                                    s = "true";
                                    ++nintern;
                                } else if (s.equals("false")) {
                                    s = "false";
                                    ++nintern;
                                } else if (s.equals("Y")) {
                                    s = "Y";
                                    ++nintern;
                                } else if (s.equals("N")) {
                                    s = "N";
                                    ++nintern;
                                } else if (s.equals("0")) {
                                    s = "0";
                                    ++nintern;
                                }
                                r.put((Column)columns.get(i), s);
                            }
                            if (fileLines >= (long)(this.conf.skipRowsBeforeHeader + this.conf.skipRowsAfterHeader + (this.conf.parseHeaderRow ? 1 : 0))) {
                                ++totalRecords;
                                out.emitRow(r);
                            }
                        }
                    }
                    ++fileLines;
                    if (totalRecords % 20000L != 0L) continue;
                    Runtime runtime = Runtime.getRuntime();
                    double p = (double)runtime.totalMemory() / (double)runtime.maxMemory() * 100.0;
                    logger.info((Object)("CSV Emitted " + fileLines + " lines from file, " + totalRecords + " total, " + columns.size() + " columns - interned: " + nintern + " MEM: " + p + "%"));
                }
                totalBytes += cis.getCount();
            }
            finally {
                long before = System.currentTimeMillis();
                reader.close();
                IOUtils.closeQuietly((InputStream)cis);
                long l = System.currentTimeMillis();
                if (l - before <= 100L) continue;
                logger.info((Object)("Stream " + stream.desc() + " closed after " + (l - before) + "ms"));
            }
        }
        return true;
    }
}

