/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.stream;

import com.dataiku.dip.input.stream.EnrichedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;

public class DecodedInputStreamFactory {
    public InputStream addDecoding(EnrichedInputStream.Compression compression, InputStream on) throws IOException {
        switch (compression) {
            case GZIP: {
                return new GZIPInputStream(on);
            }
            case BZIP2: {
                return new BZip2CompressorInputStream(on);
            }
            case DEFLATE: {
                try {
                    return this.reflectGetDecodedInputStream(on, "org.apache.hadoop.io.compress.DeflateCodec");
                }
                catch (Exception e) {
                    throw new IOException("DSS could not locate Hadoop's librairies, which it needs to read deflate files", e);
                }
            }
            case SNAPPY: {
                try {
                    return this.reflectGetDecodedInputStream(on, "org.apache.hadoop.io.compress.SnappyCodec");
                }
                catch (Exception e) {
                    throw new IOException("DSS could not locate Hadoop's native librairies, which it needs to read snappy files", e);
                }
            }
            case LZO: {
                try {
                    return this.reflectGetDecodedInputStream(on, "com.hadoop.compression.lzo.LzopCodec");
                }
                catch (Exception e) {
                    throw new IOException("Lzo is not installed on this Hadoop", e);
                }
            }
            case ZSTD: {
                try {
                    return this.reflectGetDecodedInputStream(on, "org.apache.parquet.hadoop.codec.ZstandardCodec");
                }
                catch (Exception e) {
                    throw new IOException("Zstd is not installed on this Hadoop", e);
                }
            }
            case NONE: {
                return on;
            }
        }
        throw new NotImplementedException("Don't know how to decode " + String.valueOf((Object)compression));
    }

    private InputStream reflectGetDecodedInputStream(InputStream on, String codecClassName) throws Exception {
        Class<?> codecClass = this.getClass().getClassLoader().loadClass(codecClassName);
        CompressionCodec codec = (CompressionCodec)codecClass.newInstance();
        Method setConfMethod = codecClass.getMethod("setConf", Configuration.class);
        setConfMethod.invoke((Object)codec, new Configuration());
        Method createInputStreamMethod = codecClass.getMethod("createInputStream", InputStream.class);
        return (InputStream)createInputStreamMethod.invoke((Object)codec, on);
    }
}

