/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.output;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dss.shadelib.org.apache.commons.io.output.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class SingleFileOutputWriter
extends OutputWriter {
    private CountingOutputStream countingStream;
    private OutputStream finalOutputStream;
    private OutputStream fos;
    private boolean headerEmitted;
    private ColumnFactory cf;
    private String path;
    private OutputFormatter formatter;
    private FSProvider provider;

    public SingleFileOutputWriter(FSProvider provider, String path, OutputFormatter formatter) {
        this.provider = provider;
        this.path = path;
        this.formatter = formatter;
    }

    @Override
    public void init(ColumnFactory cf) throws IOException, CodedException, DKUSecurityException {
        this.cf = cf;
        this.fos = this.provider.write(this.path);
        if (this.path.contains(".gz")) {
            this.countingStream = new CountingOutputStream(this.fos);
            this.finalOutputStream = new GZIPOutputStream((OutputStream)this.countingStream);
        } else {
            this.countingStream = new CountingOutputStream(this.fos);
            this.finalOutputStream = this.countingStream;
        }
    }

    @Override
    public void emitRow(Row row) throws Exception {
        if (!this.headerEmitted) {
            this.formatter.header(this.cf, this.finalOutputStream);
            this.headerEmitted = true;
        }
        this.formatter.format(row, this.cf, this.finalOutputStream);
    }

    @Override
    public void lastRowEmitted() throws Exception {
        this.formatter.footer(this.cf, this.finalOutputStream);
        this.finalOutputStream.close();
        this.fos.close();
    }

    @Override
    public void cancel() throws Exception {
        this.formatter.cancel(this.finalOutputStream);
        this.finalOutputStream.close();
        this.fos.close();
    }

    @Override
    public long writtenBytes() throws IOException {
        return this.countingStream.getByteCount();
    }
}

