/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.defaults.internal.data.vector.AbstractColumnVector;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.DataType;
import java.util.Objects;
import java.util.Optional;

public class DefaultBooleanVector
extends AbstractColumnVector {
    private final boolean[] values;

    public DefaultBooleanVector(int n, Optional<boolean[]> optional, boolean[] blArray) {
        super(n, (DataType)BooleanType.BOOLEAN, optional);
        this.values = Objects.requireNonNull(blArray, "values is null");
        Preconditions.checkArgument((blArray.length >= n ? 1 : 0) != 0, (String)"invalid number of values (%s) for given size (%s)", (Object[])new Object[]{blArray.length, n});
    }

    @Override
    public boolean getBoolean(int n) {
        this.checkValidRowId(n);
        return this.values[n];
    }
}

