/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.coverage;

import com.databricks.internal.jts.algorithm.construct.MaximumInscribedCircle;
import com.databricks.internal.jts.coverage.CoverageUnion;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geom.LinearRing;
import com.databricks.internal.jts.geom.Polygon;
import com.databricks.internal.jts.geom.util.PolygonExtracter;
import java.util.ArrayList;
import java.util.List;

public class CoverageGapFinder {
    private Geometry[] coverage;

    public static Geometry findGaps(Geometry[] coverage, double gapWidth) {
        CoverageGapFinder finder = new CoverageGapFinder(coverage);
        return finder.findGaps(gapWidth);
    }

    public CoverageGapFinder(Geometry[] coverage) {
        this.coverage = coverage;
    }

    public Geometry findGaps(double gapWidth) {
        Geometry union = CoverageUnion.union(this.coverage);
        List polygons = PolygonExtracter.getPolygons(union);
        ArrayList<LineString> gapLines = new ArrayList<LineString>();
        for (Polygon poly : polygons) {
            for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
                LinearRing hole = poly.getInteriorRingN(i);
                if (!this.isGap(hole, gapWidth)) continue;
                gapLines.add(this.copyLine(hole));
            }
        }
        return union.getFactory().buildGeometry(gapLines);
    }

    private LineString copyLine(LinearRing hole) {
        Coordinate[] pts = hole.getCoordinates();
        return hole.getFactory().createLineString(pts);
    }

    private boolean isGap(LinearRing hole, double gapWidth) {
        Polygon holePoly = hole.getFactory().createPolygon(hole);
        if (gapWidth <= 0.0) {
            return false;
        }
        double tolerance = gapWidth / 100.0;
        LineString line = MaximumInscribedCircle.getRadiusLine(holePoly, tolerance);
        double width = line.getLength() * 2.0;
        return width <= gapWidth;
    }
}

