/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.shape.fractal;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.LineSegment;
import com.databricks.internal.jts.shape.GeometricShapeBuilder;
import com.databricks.internal.jts.shape.fractal.HilbertCode;

public class HilbertCurveBuilder
extends GeometricShapeBuilder {
    private int order = -1;

    public HilbertCurveBuilder(GeometryFactory geomFactory) {
        super(geomFactory);
        this.extent = null;
    }

    public void setLevel(int level) {
        this.numPts = HilbertCode.size(level);
    }

    @Override
    public Geometry getGeometry() {
        int level = HilbertCode.level(this.numPts);
        int nPts = HilbertCode.size(level);
        double scale = 1.0;
        double baseX = 0.0;
        double baseY = 0.0;
        if (this.extent != null) {
            LineSegment baseLine = this.getSquareBaseLine();
            baseX = baseLine.minX();
            baseY = baseLine.minY();
            double width = baseLine.getLength();
            int maxOrdinate = HilbertCode.maxOrdinate(level);
            scale = width / (double)maxOrdinate;
        }
        Coordinate[] pts = new Coordinate[nPts];
        for (int i = 0; i < nPts; ++i) {
            Coordinate pt = HilbertCode.decode(level, i);
            double x = HilbertCurveBuilder.transform(pt.getX(), scale, baseX);
            double y = HilbertCurveBuilder.transform(pt.getY(), scale, baseY);
            pts[i] = new Coordinate(x, y);
        }
        return this.geomFactory.createLineString(pts);
    }

    private static double transform(double val, double scale, double offset) {
        return val * scale + offset;
    }
}

