/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.converters;

import com.databricks.jdbc.api.impl.converters.ObjectConverter;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.exception.DatabricksValidationException;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class DoubleConverter
implements ObjectConverter {
    @Override
    public double toDouble(Object object) throws DatabricksSQLException {
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        throw new DatabricksSQLException("Unsupported type for DoubleObjectConverter: " + String.valueOf(object.getClass()), DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    @Override
    public boolean toBoolean(Object object) throws DatabricksSQLException {
        return this.toDouble(object) != 0.0;
    }

    @Override
    public byte toByte(Object object) throws DatabricksSQLException {
        double value = this.toDouble(object);
        if (value >= -128.0 && value <= 127.0) {
            return (byte)value;
        }
        throw new DatabricksValidationException("Invalid conversion: Double value out of byte range");
    }

    @Override
    public short toShort(Object object) throws DatabricksSQLException {
        double value = this.toDouble(object);
        if (value >= -32768.0 && value <= 32767.0) {
            return (short)value;
        }
        throw new DatabricksValidationException("Invalid conversion: Double value out of short range");
    }

    @Override
    public int toInt(Object object) throws DatabricksSQLException {
        double value = this.toDouble(object);
        if (value >= -2.147483648E9 && value <= 2.147483647E9) {
            return (int)value;
        }
        throw new DatabricksValidationException("Invalid conversion: Double value out of int range");
    }

    @Override
    public long toLong(Object object) throws DatabricksSQLException {
        double value = this.toDouble(object);
        if (value >= -9.223372036854776E18 && value <= 9.223372036854776E18) {
            return (long)value;
        }
        throw new DatabricksValidationException("Invalid conversion: Double value out of long range");
    }

    @Override
    public float toFloat(Object object) throws DatabricksSQLException {
        double value = this.toDouble(object);
        if (value >= -3.4028234663852886E38 && value <= 3.4028234663852886E38) {
            return (float)value;
        }
        throw new DatabricksValidationException("Invalid conversion: Double value out of float range");
    }

    @Override
    public BigDecimal toBigDecimal(Object object) throws DatabricksSQLException {
        return BigDecimal.valueOf(this.toDouble(object));
    }

    @Override
    public BigInteger toBigInteger(Object object) throws DatabricksSQLException {
        return BigInteger.valueOf(this.toLong(object));
    }

    @Override
    public byte[] toByteArray(Object object) throws DatabricksSQLException {
        return ByteBuffer.allocate(8).putDouble(this.toDouble(object)).array();
    }

    @Override
    public String toString(Object object) throws DatabricksSQLException {
        return String.valueOf(this.toDouble(object));
    }
}

