/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.jarm;

import com.dataiku.dss.shadelib.com.nimbusds.jose.proc.SecurityContext;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.JWTClaimsSet;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.proc.BadJWTException;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.proc.ClockSkewAware;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.util.DateUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.ClientID;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Issuer;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.validators.BadJWTExceptions;
import com.dataiku.dss.shadelib.net.jcip.annotations.ThreadSafe;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ThreadSafe
public class JARMClaimsVerifier
implements JWTClaimsSetVerifier,
ClockSkewAware {
    private final Issuer expectedIssuer;
    private final ClientID expectedClientID;
    private int maxClockSkew;

    public JARMClaimsVerifier(Issuer issuer, ClientID clientID, int maxClockSkew) {
        this.expectedIssuer = Objects.requireNonNull(issuer);
        this.expectedClientID = Objects.requireNonNull(clientID);
        this.setMaxClockSkew(maxClockSkew);
    }

    public Issuer getExpectedIssuer() {
        return this.expectedIssuer;
    }

    public ClientID getClientID() {
        return this.expectedClientID;
    }

    @Override
    public int getMaxClockSkew() {
        return this.maxClockSkew;
    }

    @Override
    public void setMaxClockSkew(int maxClockSkew) {
        if (maxClockSkew < 0) {
            throw new IllegalArgumentException("The max clock skew must be zero or positive");
        }
        this.maxClockSkew = maxClockSkew;
    }

    public void verify(JWTClaimsSet claimsSet, SecurityContext ctx) throws BadJWTException {
        String tokenIssuer = claimsSet.getIssuer();
        if (tokenIssuer == null) {
            throw BadJWTExceptions.MISSING_ISS_CLAIM_EXCEPTION;
        }
        if (!this.expectedIssuer.getValue().equals(tokenIssuer)) {
            throw new BadJWTException("Unexpected JWT issuer: " + tokenIssuer);
        }
        List<String> tokenAudience = claimsSet.getAudience();
        if (tokenAudience == null || tokenAudience.isEmpty()) {
            throw BadJWTExceptions.MISSING_AUD_CLAIM_EXCEPTION;
        }
        if (!tokenAudience.contains(this.expectedClientID.getValue())) {
            throw new BadJWTException("Unexpected JWT audience: " + tokenAudience);
        }
        Date exp = claimsSet.getExpirationTime();
        if (exp == null) {
            throw BadJWTExceptions.MISSING_EXP_CLAIM_EXCEPTION;
        }
        Date nowRef = new Date();
        if (!DateUtils.isAfter(exp, nowRef, this.maxClockSkew)) {
            throw BadJWTExceptions.EXPIRED_EXCEPTION;
        }
    }
}

