/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.io.swagger.transform.migrate;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.node.ObjectNode;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.dataiku.dss.shadelib.com.google.common.net.InternetDomainName;
import com.dataiku.dss.shadelib.io.swagger.transform.migrate.SwaggerMigrator;
import com.dataiku.dss.shadelib.io.swagger.transform.migrate.resourcelisting.PathAppenderMigrator;
import com.dataiku.dss.shadelib.io.swagger.transform.util.MutableJsonTree;
import com.dataiku.dss.shadelib.io.swagger.transform.util.SwaggerMigrationException;
import com.dataiku.dss.shadelib.io.swagger.transform.util.SwaggerMigrators;
import com.dataiku.dss.shadelib.javax.annotation.Nonnull;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import java.net.URI;
import java.util.Objects;
import java.util.regex.Pattern;

public final class V11ResourceListingMigrator
implements SwaggerMigrator {
    private static final Pattern LEGAL_SCHEMES = Pattern.compile("https?", 2);

    private static String checkLegalBasePath(@Nonnull String input) {
        URI uri = URI.create(input).normalize();
        Preconditions.checkArgument(uri.isAbsolute(), "basePath has no scheme");
        String tmp = uri.getScheme();
        Preconditions.checkArgument(LEGAL_SCHEMES.matcher(tmp).matches(), "basePath has scheme " + tmp + ", expected either http or https");
        tmp = Strings.nullToEmpty(uri.getHost());
        Preconditions.checkArgument(InternetDomainName.isValid(tmp), "basePath has an invalid hostname " + tmp);
        tmp = Strings.nullToEmpty(uri.getPath());
        Preconditions.checkArgument(!tmp.endsWith("/"), "basePath's path component " + tmp + " must not end with a /");
        return uri.toString();
    }

    @Override
    @Nonnull
    public JsonNode migrate(@Nonnull JsonNode input) throws SwaggerMigrationException {
        Objects.requireNonNull(input);
        MutableJsonTree tree = new MutableJsonTree(input);
        SwaggerMigrator migrator = SwaggerMigrators.membersToString("swaggerVersion", "apiVersion");
        tree.applyMigrator(migrator);
        migrator = SwaggerMigrators.patchFromResource("/patches/v1.1/versionChange.json");
        tree.applyMigrator(migrator);
        if (input.path("basePath").isTextual()) {
            String basePath = input.get("basePath").textValue();
            ((ObjectNode)tree.getCurrentNode()).remove("basePath");
            try {
                basePath = V11ResourceListingMigrator.checkLegalBasePath(basePath);
            }
            catch (IllegalArgumentException e) {
                throw new SwaggerMigrationException(e.getMessage());
            }
            migrator = new PathAppenderMigrator(basePath);
            tree.setPointer(JsonPointer.of((Object)"apis", (Object[])new Object[0]));
            tree.applyMigratorToElements(migrator);
        }
        return tree.getBaseNode();
    }
}

