/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.hc.client5.http.impl.cookie;

import com.dataiku.dss.shadelib.org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import com.dataiku.dss.shadelib.org.apache.hc.client5.http.cookie.Cookie;
import com.dataiku.dss.shadelib.org.apache.hc.client5.http.cookie.CookieOrigin;
import com.dataiku.dss.shadelib.org.apache.hc.client5.http.cookie.MalformedCookieException;
import com.dataiku.dss.shadelib.org.apache.hc.client5.http.cookie.SetCookie;
import com.dataiku.dss.shadelib.org.apache.hc.core5.annotation.Contract;
import com.dataiku.dss.shadelib.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.dataiku.dss.shadelib.org.apache.hc.core5.util.Args;
import com.dataiku.dss.shadelib.org.apache.hc.core5.util.TextUtils;

@Contract(threading=ThreadingBehavior.STATELESS)
public class BasicPathHandler
implements CommonCookieAttributeHandler {
    public static final BasicPathHandler INSTANCE = new BasicPathHandler();

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setPath(!TextUtils.isBlank(value) ? value : "/");
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
    }

    static boolean pathMatch(String uriPath, String cookiePath) {
        String normalizedCookiePath = cookiePath;
        if (normalizedCookiePath == null) {
            normalizedCookiePath = "/";
        }
        if (normalizedCookiePath.length() > 1 && normalizedCookiePath.endsWith("/")) {
            normalizedCookiePath = normalizedCookiePath.substring(0, normalizedCookiePath.length() - 1);
        }
        if (uriPath.startsWith(normalizedCookiePath)) {
            if (normalizedCookiePath.equals("/")) {
                return true;
            }
            if (uriPath.length() == normalizedCookiePath.length()) {
                return true;
            }
            return uriPath.charAt(normalizedCookiePath.length()) == '/';
        }
        return false;
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return BasicPathHandler.pathMatch(origin.getPath(), cookie.getPath());
    }

    @Override
    public String getAttributeName() {
        return "path";
    }
}

