/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.hc.core5.http.message;

import com.dataiku.dss.shadelib.org.apache.hc.core5.http.EntityDetails;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.FormattedHeader;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.Header;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.HeaderElement;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.HttpMessage;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.MessageHeaders;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.Method;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.NameValuePair;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.message.BasicHeader;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.message.BasicHeaderElementIterator;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.message.BasicHeaderValueFormatter;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.message.BasicHeaderValueParser;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.message.BasicTokenIterator;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.message.BufferedHeader;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.message.ParserCursor;
import com.dataiku.dss.shadelib.org.apache.hc.core5.util.Args;
import com.dataiku.dss.shadelib.org.apache.hc.core5.util.CharArrayBuffer;
import com.dataiku.dss.shadelib.org.apache.hc.core5.util.Tokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;

public class MessageSupport {
    private static final Tokenizer.Delimiter COMMA = Tokenizer.delimiters(',');
    private static final Set<String> HOP_BY_HOP;

    private MessageSupport() {
    }

    public static void formatTokens(CharArrayBuffer dst, List<String> tokens) {
        Args.notNull(dst, "Destination");
        if (tokens == null) {
            return;
        }
        for (int i = 0; i < tokens.size(); ++i) {
            String element = tokens.get(i);
            if (i > 0) {
                dst.append(", ");
            }
            dst.append(element);
        }
    }

    public static void formatTokens(CharArrayBuffer dst, String ... tokens) {
        Args.notNull(dst, "Destination");
        boolean first = true;
        for (String token : tokens) {
            if (!first) {
                dst.append(", ");
            }
            dst.append(token);
            first = false;
        }
    }

    public static void formatTokens(CharArrayBuffer dst, Set<String> tokens) {
        Args.notNull(dst, "Destination");
        if (tokens == null) {
            return;
        }
        boolean first = true;
        for (String token : tokens) {
            if (!first) {
                dst.append(", ");
            }
            dst.append(token);
            first = false;
        }
    }

    @Deprecated
    public static Header format(String name, Set<String> tokens) {
        return MessageSupport.header(name, tokens);
    }

    public static Header headerOfTokens(String name, List<String> tokens) {
        Args.notBlank(name, "Header name");
        if (tokens == null) {
            return null;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(256);
        buffer.append(name);
        buffer.append(": ");
        MessageSupport.formatTokens(buffer, tokens);
        return BufferedHeader.create(buffer);
    }

    public static Header header(String name, Set<String> tokens) {
        Args.notBlank(name, "Header name");
        if (tokens == null) {
            return null;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(256);
        buffer.append(name);
        buffer.append(": ");
        MessageSupport.formatTokens(buffer, tokens);
        return BufferedHeader.create(buffer);
    }

    public static Header header(String name, String ... tokens) {
        Args.notBlank(name, "Header name");
        CharArrayBuffer buffer = new CharArrayBuffer(256);
        buffer.append(name);
        buffer.append(": ");
        MessageSupport.formatTokens(buffer, tokens);
        return BufferedHeader.create(buffer);
    }

    @Deprecated
    public static Header format(String name, String ... tokens) {
        return MessageSupport.headerOfTokens(name, Arrays.asList(tokens));
    }

    public static void parseTokens(CharSequence src, ParserCursor cursor, Consumer<String> consumer) {
        Args.notNull(src, "Source");
        Args.notNull(cursor, "Cursor");
        Args.notNull(consumer, "Consumer");
        while (!cursor.atEnd()) {
            int pos = cursor.getPos();
            if (src.charAt(pos) == ',') {
                cursor.updatePos(pos + 1);
            }
            String token = Tokenizer.INSTANCE.parseToken(src, (Tokenizer.Cursor)cursor, COMMA);
            consumer.accept(token);
        }
    }

    public static void parseTokens(Header header, Consumer<String> consumer) {
        Args.notNull(header, "Header");
        if (header instanceof FormattedHeader) {
            CharArrayBuffer buf = ((FormattedHeader)header).getBuffer();
            ParserCursor cursor = new ParserCursor(0, buf.length());
            cursor.updatePos(((FormattedHeader)header).getValuePos());
            MessageSupport.parseTokens(buf, cursor, consumer);
        } else {
            String value = header.getValue();
            ParserCursor cursor = new ParserCursor(0, value.length());
            MessageSupport.parseTokens(value, cursor, consumer);
        }
    }

    public static void parseTokens(MessageHeaders headers, String headerName, Consumer<String> consumer) {
        Args.notNull(headers, "Headers");
        Iterator<Header> it = headers.headerIterator(headerName);
        while (it.hasNext()) {
            MessageSupport.parseTokens(it.next(), consumer);
        }
    }

    public static Set<String> parseTokens(CharSequence src, ParserCursor cursor) {
        Args.notNull(src, "Source");
        Args.notNull(cursor, "Cursor");
        LinkedHashSet<String> tokens = new LinkedHashSet<String>();
        MessageSupport.parseTokens(src, cursor, tokens::add);
        return tokens;
    }

    public static Set<String> parseTokens(Header header) {
        Args.notNull(header, "Header");
        LinkedHashSet<String> tokens = new LinkedHashSet<String>();
        MessageSupport.parseTokens(header, tokens::add);
        return tokens;
    }

    public static Iterator<String> iterateTokens(MessageHeaders headers, String name) {
        Args.notNull(headers, "Message headers");
        Args.notBlank(name, "Header name");
        return new BasicTokenIterator(headers.headerIterator(name));
    }

    public static void formatElements(CharArrayBuffer dst, List<HeaderElement> elements) {
        Args.notNull(dst, "Destination");
        if (elements == null) {
            return;
        }
        for (int i = 0; i < elements.size(); ++i) {
            HeaderElement element = elements.get(i);
            if (i > 0) {
                dst.append(", ");
            }
            BasicHeaderValueFormatter.INSTANCE.formatHeaderElement(dst, element, false);
        }
    }

    public static void formatElements(CharArrayBuffer dst, HeaderElement ... elements) {
        MessageSupport.formatElements(dst, Arrays.asList(elements));
    }

    public static Header headerOfElements(String name, List<HeaderElement> elements) {
        Args.notBlank(name, "Header name");
        if (elements == null) {
            return null;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(256);
        buffer.append(name);
        buffer.append(": ");
        MessageSupport.formatElements(buffer, elements);
        return BufferedHeader.create(buffer);
    }

    public static Header header(String name, HeaderElement ... elements) {
        Args.notBlank(name, "Header name");
        CharArrayBuffer buffer = new CharArrayBuffer(256);
        buffer.append(name);
        buffer.append(": ");
        MessageSupport.formatElements(buffer, elements);
        return BufferedHeader.create(buffer);
    }

    public static void parseElements(CharSequence buffer, ParserCursor cursor, Consumer<HeaderElement> consumer) {
        Args.notNull(buffer, "Char sequence");
        Args.notNull(cursor, "Parser cursor");
        Args.notNull(consumer, "Consumer");
        while (!cursor.atEnd()) {
            char ch;
            HeaderElement element = BasicHeaderValueParser.INSTANCE.parseHeaderElement(buffer, cursor);
            consumer.accept(element);
            if (cursor.atEnd() || (ch = buffer.charAt(cursor.getPos())) != ',') continue;
            cursor.updatePos(cursor.getPos() + 1);
        }
    }

    public static void parseElements(Header header, Consumer<HeaderElement> consumer) {
        Args.notNull(header, "Header");
        if (header instanceof FormattedHeader) {
            CharArrayBuffer buf = ((FormattedHeader)header).getBuffer();
            ParserCursor cursor = new ParserCursor(0, buf.length());
            cursor.updatePos(((FormattedHeader)header).getValuePos());
            MessageSupport.parseElements(buf, cursor, consumer);
        } else {
            String value = header.getValue();
            ParserCursor cursor = new ParserCursor(0, value.length());
            MessageSupport.parseElements(value, cursor, consumer);
        }
    }

    public static void parseElements(MessageHeaders headers, String headerName, Consumer<HeaderElement> consumer) {
        Args.notNull(headers, "Headers");
        Iterator<Header> it = headers.headerIterator(headerName);
        while (it.hasNext()) {
            MessageSupport.parseElements(it.next(), consumer);
        }
    }

    @Deprecated
    public static HeaderElement[] parse(Header header) {
        ArrayList elements = new ArrayList();
        MessageSupport.parseElements(header, elements::add);
        return elements.toArray(new HeaderElement[0]);
    }

    public static List<HeaderElement> parseElements(Header header) {
        ArrayList<HeaderElement> elements = new ArrayList<HeaderElement>();
        MessageSupport.parseElements(header, elements::add);
        return elements;
    }

    public static Iterator<HeaderElement> iterate(MessageHeaders headers, String name) {
        Args.notNull(headers, "Message headers");
        Args.notBlank(name, "Header name");
        return new BasicHeaderElementIterator(headers.headerIterator(name));
    }

    public static void formatParameters(CharArrayBuffer dst, List<NameValuePair> params) {
        Args.notNull(dst, "Destination");
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.size(); ++i) {
            NameValuePair param = params.get(i);
            if (i > 0) {
                dst.append("; ");
            }
            BasicHeaderValueFormatter.INSTANCE.formatNameValuePair(dst, param, false);
        }
    }

    public static void formatParameters(CharArrayBuffer dst, NameValuePair ... params) {
        Args.notNull(dst, "Destination");
        if (params == null) {
            return;
        }
        boolean first = true;
        for (NameValuePair param : params) {
            if (!first) {
                dst.append("; ");
            }
            BasicHeaderValueFormatter.INSTANCE.formatNameValuePair(dst, param, false);
            first = false;
        }
    }

    public static void parseParameters(CharSequence src, ParserCursor cursor, Consumer<NameValuePair> consumer) {
        Args.notNull(src, "Source");
        Args.notNull(cursor, "Cursor");
        Args.notNull(consumer, "Consumer");
        while (!cursor.atEnd()) {
            NameValuePair param = BasicHeaderValueParser.INSTANCE.parseNameValuePair(src, cursor);
            consumer.accept(param);
            if (cursor.atEnd()) continue;
            char ch = src.charAt(cursor.getPos());
            if (ch == ';') {
                cursor.updatePos(cursor.getPos() + 1);
            }
            if (ch != ',') continue;
            break;
        }
    }

    public static void addContentTypeHeader(HttpMessage message, EntityDetails entity) {
        if (entity != null && entity.getContentType() != null && !message.containsHeader("Content-Type")) {
            message.addHeader(new BasicHeader("Content-Type", entity.getContentType()));
        }
    }

    public static void addContentEncodingHeader(HttpMessage message, EntityDetails entity) {
        if (entity != null && entity.getContentEncoding() != null && !message.containsHeader("Content-Encoding")) {
            message.addHeader(new BasicHeader("Content-Encoding", entity.getContentEncoding()));
        }
    }

    public static void addTrailerHeader(HttpMessage message, EntityDetails entity) {
        Set<String> trailerNames;
        if (entity != null && !message.containsHeader("Trailer") && (trailerNames = entity.getTrailerNames()) != null && !trailerNames.isEmpty()) {
            message.setHeader(MessageSupport.header("Trailer", trailerNames));
        }
    }

    public static boolean canResponseHaveBody(String method, HttpResponse response) {
        if (Method.HEAD.isSame(method)) {
            return false;
        }
        int status = response.getCode();
        if (Method.CONNECT.isSame(method) && status == 200) {
            return false;
        }
        return status >= 200 && status != 204 && status != 304;
    }

    public static boolean isHopByHop(String headerName) {
        if (headerName == null) {
            return false;
        }
        return HOP_BY_HOP.contains(headerName);
    }

    public static Set<String> hopByHopConnectionSpecific(MessageHeaders headers) {
        String connDirective;
        Header connectionHeader = headers.getFirstHeader("Connection");
        String string = connDirective = connectionHeader != null ? connectionHeader.getValue() : null;
        if (connDirective != null && !connDirective.equalsIgnoreCase("close") && !connDirective.equalsIgnoreCase("keep-alive")) {
            TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            result.addAll(HOP_BY_HOP);
            result.addAll(MessageSupport.parseTokens(connectionHeader));
            return result;
        }
        return HOP_BY_HOP;
    }

    static {
        TreeSet<String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        set.add("Connection");
        set.add("Content-Length");
        set.add("Transfer-Encoding");
        set.add("Host");
        set.add("Keep-Alive");
        set.add("TE");
        set.add("Upgrade");
        set.add("Proxy-Authorization");
        set.add("Proxy-Authentication-Info");
        set.add("Proxy-Authenticate");
        HOP_BY_HOP = Collections.unmodifiableSet(set);
    }
}

