/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.BaseAllMetadataTableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.BaseEntriesTable;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataTableType;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScanContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;

public class AllEntriesTable
extends BaseEntriesTable {
    AllEntriesTable(Table table) {
        this(table, table.name() + ".all_entries");
    }

    AllEntriesTable(Table table, String name) {
        super(table, name);
    }

    @Override
    public TableScan newScan() {
        return new Scan(this.table(), this.schema());
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.ALL_ENTRIES;
    }

    private static class Scan
    extends BaseAllMetadataTableScan {
        Scan(Table table, Schema schema) {
            super(table, schema, MetadataTableType.ALL_ENTRIES);
        }

        private Scan(Table table, Schema schema, TableScanContext context) {
            super(table, schema, MetadataTableType.ALL_ENTRIES, context);
        }

        @Override
        protected TableScan newRefinedScan(Table table, Schema schema, TableScanContext context) {
            return new Scan(table, schema, context);
        }

        @Override
        protected CloseableIterable<FileScanTask> doPlanFiles() {
            CloseableIterable<ManifestFile> manifests = this.reachableManifests(snapshot -> snapshot.allManifests(this.table().io()));
            return BaseEntriesTable.planFiles(this.table(), manifests, this.tableSchema(), this.schema(), this.context());
        }
    }
}

