/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataColumns;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.TypeUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import java.util.Set;
import java.util.stream.Collectors;

public class ChangelogUtil {
    private static final Schema CHANGELOG_METADATA = new Schema(MetadataColumns.CHANGE_TYPE, MetadataColumns.CHANGE_ORDINAL, MetadataColumns.COMMIT_SNAPSHOT_ID);
    private static final Set<Integer> CHANGELOG_METADATA_FIELD_IDS = CHANGELOG_METADATA.columns().stream().map(Types.NestedField::fieldId).collect(Collectors.toSet());

    private ChangelogUtil() {
    }

    public static Schema changelogSchema(Schema tableSchema) {
        return TypeUtil.join(tableSchema, CHANGELOG_METADATA);
    }

    public static Schema dropChangelogMetadata(Schema changelogSchema) {
        return TypeUtil.selectNot(changelogSchema, CHANGELOG_METADATA_FIELD_IDS);
    }
}

