/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.ContentFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.ScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;

public interface ContentScanTask<F extends ContentFile<F>>
extends ScanTask,
PartitionScanTask {
    public F file();

    @Override
    default public StructLike partition() {
        return this.file().partition();
    }

    @Override
    default public long sizeBytes() {
        return this.length();
    }

    public long start();

    public long length();

    public Expression residual();

    @Override
    default public long estimatedRowsCount() {
        long splitOffset = this.file().splitOffsets() != null ? this.file().splitOffsets().get(0) : 0L;
        double scannedFileFraction = (double)this.length() / (double)(this.file().fileSizeInBytes() - splitOffset);
        return (long)(scannedFileFraction * (double)this.file().recordCount());
    }
}

