/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.BaseEntriesTable;
import com.dataiku.dss.shadelib.org.apache.iceberg.BaseMetadataTableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataTableType;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScanContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;

public class ManifestEntriesTable
extends BaseEntriesTable {
    ManifestEntriesTable(Table table) {
        this(table, table.name() + ".entries");
    }

    ManifestEntriesTable(Table table, String name) {
        super(table, name);
    }

    @Override
    public TableScan newScan() {
        return new EntriesTableScan(this.table(), this.schema());
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.ENTRIES;
    }

    private static class EntriesTableScan
    extends BaseMetadataTableScan {
        EntriesTableScan(Table table, Schema schema) {
            super(table, schema, MetadataTableType.ENTRIES);
        }

        private EntriesTableScan(Table table, Schema schema, TableScanContext context) {
            super(table, schema, MetadataTableType.ENTRIES, context);
        }

        @Override
        protected TableScan newRefinedScan(Table table, Schema schema, TableScanContext context) {
            return new EntriesTableScan(table, schema, context);
        }

        @Override
        protected CloseableIterable<FileScanTask> doPlanFiles() {
            CloseableIterable<ManifestFile> manifests = CloseableIterable.withNoopClose(this.snapshot().allManifests(this.table().io()));
            return BaseEntriesTable.planFiles(this.table(), manifests, this.tableSchema(), this.schema(), this.context());
        }
    }
}

