/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.FileFormat;
import com.dataiku.dss.shadelib.org.apache.iceberg.GenericManifestFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.GenericPartitionFieldSummary;
import com.dataiku.dss.shadelib.org.apache.iceberg.InternalData;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestListWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.RuntimeIOException;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

class ManifestLists {
    private ManifestLists() {
    }

    static List<ManifestFile> read(InputFile manifestList) {
        LinkedList<ManifestFile> linkedList;
        block8: {
            CloseableIterable files = InternalData.read(FileFormat.AVRO, manifestList).setRootType(GenericManifestFile.class).setCustomType(508, GenericPartitionFieldSummary.class).project(ManifestFile.schema()).build();
            try {
                linkedList = Lists.newLinkedList(files);
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e, "Cannot read manifest list file: %s", manifestList.location());
                }
            }
            files.close();
        }
        return linkedList;
    }

    static ManifestListWriter write(int formatVersion, OutputFile manifestListFile, long snapshotId, Long parentSnapshotId, long sequenceNumber, Long firstRowId) {
        switch (formatVersion) {
            case 1: {
                Preconditions.checkArgument(sequenceNumber == 0L, "Invalid sequence number for v1 manifest list: %s", sequenceNumber);
                return new ManifestListWriter.V1Writer(manifestListFile, snapshotId, parentSnapshotId);
            }
            case 2: {
                return new ManifestListWriter.V2Writer(manifestListFile, snapshotId, parentSnapshotId, sequenceNumber);
            }
            case 3: {
                return new ManifestListWriter.V3Writer(manifestListFile, snapshotId, parentSnapshotId, sequenceNumber, firstRowId);
            }
            case 4: {
                return new ManifestListWriter.V4Writer(manifestListFile, snapshotId, parentSnapshotId, sequenceNumber, firstRowId);
            }
        }
        throw new UnsupportedOperationException("Cannot write manifest list for table version: " + formatVersion);
    }
}

