/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.BaseMetadataTable;
import com.dataiku.dss.shadelib.org.apache.iceberg.DataTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataTableType;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.StaticDataTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.StaticTableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScanContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.SnapshotUtil;
import java.util.ArrayList;

public class MetadataLogEntriesTable
extends BaseMetadataTable {
    private static final Schema METADATA_LOG_ENTRIES_SCHEMA = new Schema(Types.NestedField.required(1, "timestamp", Types.TimestampType.withZone()), Types.NestedField.required(2, "file", Types.StringType.get()), Types.NestedField.optional(3, "latest_snapshot_id", Types.LongType.get()), Types.NestedField.optional(4, "latest_schema_id", Types.IntegerType.get()), Types.NestedField.optional(5, "latest_sequence_number", Types.LongType.get()));

    MetadataLogEntriesTable(Table table) {
        this(table, table.name() + ".metadata_log_entries");
    }

    MetadataLogEntriesTable(Table table, String name) {
        super(table, name);
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.METADATA_LOG_ENTRIES;
    }

    @Override
    public TableScan newScan() {
        return new MetadataLogScan(this.table());
    }

    @Override
    public Schema schema() {
        return METADATA_LOG_ENTRIES_SCHEMA;
    }

    private DataTask task(TableScan scan) {
        TableMetadata current = this.table().operations().current();
        ArrayList<TableMetadata.MetadataLogEntry> metadataLogEntries = Lists.newArrayList(current.previousFiles().listIterator());
        metadataLogEntries.add(new TableMetadata.MetadataLogEntry(current.lastUpdatedMillis(), current.metadataFileLocation()));
        return StaticDataTask.of(this.table().io().newInputFile(current.metadataFileLocation()), this.schema(), scan.schema(), metadataLogEntries, metadataLogEntry -> MetadataLogEntriesTable.metadataLogEntryToRow(metadataLogEntry, this.table()));
    }

    private static StaticDataTask.Row metadataLogEntryToRow(TableMetadata.MetadataLogEntry metadataLogEntry, Table table) {
        Long latestSnapshotId = null;
        Snapshot latestSnapshot = null;
        try {
            latestSnapshotId = SnapshotUtil.snapshotIdAsOfTime(table, metadataLogEntry.timestampMillis());
            latestSnapshot = table.snapshot(latestSnapshotId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return StaticDataTask.Row.of(metadataLogEntry.timestampMillis() * 1000L, metadataLogEntry.file(), latestSnapshotId, latestSnapshot != null ? latestSnapshot.schemaId() : null, latestSnapshot != null ? Long.valueOf(latestSnapshot.sequenceNumber()) : null);
    }

    private class MetadataLogScan
    extends StaticTableScan {
        MetadataLogScan(Table table) {
            super(table, METADATA_LOG_ENTRIES_SCHEMA, MetadataTableType.METADATA_LOG_ENTRIES, (StaticTableScan x$0) -> MetadataLogEntriesTable.this.task((TableScan)x$0));
        }

        MetadataLogScan(Table table, TableScanContext context) {
            super(table, METADATA_LOG_ENTRIES_SCHEMA, MetadataTableType.METADATA_LOG_ENTRIES, x$0 -> MetadataLogEntriesTable.this.task((TableScan)x$0), context);
        }

        @Override
        protected TableScan newRefinedScan(Table table, Schema schema, TableScanContext context) {
            return new MetadataLogScan(table, context);
        }

        @Override
        public CloseableIterable<FileScanTask> planFiles() {
            return CloseableIterable.withNoopClose(MetadataLogEntriesTable.this.task(this));
        }
    }
}

