/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.AppendFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.BaseMetadataTable;
import com.dataiku.dss.shadelib.org.apache.iceberg.BaseTable;
import com.dataiku.dss.shadelib.org.apache.iceberg.BatchScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.ExpireSnapshots;
import com.dataiku.dss.shadelib.org.apache.iceberg.HasTableOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.HistoryEntry;
import com.dataiku.dss.shadelib.org.apache.iceberg.IncrementalAppendScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.IncrementalChangelogScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.LocationProviders;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManageSnapshots;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataTableType;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataTableUtils;
import com.dataiku.dss.shadelib.org.apache.iceberg.OverwriteFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpecParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionStatisticsFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.ReplacePartitions;
import com.dataiku.dss.shadelib.org.apache.iceberg.ReplaceSortOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.RewriteFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.RewriteManifests;
import com.dataiku.dss.shadelib.org.apache.iceberg.RowDelta;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.SchemaParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.SnapshotRef;
import com.dataiku.dss.shadelib.org.apache.iceberg.SortOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.SortOrderParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.StaticTableOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.StatisticsFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.Transaction;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateLocation;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdatePartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdatePartitionStatistics;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateProperties;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateSchema;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateStatistics;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptionManager;
import com.dataiku.dss.shadelib.org.apache.iceberg.hadoop.HadoopConfigurable;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.LocationProvider;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.SerializableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.SerializableSupplier;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;

public class SerializableTable
implements Table,
HasTableOperations,
Serializable {
    private static final int UNKNOWN_FORMAT_VERSION = -1;
    private final String name;
    private final String location;
    private final String metadataFileLocation;
    private final Map<String, String> properties;
    private final String schemaAsJson;
    private final int defaultSpecId;
    private final Map<Integer, String> specAsJsonMap;
    private final String sortOrderAsJson;
    private final FileIO io;
    private final EncryptionManager encryption;
    private final Map<String, SnapshotRef> refs;
    private final UUID uuid;
    private final int formatVersion;
    private volatile transient LocationProvider lazyLocationProvider = null;
    private volatile transient Table lazyTable = null;
    private volatile transient Schema lazySchema = null;
    private volatile transient Map<Integer, PartitionSpec> lazySpecs = null;
    private volatile transient SortOrder lazySortOrder = null;

    protected SerializableTable(Table table) {
        this.name = table.name();
        this.location = table.location();
        this.metadataFileLocation = this.metadataFileLocation(table);
        this.properties = SerializableMap.copyOf(table.properties());
        this.schemaAsJson = SchemaParser.toJson(table.schema());
        this.defaultSpecId = table.spec().specId();
        this.specAsJsonMap = Maps.newHashMap();
        Map<Integer, PartitionSpec> specs = table.specs();
        specs.forEach((specId, spec) -> this.specAsJsonMap.put((Integer)specId, PartitionSpecParser.toJson(spec)));
        this.sortOrderAsJson = SortOrderParser.toJson(table.sortOrder());
        this.io = this.fileIO(table);
        this.encryption = table.encryption();
        this.refs = SerializableMap.copyOf(table.refs());
        this.uuid = table.uuid();
        this.formatVersion = this.formatVersion(table);
    }

    public static Table copyOf(Table table) {
        if (table instanceof BaseMetadataTable) {
            return new SerializableMetadataTable((BaseMetadataTable)table);
        }
        return new SerializableTable(table);
    }

    public String metadataFileLocation() {
        if (this.metadataFileLocation == null) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not have a metadata file location");
        }
        return this.metadataFileLocation;
    }

    private String metadataFileLocation(Table table) {
        if (table instanceof HasTableOperations) {
            TableOperations ops = ((HasTableOperations)((Object)table)).operations();
            return ops.current().metadataFileLocation();
        }
        if (table instanceof BaseMetadataTable) {
            return ((BaseMetadataTable)table).table().operations().current().metadataFileLocation();
        }
        return null;
    }

    private FileIO fileIO(Table table) {
        if (table.io() instanceof HadoopConfigurable) {
            ((HadoopConfigurable)((Object)table.io())).serializeConfWith(SerializableConfSupplier::new);
        }
        return table.io();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table lazyTable() {
        if (this.lazyTable == null) {
            SerializableTable serializableTable = this;
            synchronized (serializableTable) {
                if (this.lazyTable == null) {
                    if (this.metadataFileLocation == null) {
                        throw new UnsupportedOperationException("Cannot load metadata: metadata file location is null");
                    }
                    StaticTableOperations ops = new StaticTableOperations(this.metadataFileLocation, this.io, this.locationProvider());
                    this.lazyTable = this.newTable(ops, this.name);
                }
            }
        }
        return this.lazyTable;
    }

    protected Table newTable(TableOperations ops, String tableName) {
        return new BaseTable(ops, tableName);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    public int formatVersion() {
        if (this.formatVersion == -1) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not have a format version");
        }
        return this.formatVersion;
    }

    private int formatVersion(Table table) {
        try {
            return TableUtil.formatVersion(table);
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema schema() {
        if (this.lazySchema == null) {
            SerializableTable serializableTable = this;
            synchronized (serializableTable) {
                if (this.lazySchema == null && this.lazyTable == null) {
                    this.lazySchema = SchemaParser.fromJson(this.schemaAsJson);
                } else if (this.lazySchema == null) {
                    this.lazySchema = this.lazyTable.schema();
                }
            }
        }
        return this.lazySchema;
    }

    @Override
    public Map<Integer, Schema> schemas() {
        return this.lazyTable().schemas();
    }

    @Override
    public PartitionSpec spec() {
        return this.specs().get(this.defaultSpecId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, PartitionSpec> specs() {
        if (this.lazySpecs == null) {
            SerializableTable serializableTable = this;
            synchronized (serializableTable) {
                if (this.lazySpecs == null && this.lazyTable == null) {
                    HashMap<Integer, PartitionSpec> specs = Maps.newHashMapWithExpectedSize(this.specAsJsonMap.size());
                    this.specAsJsonMap.forEach((specId, specAsJson) -> specs.put((Integer)specId, PartitionSpecParser.fromJson(this.schema(), specAsJson)));
                    this.lazySpecs = specs;
                } else if (this.lazySpecs == null) {
                    this.lazySpecs = this.lazyTable.specs();
                }
            }
        }
        return this.lazySpecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortOrder sortOrder() {
        if (this.lazySortOrder == null) {
            SerializableTable serializableTable = this;
            synchronized (serializableTable) {
                if (this.lazySortOrder == null && this.lazyTable == null) {
                    this.lazySortOrder = SortOrderParser.fromJson(this.schema(), this.sortOrderAsJson);
                } else if (this.lazySortOrder == null) {
                    this.lazySortOrder = this.lazyTable.sortOrder();
                }
            }
        }
        return this.lazySortOrder;
    }

    @Override
    public Map<Integer, SortOrder> sortOrders() {
        return this.lazyTable().sortOrders();
    }

    @Override
    public FileIO io() {
        return this.io;
    }

    @Override
    public EncryptionManager encryption() {
        return this.encryption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocationProvider locationProvider() {
        if (this.lazyLocationProvider == null) {
            SerializableTable serializableTable = this;
            synchronized (serializableTable) {
                if (this.lazyLocationProvider == null) {
                    this.lazyLocationProvider = LocationProviders.locationsFor(this.location, this.properties);
                }
            }
        }
        return this.lazyLocationProvider;
    }

    @Override
    public List<StatisticsFile> statisticsFiles() {
        return this.lazyTable().statisticsFiles();
    }

    @Override
    public List<PartitionStatisticsFile> partitionStatisticsFiles() {
        return this.lazyTable().partitionStatisticsFiles();
    }

    @Override
    public Map<String, SnapshotRef> refs() {
        return this.refs;
    }

    @Override
    public UUID uuid() {
        return this.uuid;
    }

    @Override
    public void refresh() {
        throw new UnsupportedOperationException(this.errorMsg("refresh"));
    }

    @Override
    public TableScan newScan() {
        return this.lazyTable().newScan();
    }

    @Override
    public IncrementalAppendScan newIncrementalAppendScan() {
        return this.lazyTable().newIncrementalAppendScan();
    }

    @Override
    public IncrementalChangelogScan newIncrementalChangelogScan() {
        return this.lazyTable().newIncrementalChangelogScan();
    }

    @Override
    public BatchScan newBatchScan() {
        return this.lazyTable().newBatchScan();
    }

    @Override
    public Snapshot currentSnapshot() {
        return this.lazyTable().currentSnapshot();
    }

    @Override
    public Snapshot snapshot(long snapshotId) {
        return this.lazyTable().snapshot(snapshotId);
    }

    @Override
    public Iterable<Snapshot> snapshots() {
        return this.lazyTable().snapshots();
    }

    @Override
    public List<HistoryEntry> history() {
        return this.lazyTable().history();
    }

    @Override
    public UpdateSchema updateSchema() {
        throw new UnsupportedOperationException(this.errorMsg("updateSchema"));
    }

    @Override
    public UpdatePartitionSpec updateSpec() {
        throw new UnsupportedOperationException(this.errorMsg("updateSpec"));
    }

    @Override
    public UpdateProperties updateProperties() {
        throw new UnsupportedOperationException(this.errorMsg("updateProperties"));
    }

    @Override
    public ReplaceSortOrder replaceSortOrder() {
        throw new UnsupportedOperationException(this.errorMsg("replaceSortOrder"));
    }

    @Override
    public UpdateLocation updateLocation() {
        throw new UnsupportedOperationException(this.errorMsg("updateLocation"));
    }

    @Override
    public AppendFiles newAppend() {
        throw new UnsupportedOperationException(this.errorMsg("newAppend"));
    }

    @Override
    public RewriteFiles newRewrite() {
        throw new UnsupportedOperationException(this.errorMsg("newRewrite"));
    }

    @Override
    public RewriteManifests rewriteManifests() {
        throw new UnsupportedOperationException(this.errorMsg("rewriteManifests"));
    }

    @Override
    public OverwriteFiles newOverwrite() {
        throw new UnsupportedOperationException(this.errorMsg("newOverwrite"));
    }

    @Override
    public RowDelta newRowDelta() {
        throw new UnsupportedOperationException(this.errorMsg("newRowDelta"));
    }

    @Override
    public ReplacePartitions newReplacePartitions() {
        throw new UnsupportedOperationException(this.errorMsg("newReplacePartitions"));
    }

    @Override
    public DeleteFiles newDelete() {
        throw new UnsupportedOperationException(this.errorMsg("newDelete"));
    }

    @Override
    public UpdateStatistics updateStatistics() {
        throw new UnsupportedOperationException(this.errorMsg("updateStatistics"));
    }

    @Override
    public UpdatePartitionStatistics updatePartitionStatistics() {
        throw new UnsupportedOperationException(this.errorMsg("updatePartitionStatistics"));
    }

    @Override
    public ExpireSnapshots expireSnapshots() {
        throw new UnsupportedOperationException(this.errorMsg("expireSnapshots"));
    }

    @Override
    public ManageSnapshots manageSnapshots() {
        throw new UnsupportedOperationException(this.errorMsg("manageSnapshots"));
    }

    @Override
    public Transaction newTransaction() {
        throw new UnsupportedOperationException(this.errorMsg("newTransaction"));
    }

    @Override
    public StaticTableOperations operations() {
        return (StaticTableOperations)((BaseTable)this.lazyTable()).operations();
    }

    private String errorMsg(String operation) {
        return String.format("Operation %s is not supported after the table is serialized", operation);
    }

    public static class SerializableMetadataTable
    extends SerializableTable {
        private final MetadataTableType type;
        private final String baseTableName;

        protected SerializableMetadataTable(BaseMetadataTable metadataTable) {
            super(metadataTable);
            this.type = metadataTable.metadataTableType();
            this.baseTableName = metadataTable.table().name();
        }

        @Override
        protected Table newTable(TableOperations ops, String tableName) {
            return MetadataTableUtils.createMetadataTableInstance(ops, this.baseTableName, tableName, this.type);
        }

        @Override
        public StaticTableOperations operations() {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not support operations()");
        }

        public MetadataTableType type() {
            return this.type;
        }
    }

    private static class SerializableConfSupplier
    implements SerializableSupplier<Configuration> {
        private final Map<String, String> confAsMap;
        private volatile transient Configuration conf = null;

        SerializableConfSupplier(Configuration conf) {
            this.confAsMap = Maps.newHashMapWithExpectedSize(conf.size());
            conf.forEach(entry -> this.confAsMap.put((String)entry.getKey(), (String)entry.getValue()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Configuration get() {
            if (this.conf == null) {
                SerializableConfSupplier serializableConfSupplier = this;
                synchronized (serializableConfSupplier) {
                    if (this.conf == null) {
                        Configuration newConf = new Configuration(false);
                        this.confAsMap.forEach((arg_0, arg_1) -> ((Configuration)newConf).set(arg_0, arg_1));
                        this.conf = newConf;
                    }
                }
            }
            return this.conf;
        }
    }
}

