/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.Accessor;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Transform;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.SerializableFunction;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;

class StructTransform
implements StructLike,
Serializable {
    private final int size;
    private final Accessor<StructLike>[] accessors;
    private final SerializableFunction[] transforms;
    private final Object[] transformedTuple;

    StructTransform(Schema schema, List<FieldTransform> fieldTransforms) {
        Preconditions.checkArgument(fieldTransforms != null, "Invalid field transform list: null");
        this.size = fieldTransforms.size();
        this.accessors = (Accessor[])Array.newInstance(Accessor.class, this.size);
        this.transforms = new SerializableFunction[this.size];
        for (int i = 0; i < this.size; ++i) {
            int sourceFieldId = fieldTransforms.get(i).sourceFieldId();
            Transform<?, ?> transform = fieldTransforms.get(i).transform();
            Accessor<StructLike> accessor = schema.accessorForField(sourceFieldId);
            Preconditions.checkArgument(accessor != null, "Cannot build accessor for field: %s", (Object)schema.findField(sourceFieldId));
            this.accessors[i] = accessor;
            this.transforms[i] = transform.bind(accessor.type());
        }
        this.transformedTuple = new Object[this.size];
    }

    StructTransform(StructTransform toCopy) {
        this.size = toCopy.size;
        this.accessors = toCopy.accessors;
        this.transforms = toCopy.transforms;
        this.transformedTuple = new Object[this.size];
        System.arraycopy(toCopy.transformedTuple, 0, this.transformedTuple, 0, this.size);
    }

    public void wrap(StructLike row) {
        for (int i = 0; i < this.transformedTuple.length; ++i) {
            SerializableFunction transform = this.transforms[i];
            this.transformedTuple[i] = transform.apply(this.accessors[i].get(row));
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        return javaClass.cast(this.transformedTuple[pos]);
    }

    @Override
    public <T> void set(int pos, T value) {
        this.transformedTuple[pos] = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.transformedTuple.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.transformedTuple[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StructTransform)) {
            return false;
        }
        StructTransform that = (StructTransform)o;
        return Arrays.equals(this.transformedTuple, that.transformedTuple);
    }

    public int hashCode() {
        return Arrays.hashCode(this.transformedTuple);
    }

    static class FieldTransform {
        private final int sourceFieldId;
        private final Transform<?, ?> transform;

        FieldTransform(int sourceFieldId, Transform<?, ?> transform) {
            this.sourceFieldId = sourceFieldId;
            this.transform = transform;
        }

        int sourceFieldId() {
            return this.sourceFieldId;
        }

        Transform<?, ?> transform() {
            return this.transform;
        }
    }
}

