/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.data;

import com.dataiku.dss.shadelib.org.apache.iceberg.FileFormat;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetricsConfig;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.SortOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.avro.Avro;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.EqualityDeleteWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.PositionDeleteWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedOutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptionKeyMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DataWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileWriterFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.orc.ORC;
import com.dataiku.dss.shadelib.org.apache.iceberg.parquet.Parquet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;

public abstract class BaseFileWriterFactory<T>
implements FileWriterFactory<T> {
    private final Table table;
    private final FileFormat dataFileFormat;
    private final Schema dataSchema;
    private final SortOrder dataSortOrder;
    private final FileFormat deleteFileFormat;
    private final int[] equalityFieldIds;
    private final Schema equalityDeleteRowSchema;
    private final SortOrder equalityDeleteSortOrder;
    private final Schema positionDeleteRowSchema;

    protected BaseFileWriterFactory(Table table, FileFormat dataFileFormat, Schema dataSchema, SortOrder dataSortOrder, FileFormat deleteFileFormat, int[] equalityFieldIds, Schema equalityDeleteRowSchema, SortOrder equalityDeleteSortOrder, Schema positionDeleteRowSchema) {
        this.table = table;
        this.dataFileFormat = dataFileFormat;
        this.dataSchema = dataSchema;
        this.dataSortOrder = dataSortOrder;
        this.deleteFileFormat = deleteFileFormat;
        this.equalityFieldIds = equalityFieldIds;
        this.equalityDeleteRowSchema = equalityDeleteRowSchema;
        this.equalityDeleteSortOrder = equalityDeleteSortOrder;
        this.positionDeleteRowSchema = positionDeleteRowSchema;
    }

    protected abstract void configureDataWrite(Avro.DataWriteBuilder var1);

    protected abstract void configureEqualityDelete(Avro.DeleteWriteBuilder var1);

    protected abstract void configurePositionDelete(Avro.DeleteWriteBuilder var1);

    protected abstract void configureDataWrite(Parquet.DataWriteBuilder var1);

    protected abstract void configureEqualityDelete(Parquet.DeleteWriteBuilder var1);

    protected abstract void configurePositionDelete(Parquet.DeleteWriteBuilder var1);

    protected abstract void configureDataWrite(ORC.DataWriteBuilder var1);

    protected abstract void configureEqualityDelete(ORC.DeleteWriteBuilder var1);

    protected abstract void configurePositionDelete(ORC.DeleteWriteBuilder var1);

    @Override
    public DataWriter<T> newDataWriter(EncryptedOutputFile file, PartitionSpec spec, StructLike partition) {
        EncryptionKeyMetadata keyMetadata = file.keyMetadata();
        Map<String, String> properties = this.table.properties();
        MetricsConfig metricsConfig = MetricsConfig.forTable(this.table);
        try {
            switch (this.dataFileFormat) {
                case AVRO: {
                    Avro.DataWriteBuilder avroBuilder = Avro.writeData(file).schema(this.dataSchema).setAll(properties).metricsConfig(metricsConfig).withSpec(spec).withPartition(partition).withKeyMetadata(keyMetadata).withSortOrder(this.dataSortOrder).overwrite();
                    this.configureDataWrite(avroBuilder);
                    return avroBuilder.build();
                }
                case PARQUET: {
                    Parquet.DataWriteBuilder parquetBuilder = Parquet.writeData(file).schema(this.dataSchema).setAll(properties).metricsConfig(metricsConfig).withSpec(spec).withPartition(partition).withKeyMetadata(keyMetadata).withSortOrder(this.dataSortOrder).overwrite();
                    this.configureDataWrite(parquetBuilder);
                    return parquetBuilder.build();
                }
                case ORC: {
                    ORC.DataWriteBuilder orcBuilder = ORC.writeData((EncryptedOutputFile)file).schema(this.dataSchema).setAll(properties).metricsConfig(metricsConfig).withSpec(spec).withPartition(partition).withKeyMetadata(keyMetadata).withSortOrder(this.dataSortOrder).overwrite();
                    this.configureDataWrite(orcBuilder);
                    return orcBuilder.build();
                }
            }
            throw new UnsupportedOperationException("Unsupported data file format: " + String.valueOf((Object)this.dataFileFormat));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public EqualityDeleteWriter<T> newEqualityDeleteWriter(EncryptedOutputFile file, PartitionSpec spec, StructLike partition) {
        EncryptionKeyMetadata keyMetadata = file.keyMetadata();
        Map<String, String> properties = this.table.properties();
        MetricsConfig metricsConfig = MetricsConfig.forTable(this.table);
        try {
            switch (this.deleteFileFormat) {
                case AVRO: {
                    Avro.DeleteWriteBuilder avroBuilder = Avro.writeDeletes(file).setAll(properties).metricsConfig(metricsConfig).rowSchema(this.equalityDeleteRowSchema).equalityFieldIds(this.equalityFieldIds).withSpec(spec).withPartition(partition).withKeyMetadata(keyMetadata).withSortOrder(this.equalityDeleteSortOrder).overwrite();
                    this.configureEqualityDelete(avroBuilder);
                    return avroBuilder.buildEqualityWriter();
                }
                case PARQUET: {
                    Parquet.DeleteWriteBuilder parquetBuilder = Parquet.writeDeletes(file).setAll(properties).metricsConfig(metricsConfig).rowSchema(this.equalityDeleteRowSchema).equalityFieldIds(this.equalityFieldIds).withSpec(spec).withPartition(partition).withKeyMetadata(keyMetadata).withSortOrder(this.equalityDeleteSortOrder).overwrite();
                    this.configureEqualityDelete(parquetBuilder);
                    return parquetBuilder.buildEqualityWriter();
                }
                case ORC: {
                    ORC.DeleteWriteBuilder orcBuilder = ORC.writeDeletes((EncryptedOutputFile)file).setAll(properties).metricsConfig(metricsConfig).rowSchema(this.equalityDeleteRowSchema).equalityFieldIds(this.equalityFieldIds).withSpec(spec).withPartition(partition).withKeyMetadata(keyMetadata).withSortOrder(this.equalityDeleteSortOrder).overwrite();
                    this.configureEqualityDelete(orcBuilder);
                    return orcBuilder.buildEqualityWriter();
                }
            }
            throw new UnsupportedOperationException("Unsupported format for equality deletes: " + String.valueOf((Object)this.deleteFileFormat));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create new equality delete writer", e);
        }
    }

    @Override
    public PositionDeleteWriter<T> newPositionDeleteWriter(EncryptedOutputFile file, PartitionSpec spec, StructLike partition) {
        EncryptionKeyMetadata keyMetadata = file.keyMetadata();
        Map<String, String> properties = this.table.properties();
        MetricsConfig metricsConfig = MetricsConfig.forPositionDelete(this.table);
        try {
            switch (this.deleteFileFormat) {
                case AVRO: {
                    Avro.DeleteWriteBuilder avroBuilder = Avro.writeDeletes(file).setAll(properties).metricsConfig(metricsConfig).rowSchema(this.positionDeleteRowSchema).withSpec(spec).withPartition(partition).withKeyMetadata(keyMetadata).overwrite();
                    this.configurePositionDelete(avroBuilder);
                    return avroBuilder.buildPositionWriter();
                }
                case PARQUET: {
                    Parquet.DeleteWriteBuilder parquetBuilder = Parquet.writeDeletes(file).setAll(properties).metricsConfig(metricsConfig).rowSchema(this.positionDeleteRowSchema).withSpec(spec).withPartition(partition).withKeyMetadata(keyMetadata).overwrite();
                    this.configurePositionDelete(parquetBuilder);
                    return parquetBuilder.buildPositionWriter();
                }
                case ORC: {
                    ORC.DeleteWriteBuilder orcBuilder = ORC.writeDeletes((EncryptedOutputFile)file).setAll(properties).metricsConfig(metricsConfig).rowSchema(this.positionDeleteRowSchema).withSpec(spec).withPartition(partition).withKeyMetadata(keyMetadata).overwrite();
                    this.configurePositionDelete(orcBuilder);
                    return orcBuilder.buildPositionWriter();
                }
            }
            throw new UnsupportedOperationException("Unsupported format for position deletes: " + String.valueOf((Object)this.deleteFileFormat));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create new position delete writer", e);
        }
    }

    protected Schema dataSchema() {
        return this.dataSchema;
    }

    protected Schema equalityDeleteRowSchema() {
        return this.equalityDeleteRowSchema;
    }

    protected Schema positionDeleteRowSchema() {
        return this.positionDeleteRowSchema;
    }
}

