/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.data;

import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.Record;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Objects;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ByteBuffers;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenericRecord
implements Record,
StructLike {
    private static final LoadingCache<Types.StructType, Map<String, Integer>> NAME_MAP_CACHE = Caffeine.newBuilder().weakKeys().build(struct -> {
        HashMap<String, Integer> idToPos = Maps.newHashMap();
        List<Types.NestedField> fields = struct.fields();
        for (int i = 0; i < fields.size(); ++i) {
            idToPos.put(fields.get(i).name(), i);
        }
        return idToPos;
    });
    private final Types.StructType struct;
    private final int size;
    private final Object[] values;
    private final Map<String, Integer> nameToPos;

    public static GenericRecord create(Schema schema) {
        return new GenericRecord(schema.asStruct());
    }

    public static GenericRecord create(Types.StructType struct) {
        return new GenericRecord(struct);
    }

    private GenericRecord(Types.StructType struct) {
        this.struct = struct;
        this.size = struct.fields().size();
        this.values = new Object[this.size];
        this.nameToPos = (Map)NAME_MAP_CACHE.get((Object)struct);
    }

    private GenericRecord(GenericRecord toCopy) {
        this.struct = toCopy.struct;
        this.size = toCopy.size;
        this.values = new Object[toCopy.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = this.deepCopyValue(toCopy.values[i]);
        }
        this.nameToPos = toCopy.nameToPos;
    }

    private Object deepCopyValue(Object value) {
        if (value instanceof ByteBuffer) {
            return ByteBuffers.copy((ByteBuffer)value);
        }
        if (value instanceof GenericRecord) {
            return ((GenericRecord)value).copy();
        }
        return value;
    }

    private GenericRecord(GenericRecord toCopy, Map<String, Object> overwrite) {
        this.struct = toCopy.struct;
        this.size = toCopy.size;
        this.values = Arrays.copyOf(toCopy.values, toCopy.values.length);
        this.nameToPos = toCopy.nameToPos;
        for (Map.Entry<String, Object> entry : overwrite.entrySet()) {
            this.setField(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Types.StructType struct() {
        return this.struct;
    }

    @Override
    public Object getField(String name) {
        Integer pos = this.nameToPos.get(name);
        if (pos != null) {
            return this.values[pos];
        }
        return null;
    }

    @Override
    public void setField(String name, Object value) {
        Integer pos = this.nameToPos.get(name);
        Preconditions.checkArgument(pos != null, "Cannot set unknown field named: %s", (Object)name);
        this.values[pos.intValue()] = value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object get(int pos) {
        return this.values[pos];
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        Object value = this.get(pos);
        if (value == null || javaClass.isInstance(value)) {
            return javaClass.cast(value);
        }
        throw new IllegalStateException("Not an instance of " + javaClass.getName() + ": " + String.valueOf(value));
    }

    @Override
    public <T> void set(int pos, T value) {
        this.values[pos] = value;
    }

    @Override
    public GenericRecord copy() {
        return new GenericRecord(this);
    }

    @Override
    public GenericRecord copy(Map<String, Object> overwriteValues) {
        return new GenericRecord(this, overwriteValues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Record(");
        for (int i = 0; i < this.values.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.values[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GenericRecord)) {
            return false;
        }
        GenericRecord that = (GenericRecord)other;
        return Arrays.deepEquals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hashCode(this.values);
    }
}

