/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.encryption;

import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedInputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedOutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptionKeyMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptionManager;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaintextEncryptionManager
implements EncryptionManager {
    private static final EncryptionManager INSTANCE = new PlaintextEncryptionManager();
    private static final Logger LOG = LoggerFactory.getLogger(PlaintextEncryptionManager.class);

    private PlaintextEncryptionManager() {
    }

    public static EncryptionManager instance() {
        return INSTANCE;
    }

    @Override
    public InputFile decrypt(EncryptedInputFile encrypted) {
        if (encrypted.keyMetadata().buffer() != null) {
            LOG.warn("File encryption key metadata is present, but no encryption has been configured.");
        }
        return encrypted.encryptedInputFile();
    }

    @Override
    public EncryptedOutputFile encrypt(OutputFile rawOutput) {
        return EncryptedFiles.encryptedOutput(rawOutput, EncryptionKeyMetadata.empty());
    }
}

