/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.expressions;

import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.ValidationException;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Aggregate;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.And;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Bound;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundAggregate;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundLiteralPredicate;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundPredicate;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundReference;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.BoundTerm;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Literal;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Not;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Or;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Predicate;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.UnboundAggregate;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.UnboundPredicate;
import java.util.Set;
import java.util.function.Supplier;

public class ExpressionVisitors {
    private ExpressionVisitors() {
    }

    public static <R> R visit(Expression expr, ExpressionVisitor<R> visitor) {
        if (expr instanceof Predicate) {
            if (expr instanceof BoundPredicate) {
                return visitor.predicate((BoundPredicate)expr);
            }
            return visitor.predicate((UnboundPredicate)expr);
        }
        if (expr instanceof Aggregate) {
            if (expr instanceof BoundAggregate) {
                return visitor.aggregate((BoundAggregate)expr);
            }
            return visitor.aggregate((UnboundAggregate)expr);
        }
        switch (expr.op()) {
            case TRUE: {
                return visitor.alwaysTrue();
            }
            case FALSE: {
                return visitor.alwaysFalse();
            }
            case NOT: {
                Not not = (Not)expr;
                return visitor.not(ExpressionVisitors.visit(not.child(), visitor));
            }
            case AND: {
                And and = (And)expr;
                return visitor.and(ExpressionVisitors.visit(and.left(), visitor), ExpressionVisitors.visit(and.right(), visitor));
            }
            case OR: {
                Or or = (Or)expr;
                return visitor.or(ExpressionVisitors.visit(or.left(), visitor), ExpressionVisitors.visit(or.right(), visitor));
            }
        }
        throw new UnsupportedOperationException("Unknown operation: " + String.valueOf((Object)expr.op()));
    }

    public static Boolean visitEvaluator(Expression expr, ExpressionVisitor<Boolean> visitor) {
        if (expr instanceof Predicate) {
            if (expr instanceof BoundPredicate) {
                return visitor.predicate((BoundPredicate)expr);
            }
            return visitor.predicate((UnboundPredicate)expr);
        }
        switch (expr.op()) {
            case TRUE: {
                return visitor.alwaysTrue();
            }
            case FALSE: {
                return visitor.alwaysFalse();
            }
            case NOT: {
                Not not = (Not)expr;
                return visitor.not(ExpressionVisitors.visitEvaluator(not.child(), visitor));
            }
            case AND: {
                And and = (And)expr;
                Boolean andLeftOperand = ExpressionVisitors.visitEvaluator(and.left(), visitor);
                if (!andLeftOperand.booleanValue()) {
                    return visitor.alwaysFalse();
                }
                return visitor.and(Boolean.TRUE, ExpressionVisitors.visitEvaluator(and.right(), visitor));
            }
            case OR: {
                Or or = (Or)expr;
                Boolean orLeftOperand = ExpressionVisitors.visitEvaluator(or.left(), visitor);
                if (orLeftOperand.booleanValue()) {
                    return visitor.alwaysTrue();
                }
                return visitor.or(Boolean.FALSE, ExpressionVisitors.visitEvaluator(or.right(), visitor));
            }
        }
        throw new UnsupportedOperationException("Unknown operation: " + String.valueOf((Object)expr.op()));
    }

    public static <R> R visit(Expression expr, CustomOrderExpressionVisitor<R> visitor) {
        return ExpressionVisitors.visitExpr(expr, visitor).get();
    }

    private static <R> Supplier<R> visitExpr(Expression expr, CustomOrderExpressionVisitor<R> visitor) {
        if (expr instanceof Predicate) {
            if (expr instanceof BoundPredicate) {
                return () -> visitor.predicate((BoundPredicate)expr);
            }
            return () -> visitor.predicate((UnboundPredicate)expr);
        }
        switch (expr.op()) {
            case TRUE: {
                return visitor::alwaysTrue;
            }
            case FALSE: {
                return visitor::alwaysFalse;
            }
            case NOT: {
                Not not = (Not)expr;
                return () -> visitor.not(ExpressionVisitors.visitExpr(not.child(), visitor));
            }
            case AND: {
                And and = (And)expr;
                return () -> visitor.and(ExpressionVisitors.visitExpr(and.left(), visitor), ExpressionVisitors.visitExpr(and.right(), visitor));
            }
            case OR: {
                Or or = (Or)expr;
                return () -> visitor.or(ExpressionVisitors.visitExpr(or.left(), visitor), ExpressionVisitors.visitExpr(or.right(), visitor));
            }
        }
        throw new UnsupportedOperationException("Unknown operation: " + String.valueOf((Object)expr.op()));
    }

    public static abstract class ExpressionVisitor<R> {
        public R alwaysTrue() {
            return null;
        }

        public R alwaysFalse() {
            return null;
        }

        public R not(R result) {
            return null;
        }

        public R and(R leftResult, R rightResult) {
            return null;
        }

        public R or(R leftResult, R rightResult) {
            return null;
        }

        public <T> R predicate(BoundPredicate<T> pred) {
            return null;
        }

        public <T> R predicate(UnboundPredicate<T> pred) {
            return null;
        }

        public <T, C> R aggregate(BoundAggregate<T, C> agg) {
            throw new UnsupportedOperationException("Cannot visit aggregate expression");
        }

        public <T> R aggregate(UnboundAggregate<T> agg) {
            throw new UnsupportedOperationException("Cannot visit aggregate expression");
        }
    }

    public static abstract class CustomOrderExpressionVisitor<R> {
        public R alwaysTrue() {
            return null;
        }

        public R alwaysFalse() {
            return null;
        }

        public R not(Supplier<R> result) {
            return null;
        }

        public R and(Supplier<R> leftResult, Supplier<R> rightResult) {
            return null;
        }

        public R or(Supplier<R> leftResult, Supplier<R> rightResult) {
            return null;
        }

        public <T> R predicate(UnboundPredicate<T> pred) {
            throw new UnsupportedOperationException("Not a bound predicate: " + String.valueOf(pred));
        }

        public <T> R predicate(BoundPredicate<T> pred) {
            if (pred.isLiteralPredicate()) {
                BoundLiteralPredicate<T> literalPred = pred.asLiteralPredicate();
                switch (pred.op()) {
                    case LT: {
                        return this.lt((BoundTerm)pred.term(), literalPred.literal());
                    }
                    case LT_EQ: {
                        return this.ltEq((BoundTerm)pred.term(), literalPred.literal());
                    }
                    case GT: {
                        return this.gt((BoundTerm)pred.term(), literalPred.literal());
                    }
                    case GT_EQ: {
                        return this.gtEq((BoundTerm)pred.term(), literalPred.literal());
                    }
                    case EQ: {
                        return this.eq((BoundTerm)pred.term(), literalPred.literal());
                    }
                    case NOT_EQ: {
                        return this.notEq((BoundTerm)pred.term(), literalPred.literal());
                    }
                    case STARTS_WITH: {
                        return this.startsWith((BoundTerm)pred.term(), literalPred.literal());
                    }
                    case NOT_STARTS_WITH: {
                        return this.notStartsWith((BoundTerm)pred.term(), literalPred.literal());
                    }
                }
                throw new IllegalStateException("Invalid operation for BoundLiteralPredicate: " + String.valueOf((Object)pred.op()));
            }
            if (pred.isUnaryPredicate()) {
                switch (pred.op()) {
                    case IS_NULL: {
                        return this.isNull((BoundTerm)pred.term());
                    }
                    case NOT_NULL: {
                        return this.notNull((BoundTerm)pred.term());
                    }
                    case IS_NAN: {
                        return this.isNaN((BoundTerm)pred.term());
                    }
                    case NOT_NAN: {
                        return this.notNaN((BoundTerm)pred.term());
                    }
                }
                throw new IllegalStateException("Invalid operation for BoundUnaryPredicate: " + String.valueOf((Object)pred.op()));
            }
            if (pred.isSetPredicate()) {
                switch (pred.op()) {
                    case IN: {
                        return this.in((BoundTerm)pred.term(), pred.asSetPredicate().literalSet());
                    }
                    case NOT_IN: {
                        return this.notIn((BoundTerm)pred.term(), pred.asSetPredicate().literalSet());
                    }
                }
                throw new IllegalStateException("Invalid operation for BoundSetPredicate: " + String.valueOf((Object)pred.op()));
            }
            throw new IllegalStateException("Unsupported bound predicate: " + pred.getClass().getName());
        }

        public <T> R isNull(BoundTerm<T> term) {
            return null;
        }

        public <T> R notNull(BoundTerm<T> term) {
            return null;
        }

        public <T> R isNaN(BoundTerm<T> term) {
            return null;
        }

        public <T> R notNaN(BoundTerm<T> term) {
            return null;
        }

        public <T> R lt(BoundTerm<T> term, Literal<T> lit) {
            return null;
        }

        public <T> R ltEq(BoundTerm<T> term, Literal<T> lit) {
            return null;
        }

        public <T> R gt(BoundTerm<T> term, Literal<T> lit) {
            return null;
        }

        public <T> R gtEq(BoundTerm<T> term, Literal<T> lit) {
            return null;
        }

        public <T> R eq(BoundTerm<T> term, Literal<T> lit) {
            return null;
        }

        public <T> R notEq(BoundTerm<T> term, Literal<T> lit) {
            return null;
        }

        public <T> R in(BoundTerm<T> term, Set<T> literalSet) {
            return null;
        }

        public <T> R notIn(BoundTerm<T> term, Set<T> literalSet) {
            return null;
        }

        public <T> R startsWith(BoundTerm<T> term, Literal<T> lit) {
            return null;
        }

        public <T> R notStartsWith(BoundTerm<T> term, Literal<T> lit) {
            return null;
        }
    }

    public static abstract class BoundVisitor<R>
    extends ExpressionVisitor<R> {
        public <T> R isNull(Bound<T> expr) {
            return null;
        }

        public <T> R notNull(Bound<T> expr) {
            return null;
        }

        public <T> R isNaN(Bound<T> expr) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not implement isNaN");
        }

        public <T> R notNaN(Bound<T> expr) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not implement notNaN");
        }

        public <T> R lt(Bound<T> expr, Literal<T> lit) {
            return null;
        }

        public <T> R ltEq(Bound<T> expr, Literal<T> lit) {
            return null;
        }

        public <T> R gt(Bound<T> expr, Literal<T> lit) {
            return null;
        }

        public <T> R gtEq(Bound<T> expr, Literal<T> lit) {
            return null;
        }

        public <T> R eq(Bound<T> expr, Literal<T> lit) {
            return null;
        }

        public <T> R notEq(Bound<T> expr, Literal<T> lit) {
            return null;
        }

        public <T> R in(Bound<T> expr, Set<T> literalSet) {
            throw new UnsupportedOperationException("In operation is not supported by the visitor");
        }

        public <T> R notIn(Bound<T> expr, Set<T> literalSet) {
            throw new UnsupportedOperationException("notIn operation is not supported by the visitor");
        }

        public <T> R startsWith(Bound<T> expr, Literal<T> lit) {
            throw new UnsupportedOperationException("Unsupported operation.");
        }

        public <T> R notStartsWith(Bound<T> expr, Literal<T> lit) {
            throw new UnsupportedOperationException("Unsupported operation.");
        }

        @Override
        public <T> R predicate(BoundPredicate<T> pred) {
            if (pred.isLiteralPredicate()) {
                BoundLiteralPredicate<T> literalPred = pred.asLiteralPredicate();
                switch (pred.op()) {
                    case LT: {
                        return this.lt((Bound)pred.term(), literalPred.literal());
                    }
                    case LT_EQ: {
                        return this.ltEq((Bound)pred.term(), literalPred.literal());
                    }
                    case GT: {
                        return this.gt((Bound)pred.term(), literalPred.literal());
                    }
                    case GT_EQ: {
                        return this.gtEq((Bound)pred.term(), literalPred.literal());
                    }
                    case EQ: {
                        return this.eq((Bound)pred.term(), literalPred.literal());
                    }
                    case NOT_EQ: {
                        return this.notEq((Bound)pred.term(), literalPred.literal());
                    }
                    case STARTS_WITH: {
                        return this.startsWith((Bound)pred.term(), literalPred.literal());
                    }
                    case NOT_STARTS_WITH: {
                        return this.notStartsWith((Bound)pred.term(), literalPred.literal());
                    }
                }
                throw new IllegalStateException("Invalid operation for BoundLiteralPredicate: " + String.valueOf((Object)pred.op()));
            }
            if (pred.isUnaryPredicate()) {
                switch (pred.op()) {
                    case IS_NULL: {
                        return this.isNull((Bound)pred.term());
                    }
                    case NOT_NULL: {
                        return this.notNull((Bound)pred.term());
                    }
                    case IS_NAN: {
                        return this.isNaN((Bound)pred.term());
                    }
                    case NOT_NAN: {
                        return this.notNaN((Bound)pred.term());
                    }
                }
                throw new IllegalStateException("Invalid operation for BoundUnaryPredicate: " + String.valueOf((Object)pred.op()));
            }
            if (pred.isSetPredicate()) {
                switch (pred.op()) {
                    case IN: {
                        return this.in((Bound)pred.term(), pred.asSetPredicate().literalSet());
                    }
                    case NOT_IN: {
                        return this.notIn((Bound)pred.term(), pred.asSetPredicate().literalSet());
                    }
                }
                throw new IllegalStateException("Invalid operation for BoundSetPredicate: " + String.valueOf((Object)pred.op()));
            }
            throw new IllegalStateException("Unsupported bound predicate: " + pred.getClass().getName());
        }

        @Override
        public <T> R predicate(UnboundPredicate<T> pred) {
            throw new UnsupportedOperationException("Not a bound predicate: " + String.valueOf(pred));
        }
    }

    public static abstract class BoundExpressionVisitor<R>
    extends ExpressionVisitor<R> {
        public <T> R isNull(BoundReference<T> ref) {
            return null;
        }

        public <T> R notNull(BoundReference<T> ref) {
            return null;
        }

        public <T> R isNaN(BoundReference<T> ref) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not implement isNaN");
        }

        public <T> R notNaN(BoundReference<T> ref) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not implement notNaN");
        }

        public <T> R lt(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R ltEq(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R gt(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R gtEq(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R eq(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R notEq(BoundReference<T> ref, Literal<T> lit) {
            return null;
        }

        public <T> R in(BoundReference<T> ref, Set<T> literalSet) {
            throw new UnsupportedOperationException("In expression is not supported by the visitor");
        }

        public <T> R notIn(BoundReference<T> ref, Set<T> literalSet) {
            throw new UnsupportedOperationException("notIn expression is not supported by the visitor");
        }

        public <T> R startsWith(BoundReference<T> ref, Literal<T> lit) {
            throw new UnsupportedOperationException("startsWith expression is not supported by the visitor");
        }

        public <T> R notStartsWith(BoundReference<T> ref, Literal<T> lit) {
            throw new UnsupportedOperationException("notStartsWith expression is not supported by the visitor");
        }

        public <T> R handleNonReference(Bound<T> term) {
            throw new ValidationException("Visitor %s does not support non-reference: %s", this, term);
        }

        @Override
        public <T> R predicate(BoundPredicate<T> pred) {
            if (!(pred.term() instanceof BoundReference)) {
                return this.handleNonReference((Bound)pred.term());
            }
            if (pred.isLiteralPredicate()) {
                BoundLiteralPredicate<T> literalPred = pred.asLiteralPredicate();
                switch (pred.op()) {
                    case LT: {
                        return this.lt((BoundReference)pred.term(), literalPred.literal());
                    }
                    case LT_EQ: {
                        return this.ltEq((BoundReference)pred.term(), literalPred.literal());
                    }
                    case GT: {
                        return this.gt((BoundReference)pred.term(), literalPred.literal());
                    }
                    case GT_EQ: {
                        return this.gtEq((BoundReference)pred.term(), literalPred.literal());
                    }
                    case EQ: {
                        return this.eq((BoundReference)pred.term(), literalPred.literal());
                    }
                    case NOT_EQ: {
                        return this.notEq((BoundReference)pred.term(), literalPred.literal());
                    }
                    case STARTS_WITH: {
                        return this.startsWith((BoundReference)pred.term(), literalPred.literal());
                    }
                    case NOT_STARTS_WITH: {
                        return this.notStartsWith((BoundReference)pred.term(), literalPred.literal());
                    }
                }
                throw new IllegalStateException("Invalid operation for BoundLiteralPredicate: " + String.valueOf((Object)pred.op()));
            }
            if (pred.isUnaryPredicate()) {
                switch (pred.op()) {
                    case IS_NULL: {
                        return this.isNull((BoundReference)pred.term());
                    }
                    case NOT_NULL: {
                        return this.notNull((BoundReference)pred.term());
                    }
                    case IS_NAN: {
                        return this.isNaN((BoundReference)pred.term());
                    }
                    case NOT_NAN: {
                        return this.notNaN((BoundReference)pred.term());
                    }
                }
                throw new IllegalStateException("Invalid operation for BoundUnaryPredicate: " + String.valueOf((Object)pred.op()));
            }
            if (pred.isSetPredicate()) {
                switch (pred.op()) {
                    case IN: {
                        return this.in((BoundReference)pred.term(), pred.asSetPredicate().literalSet());
                    }
                    case NOT_IN: {
                        return this.notIn((BoundReference)pred.term(), pred.asSetPredicate().literalSet());
                    }
                }
                throw new IllegalStateException("Invalid operation for BoundSetPredicate: " + String.valueOf((Object)pred.op()));
            }
            throw new IllegalStateException("Unsupported bound predicate: " + pred.getClass().getName());
        }

        @Override
        public <T> R predicate(UnboundPredicate<T> pred) {
            throw new UnsupportedOperationException("Not a bound predicate: " + String.valueOf(pred));
        }
    }
}

