/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.ClusteredWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DataWriteResult;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileWriterFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFileFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.RollingDataWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import java.util.List;

public class ClusteredDataWriter<T>
extends ClusteredWriter<T, DataWriteResult> {
    private final FileWriterFactory<T> writerFactory;
    private final OutputFileFactory fileFactory;
    private final FileIO io;
    private final long targetFileSizeInBytes;
    private final List<DataFile> dataFiles;

    public ClusteredDataWriter(FileWriterFactory<T> writerFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSizeInBytes) {
        this.writerFactory = writerFactory;
        this.fileFactory = fileFactory;
        this.io = io;
        this.targetFileSizeInBytes = targetFileSizeInBytes;
        this.dataFiles = Lists.newArrayList();
    }

    @Override
    protected FileWriter<T, DataWriteResult> newWriter(PartitionSpec spec, StructLike partition) {
        return new RollingDataWriter<T>(this.writerFactory, this.fileFactory, this.io, this.targetFileSizeInBytes, spec, partition);
    }

    @Override
    protected void addResult(DataWriteResult result) {
        this.dataFiles.addAll(result.dataFiles());
    }

    @Override
    protected DataWriteResult aggregatedResult() {
        return new DataWriteResult(this.dataFiles);
    }
}

