/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class IOUtil {
    private static final int WRITE_CHUNK_SIZE = 8192;
    private static final double LN2 = Math.log(2.0);

    private IOUtil() {
    }

    public static void readFully(InputStream stream, byte[] bytes, int offset, int length) throws IOException {
        int bytesRead = IOUtil.readRemaining(stream, bytes, offset, length);
        if (bytesRead < length) {
            throw new EOFException("Reached the end of stream with " + (length - bytesRead) + " bytes left to read");
        }
    }

    public static void writeFully(OutputStream outputStream, ByteBuffer buffer) throws IOException {
        if (!buffer.hasRemaining()) {
            return;
        }
        byte[] chunk = new byte[8192];
        while (buffer.hasRemaining()) {
            int chunkSize = Math.min(chunk.length, buffer.remaining());
            buffer.get(chunk, 0, chunkSize);
            outputStream.write(chunk, 0, chunkSize);
        }
    }

    public static int readRemaining(InputStream stream, byte[] bytes, int offset, int length) throws IOException {
        int bytesRead;
        int pos = offset;
        int remaining = length;
        while (remaining > 0 && (bytesRead = stream.read(bytes, pos, remaining)) >= 0) {
            remaining -= bytesRead;
            pos += bytesRead;
        }
        return length - remaining;
    }

    public static int capacityFor(int size) {
        int nextPow2 = (int)Math.ceil(Math.log(size) / LN2);
        return Math.min(1 << nextPow2 + 1, 0x7FFFFFFE);
    }
}

