/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.io;

import com.dataiku.dss.shadelib.org.apache.iceberg.FileFormat;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionKey;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.BaseTaskWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileAppenderFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFileFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;

public abstract class PartitionedFanoutWriter<T>
extends BaseTaskWriter<T> {
    private final Map<PartitionKey, BaseTaskWriter.RollingFileWriter> writers = Maps.newHashMap();

    protected PartitionedFanoutWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<T> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize) {
        super(spec, format, appenderFactory, fileFactory, io, targetFileSize);
    }

    protected abstract PartitionKey partition(T var1);

    @Override
    public void write(T row) throws IOException {
        PartitionKey partitionKey = this.partition(row);
        BaseTaskWriter.RollingFileWriter writer = this.writers.get(partitionKey);
        if (writer == null) {
            PartitionKey copiedKey = partitionKey.copy();
            writer = new BaseTaskWriter.RollingFileWriter(copiedKey);
            this.writers.put(copiedKey, writer);
        }
        writer.write(row);
    }

    @Override
    public void close() throws IOException {
        if (!this.writers.isEmpty()) {
            for (PartitionKey key : this.writers.keySet()) {
                this.writers.get(key).close();
            }
            this.writers.clear();
        }
    }
}

