/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.parquet;

import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.RuntimeIOException;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableGroup;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterator;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.ParquetReader;
import java.io.IOException;
import java.util.NoSuchElementException;

public class ParquetIterable<T>
extends CloseableGroup
implements CloseableIterable<T> {
    private final ParquetReader.Builder<T> builder;

    ParquetIterable(ParquetReader.Builder<T> builder) {
        this.builder = builder;
    }

    @Override
    public CloseableIterator<T> iterator() {
        try {
            ParquetReader<T> reader = this.builder.build();
            this.addCloseable(reader);
            return new ParquetIterator<T>(reader);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to create Parquet reader", new Object[0]);
        }
    }

    private static class ParquetIterator<T>
    implements CloseableIterator<T> {
        private final ParquetReader<T> parquet;
        private boolean needsAdvance = false;
        private boolean hasNext = false;
        private T next;

        ParquetIterator(ParquetReader<T> parquet) {
            this.parquet = parquet;
            this.next = this.advance();
        }

        @Override
        public boolean hasNext() {
            if (this.needsAdvance) {
                this.next = this.advance();
            }
            return this.hasNext;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.needsAdvance = true;
            return this.next;
        }

        private T advance() {
            try {
                T nextRecord = this.parquet.read();
                this.needsAdvance = false;
                this.hasNext = nextRecord != null;
                return nextRecord;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported");
        }

        @Override
        public void close() throws IOException {
            this.parquet.close();
        }
    }
}

