/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.parquet;

import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.RuntimeIOException;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expressions;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableGroup;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterator;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.mapping.NameMapping;
import com.dataiku.dss.shadelib.org.apache.iceberg.parquet.ParquetValueReader;
import com.dataiku.dss.shadelib.org.apache.iceberg.parquet.ReadConf;
import com.dataiku.dss.shadelib.org.apache.parquet.ParquetReadOptions;
import com.dataiku.dss.shadelib.org.apache.parquet.column.page.PageReadStore;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.ParquetFileReader;
import com.dataiku.dss.shadelib.org.apache.parquet.io.ParquetDecodingException;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.MessageType;
import java.io.IOException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetReader<T>
extends CloseableGroup
implements CloseableIterable<T> {
    private final InputFile input;
    private final Schema expectedSchema;
    private final ParquetReadOptions options;
    private final Function<MessageType, ParquetValueReader<?>> readerFunc;
    private final Expression filter;
    private final boolean reuseContainers;
    private final boolean caseSensitive;
    private final NameMapping nameMapping;
    private ReadConf<T> conf = null;

    public ParquetReader(InputFile input, Schema expectedSchema, ParquetReadOptions options, Function<MessageType, ParquetValueReader<?>> readerFunc, NameMapping nameMapping, Expression filter, boolean reuseContainers, boolean caseSensitive) {
        this.input = input;
        this.expectedSchema = expectedSchema;
        this.options = options;
        this.readerFunc = readerFunc;
        this.filter = filter == Expressions.alwaysTrue() ? null : filter;
        this.reuseContainers = reuseContainers;
        this.caseSensitive = caseSensitive;
        this.nameMapping = nameMapping;
    }

    private ReadConf<T> init() {
        if (this.conf == null) {
            ReadConf readConf = new ReadConf(this.input, this.options, this.expectedSchema, this.filter, this.readerFunc, null, this.nameMapping, this.reuseContainers, this.caseSensitive, null);
            this.conf = readConf.copy();
            return readConf;
        }
        return this.conf;
    }

    @Override
    public CloseableIterator<T> iterator() {
        FileIterator<T> iter = new FileIterator<T>(this.init());
        this.addCloseable(iter);
        return iter;
    }

    private static class FileIterator<T>
    implements CloseableIterator<T> {
        private static final Logger LOG = LoggerFactory.getLogger(FileIterator.class);
        private final ParquetFileReader reader;
        private final boolean[] shouldSkip;
        private final ParquetValueReader<T> model;
        private final long totalValues;
        private final boolean reuseContainers;
        private int nextRowGroup = 0;
        private long nextRowGroupStart = 0L;
        private long valuesRead = 0L;
        private T last = null;

        FileIterator(ReadConf<T> conf) {
            this.reader = conf.reader();
            this.shouldSkip = conf.shouldSkip();
            this.model = conf.model();
            this.totalValues = conf.totalValues();
            this.reuseContainers = conf.reuseContainers();
        }

        @Override
        public boolean hasNext() {
            return this.valuesRead < this.totalValues;
        }

        @Override
        public T next() {
            try {
                if (this.valuesRead >= this.nextRowGroupStart) {
                    this.advance();
                }
                this.last = this.reuseContainers ? this.model.read(this.last) : this.model.read(null);
                ++this.valuesRead;
                return this.last;
            }
            catch (ParquetDecodingException e) {
                if (this.reader != null) {
                    LOG.error("Error decoding Parquet file {}", (Object)this.reader.getFile(), (Object)e);
                }
                throw e;
            }
        }

        private void advance() {
            PageReadStore pages;
            while (this.shouldSkip[this.nextRowGroup]) {
                ++this.nextRowGroup;
                this.reader.skipNextRowGroup();
            }
            try {
                pages = this.reader.readNextRowGroup();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            this.nextRowGroupStart += pages.getRowCount();
            ++this.nextRowGroup;
            this.model.setPageSource(pages);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

