/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.puffin;

import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedOutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.puffin.PuffinCompressionCodec;
import com.dataiku.dss.shadelib.org.apache.iceberg.puffin.PuffinReader;
import com.dataiku.dss.shadelib.org.apache.iceberg.puffin.PuffinWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import java.util.Map;

public final class Puffin {
    private Puffin() {
    }

    public static WriteBuilder write(OutputFile outputFile) {
        return new WriteBuilder(outputFile);
    }

    public static WriteBuilder write(EncryptedOutputFile outputFile) {
        return new WriteBuilder(outputFile.encryptingOutputFile());
    }

    public static ReadBuilder read(InputFile inputFile) {
        return new ReadBuilder(inputFile);
    }

    public static class WriteBuilder {
        private final OutputFile outputFile;
        private final Map<String, String> properties = Maps.newLinkedHashMap();
        private boolean compressFooter = false;
        private PuffinCompressionCodec defaultBlobCompression = PuffinCompressionCodec.NONE;

        private WriteBuilder(OutputFile outputFile) {
            this.outputFile = outputFile;
        }

        public WriteBuilder set(String property, String value) {
            this.properties.put(property, value);
            return this;
        }

        public WriteBuilder setAll(Map<String, String> props) {
            this.properties.putAll(props);
            return this;
        }

        public WriteBuilder createdBy(String applicationIdentifier) {
            this.properties.put("created-by", applicationIdentifier);
            return this;
        }

        public WriteBuilder compressFooter() {
            this.compressFooter = true;
            return this;
        }

        public WriteBuilder compressBlobs(PuffinCompressionCodec compression) {
            this.defaultBlobCompression = compression;
            return this;
        }

        public PuffinWriter build() {
            return new PuffinWriter(this.outputFile, this.properties, this.compressFooter, this.defaultBlobCompression);
        }
    }

    public static final class ReadBuilder {
        private final InputFile inputFile;
        private Long fileSize;
        private Long footerSize;

        private ReadBuilder(InputFile inputFile) {
            this.inputFile = inputFile;
        }

        public ReadBuilder withFileSize(long size) {
            this.fileSize = size;
            return this;
        }

        public ReadBuilder withFooterSize(long size) {
            this.footerSize = size;
            return this;
        }

        public PuffinReader build() {
            return new PuffinReader(this.inputFile, this.fileSize, this.footerSize);
        }
    }
}

