/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonProcessingException;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.ObjectMapper;
import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.dss.shadelib.org.apache.hc.core5.net.URIBuilder;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.RESTException;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.HTTPHeaders;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTObjectMapper;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.immutables.value.Value;

@Value.Style(redactedMask="****", depluralize=true)
@Value.Immutable
public interface HTTPRequest {
    @Nullable
    public URI baseUri();

    @Value.Lazy
    default public URI requestUri() {
        String fullPath;
        if (this.hasAbsolutePath()) {
            fullPath = this.path();
        } else {
            String baseUri = RESTUtil.stripTrailingSlash(this.baseUri().toString());
            fullPath = RESTUtil.stripTrailingSlash(String.format("%s/%s", baseUri, this.path()));
        }
        try {
            URIBuilder builder = new URIBuilder(fullPath);
            this.queryParameters().forEach(builder::addParameter);
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new RESTException("Failed to create request URI from base %s, params %s", fullPath, this.queryParameters());
        }
    }

    public HTTPMethod method();

    public String path();

    public Map<String, String> queryParameters();

    @Value.Default
    default public HTTPHeaders headers() {
        return HTTPHeaders.EMPTY;
    }

    @Nullable
    @Value.Redacted
    public Object body();

    @Nullable
    @Value.Lazy
    @Value.Redacted
    default public String encodedBody() {
        Object body = this.body();
        if (body instanceof Map) {
            return RESTUtil.encodeFormData((Map)body);
        }
        if (body != null) {
            try {
                return this.mapper().writeValueAsString(body);
            }
            catch (JsonProcessingException e) {
                throw new RESTException(e, "Failed to encode request body: %s", body);
            }
        }
        return null;
    }

    @Value.Default
    default public ObjectMapper mapper() {
        return RESTObjectMapper.mapper();
    }

    @Value.Check
    default public void check() {
        if (this.path().startsWith("/")) {
            throw new RESTException("Received a malformed path for a REST request: %s. Paths should not start with /", this.path());
        }
        if (this.baseUri() == null && !this.hasAbsolutePath()) {
            throw new RESTException("Received a request with a relative path and no base URI: %s", this.path());
        }
    }

    private boolean hasAbsolutePath() {
        return this.path().startsWith("https://") || this.path().startsWith("http://");
    }

    public static enum HTTPMethod {
        GET,
        HEAD,
        POST,
        DELETE;

    }
}

