/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth;

import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.ResourcePaths;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.ImmutableAuthConfig;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.OAuth2Util;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.PropertyUtil;
import java.util.Map;
import org.immutables.value.Value;

@Value.Style(redactedMask="****")
@Value.Immutable
public interface AuthConfig {
    @Nullable
    @Value.Redacted
    public String token();

    @Nullable
    public String tokenType();

    @Nullable
    @Value.Redacted
    public String credential();

    @Value.Default
    default public String scope() {
        return "catalog";
    }

    @Nullable
    @Value.Default
    default public Long expiresAtMillis() {
        return OAuth2Util.expiresAtMillis(this.token());
    }

    @Value.Default
    default public boolean keepRefreshed() {
        return true;
    }

    @Value.Default
    default public boolean exchangeEnabled() {
        return true;
    }

    @Nullable
    @Value.Default
    default public String oauth2ServerUri() {
        return ResourcePaths.tokens();
    }

    public Map<String, String> optionalOAuthParams();

    public static ImmutableAuthConfig.Builder builder() {
        return ImmutableAuthConfig.builder();
    }

    public static AuthConfig fromProperties(Map<String, String> properties) {
        return AuthConfig.builder().credential(properties.get("credential")).token(properties.get("token")).scope(properties.getOrDefault("scope", "catalog")).oauth2ServerUri(properties.getOrDefault("oauth2-server-uri", ResourcePaths.tokens())).optionalOAuthParams(OAuth2Util.buildOptionalParam(properties)).keepRefreshed(PropertyUtil.propertyAsBoolean(properties, "token-refresh-enabled", true)).exchangeEnabled(PropertyUtil.propertyAsBoolean(properties, "token-exchange-enabled", true)).expiresAtMillis(AuthConfig.expiresAtMillis(properties)).build();
    }

    private static Long expiresAtMillis(Map<String, String> props) {
        Long expiresAtMillis = null;
        if (props.containsKey("token")) {
            expiresAtMillis = OAuth2Util.expiresAtMillis(props.get("token"));
        }
        if (expiresAtMillis == null && props.containsKey("token-expires-in-ms")) {
            long millis = PropertyUtil.propertyAsLong(props, "token-expires-in-ms", 3600000L);
            expiresAtMillis = System.currentTimeMillis() + millis;
        }
        return expiresAtMillis;
    }
}

