/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.SchemaParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.CreateViewRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.ImmutableCreateViewRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewVersion;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewVersionParser;
import java.io.IOException;

public class CreateViewRequestParser {
    private static final String NAME = "name";
    private static final String LOCATION = "location";
    private static final String SCHEMA = "schema";
    private static final String VIEW_VERSION = "view-version";
    private static final String PROPERTIES = "properties";

    private CreateViewRequestParser() {
    }

    public static String toJson(CreateViewRequest request) {
        return CreateViewRequestParser.toJson(request, false);
    }

    public static String toJson(CreateViewRequest request, boolean pretty) {
        return JsonUtil.generate(gen -> CreateViewRequestParser.toJson(request, gen), pretty);
    }

    public static void toJson(CreateViewRequest request, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument(null != request, "Invalid create view request: null");
        gen.writeStartObject();
        gen.writeStringField(NAME, request.name());
        if (null != request.location()) {
            gen.writeStringField(LOCATION, request.location());
        }
        gen.writeFieldName(VIEW_VERSION);
        ViewVersionParser.toJson(request.viewVersion(), gen);
        gen.writeFieldName(SCHEMA);
        SchemaParser.toJson(request.schema(), gen);
        if (!request.properties().isEmpty()) {
            JsonUtil.writeStringMap(PROPERTIES, request.properties(), gen);
        }
        gen.writeEndObject();
    }

    public static CreateViewRequest fromJson(String json) {
        return JsonUtil.parse(json, CreateViewRequestParser::fromJson);
    }

    public static CreateViewRequest fromJson(JsonNode json) {
        Preconditions.checkArgument(null != json, "Cannot parse create view request from null object");
        String name = JsonUtil.getString(NAME, json);
        String location = JsonUtil.getStringOrNull(LOCATION, json);
        ViewVersion viewVersion = ViewVersionParser.fromJson(JsonUtil.get(VIEW_VERSION, json));
        Schema schema = SchemaParser.fromJson(JsonUtil.get(SCHEMA, json));
        ImmutableCreateViewRequest.Builder builder = ImmutableCreateViewRequest.builder().name(name).location(location).viewVersion(viewVersion).schema(schema);
        if (json.has(PROPERTIES)) {
            builder.properties(JsonUtil.getStringMap(PROPERTIES, json));
        }
        return builder.build();
    }
}

