/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataUpdate;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataUpdateParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateRequirement;
import com.dataiku.dss.shadelib.org.apache.iceberg.UpdateRequirementParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifier;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifierParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests.UpdateTableRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import java.io.IOException;
import java.util.ArrayList;

public class UpdateTableRequestParser {
    private static final String IDENTIFIER = "identifier";
    private static final String REQUIREMENTS = "requirements";
    private static final String UPDATES = "updates";

    private UpdateTableRequestParser() {
    }

    public static String toJson(UpdateTableRequest request) {
        return UpdateTableRequestParser.toJson(request, false);
    }

    public static String toJson(UpdateTableRequest request, boolean pretty) {
        return JsonUtil.generate(gen -> UpdateTableRequestParser.toJson(request, gen), pretty);
    }

    public static void toJson(UpdateTableRequest request, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument(null != request, "Invalid update table request: null");
        gen.writeStartObject();
        if (null != request.identifier()) {
            gen.writeFieldName(IDENTIFIER);
            TableIdentifierParser.toJson(request.identifier(), gen);
        }
        gen.writeArrayFieldStart(REQUIREMENTS);
        for (UpdateRequirement updateRequirement : request.requirements()) {
            UpdateRequirementParser.toJson(updateRequirement, gen);
        }
        gen.writeEndArray();
        gen.writeArrayFieldStart(UPDATES);
        for (MetadataUpdate metadataUpdate : request.updates()) {
            MetadataUpdateParser.toJson(metadataUpdate, gen);
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }

    public static UpdateTableRequest fromJson(String json) {
        return JsonUtil.parse(json, UpdateTableRequestParser::fromJson);
    }

    public static UpdateTableRequest fromJson(JsonNode json) {
        Preconditions.checkArgument(null != json, "Cannot parse update table request from null object");
        TableIdentifier identifier = null;
        ArrayList<UpdateRequirement> requirements = Lists.newArrayList();
        ArrayList<MetadataUpdate> updates = Lists.newArrayList();
        if (json.hasNonNull(IDENTIFIER)) {
            identifier = TableIdentifierParser.fromJson(JsonUtil.get(IDENTIFIER, json));
        }
        if (json.hasNonNull(REQUIREMENTS)) {
            JsonNode requirementsNode = JsonUtil.get(REQUIREMENTS, json);
            Preconditions.checkArgument(requirementsNode.isArray(), "Cannot parse requirements from non-array: %s", (Object)requirementsNode);
            requirementsNode.forEach(req -> requirements.add(UpdateRequirementParser.fromJson(req)));
        }
        if (json.hasNonNull(UPDATES)) {
            JsonNode updatesNode = JsonUtil.get(UPDATES, json);
            Preconditions.checkArgument(updatesNode.isArray(), "Cannot parse metadata updates from non-array: %s", (Object)updatesNode);
            updatesNode.forEach(update -> updates.add(MetadataUpdateParser.fromJson(update)));
        }
        return UpdateTableRequest.create(identifier, requirements, updates);
    }
}

