/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.ImmutableLoadViewResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.LoadViewResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewMetadataParser;
import java.io.IOException;

public class LoadViewResponseParser {
    private static final String METADATA_LOCATION = "metadata-location";
    private static final String METADATA = "metadata";
    private static final String CONFIG = "config";

    private LoadViewResponseParser() {
    }

    public static String toJson(LoadViewResponse response) {
        return LoadViewResponseParser.toJson(response, false);
    }

    public static String toJson(LoadViewResponse response, boolean pretty) {
        return JsonUtil.generate(gen -> LoadViewResponseParser.toJson(response, gen), pretty);
    }

    public static void toJson(LoadViewResponse response, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument(null != response, "Invalid load view response: null");
        gen.writeStartObject();
        gen.writeStringField(METADATA_LOCATION, response.metadataLocation());
        gen.writeFieldName(METADATA);
        ViewMetadataParser.toJson(response.metadata(), gen);
        if (!response.config().isEmpty()) {
            JsonUtil.writeStringMap(CONFIG, response.config(), gen);
        }
        gen.writeEndObject();
    }

    public static LoadViewResponse fromJson(String json) {
        return JsonUtil.parse(json, LoadViewResponseParser::fromJson);
    }

    public static LoadViewResponse fromJson(JsonNode json) {
        Preconditions.checkArgument(null != json, "Cannot parse load view response from null object");
        String metadataLocation = JsonUtil.getString(METADATA_LOCATION, json);
        ViewMetadata metadata = ViewMetadataParser.fromJson(JsonUtil.get(METADATA, json));
        if (null == metadata.metadataFileLocation()) {
            metadata = ViewMetadata.buildFrom(metadata).setMetadataLocation(metadataLocation).build();
        }
        ImmutableLoadViewResponse.Builder builder = ImmutableLoadViewResponse.builder().metadataLocation(metadataLocation).metadata(metadata);
        if (json.has(CONFIG)) {
            builder.config(JsonUtil.getStringMap(CONFIG, json));
        }
        return builder.build();
    }
}

