/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.types;

import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expressions;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Literal;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Joiner;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.EdgeAlgorithm;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.PrimitiveLikeHolder;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Types {
    private static final ImmutableMap<String, Type> TYPES = ImmutableMap.builder().put(BooleanType.get().toString(), BooleanType.get()).put(IntegerType.get().toString(), (BooleanType)((Object)IntegerType.get())).put(LongType.get().toString(), (BooleanType)((Object)LongType.get())).put(FloatType.get().toString(), (BooleanType)((Object)FloatType.get())).put(DoubleType.get().toString(), (BooleanType)((Object)DoubleType.get())).put(DateType.get().toString(), (BooleanType)((Object)DateType.get())).put(TimeType.get().toString(), (BooleanType)((Object)TimeType.get())).put(TimestampType.withZone().toString(), (BooleanType)((Object)TimestampType.withZone())).put(TimestampType.withoutZone().toString(), (BooleanType)((Object)TimestampType.withoutZone())).put(TimestampNanoType.withZone().toString(), (BooleanType)((Object)TimestampNanoType.withZone())).put(TimestampNanoType.withoutZone().toString(), (BooleanType)((Object)TimestampNanoType.withoutZone())).put(StringType.get().toString(), (BooleanType)((Object)StringType.get())).put(UUIDType.get().toString(), (BooleanType)((Object)UUIDType.get())).put(BinaryType.get().toString(), (BooleanType)((Object)BinaryType.get())).put(UnknownType.get().toString(), (BooleanType)((Object)UnknownType.get())).put(VariantType.get().toString(), (BooleanType)((Object)VariantType.get())).put(GeometryType.crs84().toString(), (BooleanType)((Object)GeometryType.crs84())).put(GeographyType.crs84().toString(), (BooleanType)((Object)GeographyType.crs84())).buildOrThrow();
    private static final Pattern FIXED = Pattern.compile("fixed\\[\\s*(\\d+)\\s*\\]");
    private static final Pattern GEOMETRY_PARAMETERS = Pattern.compile("geometry\\s*(?:\\(\\s*([^)]*?)\\s*\\))?", 2);
    private static final Pattern GEOGRAPHY_PARAMETERS = Pattern.compile("geography\\s*(?:\\(\\s*([^,]*?)\\s*(?:,\\s*(\\w*)\\s*)?\\))?", 2);
    private static final Pattern DECIMAL = Pattern.compile("decimal\\(\\s*(\\d+)\\s*,\\s*(\\d+)\\s*\\)");

    private Types() {
    }

    public static Type fromTypeName(String typeString) {
        String lowerTypeString = typeString.toLowerCase(Locale.ROOT);
        if (TYPES.containsKey(lowerTypeString)) {
            return TYPES.get(lowerTypeString);
        }
        Matcher geometry = GEOMETRY_PARAMETERS.matcher(typeString);
        if (geometry.matches()) {
            String crs = geometry.group(1);
            Preconditions.checkArgument(!crs.contains(","), "Invalid CRS: %s", (Object)crs);
            return GeometryType.of(crs);
        }
        Matcher geography = GEOGRAPHY_PARAMETERS.matcher(typeString);
        if (geography.matches()) {
            String crs = geography.group(1);
            String algorithmName = geography.group(2);
            EdgeAlgorithm algorithm = algorithmName == null ? null : EdgeAlgorithm.fromName(algorithmName);
            return GeographyType.of(crs, algorithm);
        }
        Matcher fixed = FIXED.matcher(lowerTypeString);
        if (fixed.matches()) {
            return FixedType.ofLength(Integer.parseInt(fixed.group(1)));
        }
        Matcher decimal = DECIMAL.matcher(lowerTypeString);
        if (decimal.matches()) {
            return DecimalType.of(Integer.parseInt(decimal.group(1)), Integer.parseInt(decimal.group(2)));
        }
        throw new IllegalArgumentException("Cannot parse type string to primitive: " + typeString);
    }

    public static Type.PrimitiveType fromPrimitiveString(String typeString) {
        Type type = Types.fromTypeName(typeString);
        if (type.isPrimitiveType()) {
            return type.asPrimitiveType();
        }
        throw new IllegalArgumentException("Cannot parse type string: variant is not a primitive type");
    }

    public static class GeometryType
    extends Type.PrimitiveType {
        public static final String DEFAULT_CRS = "OGC:CRS84";
        private final String crs;

        public static GeometryType crs84() {
            return new GeometryType();
        }

        public static GeometryType of(String crs) {
            return new GeometryType(crs);
        }

        private GeometryType() {
            this.crs = null;
        }

        private GeometryType(String crs) {
            Preconditions.checkArgument(crs == null || !crs.isEmpty(), "Invalid CRS: (empty string)");
            this.crs = DEFAULT_CRS.equalsIgnoreCase(crs) ? null : crs;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.GEOMETRY;
        }

        public String crs() {
            return this.crs;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GeometryType)) {
                return false;
            }
            GeometryType that = (GeometryType)o;
            return Objects.equals(this.crs, that.crs);
        }

        @Override
        public int hashCode() {
            return Objects.hash(GeometryType.class, this.crs);
        }

        public String toString() {
            if (this.crs == null) {
                return "geometry";
            }
            return String.format("geometry(%s)", this.crs);
        }
    }

    public static class GeographyType
    extends Type.PrimitiveType {
        public static final String DEFAULT_CRS = "OGC:CRS84";
        private final String crs;
        private final EdgeAlgorithm algorithm;

        public static GeographyType crs84() {
            return new GeographyType();
        }

        public static GeographyType of(String crs) {
            return new GeographyType(crs, null);
        }

        public static GeographyType of(String crs, EdgeAlgorithm algorithm) {
            return new GeographyType(crs, algorithm);
        }

        private GeographyType() {
            this.crs = null;
            this.algorithm = null;
        }

        private GeographyType(String crs, EdgeAlgorithm algorithm) {
            Preconditions.checkArgument(crs == null || !crs.isEmpty(), "Invalid CRS: (empty string)");
            this.crs = DEFAULT_CRS.equalsIgnoreCase(crs) ? null : crs;
            this.algorithm = algorithm;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.GEOGRAPHY;
        }

        public String crs() {
            return this.crs;
        }

        public EdgeAlgorithm algorithm() {
            return this.algorithm;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GeographyType)) {
                return false;
            }
            GeographyType that = (GeographyType)o;
            return Objects.equals(this.crs, that.crs) && Objects.equals((Object)this.algorithm, (Object)that.algorithm);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{GeographyType.class, this.crs, this.algorithm});
        }

        public String toString() {
            if (this.algorithm != null) {
                return String.format("geography(%s, %s)", new Object[]{this.crs != null ? this.crs : DEFAULT_CRS, this.algorithm});
            }
            if (this.crs != null) {
                return String.format("geography(%s)", this.crs);
            }
            return "geography";
        }
    }

    public static class FixedType
    extends Type.PrimitiveType {
        private final int length;

        public static FixedType ofLength(int length) {
            return new FixedType(length);
        }

        private FixedType(int length) {
            this.length = length;
        }

        public int length() {
            return this.length;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.FIXED;
        }

        public String toString() {
            return String.format(Locale.ROOT, "fixed[%d]", this.length);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FixedType)) {
                return false;
            }
            FixedType fixedType = (FixedType)o;
            return this.length == fixedType.length;
        }

        @Override
        public int hashCode() {
            return Objects.hash(FixedType.class, this.length);
        }
    }

    public static class DecimalType
    extends Type.PrimitiveType {
        private final int scale;
        private final int precision;

        public static DecimalType of(int precision, int scale) {
            return new DecimalType(precision, scale);
        }

        private DecimalType(int precision, int scale) {
            Preconditions.checkArgument(precision <= 38, "Decimals with precision larger than 38 are not supported: %s", precision);
            this.scale = scale;
            this.precision = precision;
        }

        public int scale() {
            return this.scale;
        }

        public int precision() {
            return this.precision;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.DECIMAL;
        }

        public String toString() {
            return String.format(Locale.ROOT, "decimal(%d, %d)", this.precision, this.scale);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DecimalType)) {
                return false;
            }
            DecimalType that = (DecimalType)o;
            if (this.scale != that.scale) {
                return false;
            }
            return this.precision == that.precision;
        }

        @Override
        public int hashCode() {
            return Objects.hash(DecimalType.class, this.scale, this.precision);
        }
    }

    public static class BooleanType
    extends Type.PrimitiveType {
        private static final BooleanType INSTANCE = new BooleanType();

        public static BooleanType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.BOOLEAN;
        }

        public String toString() {
            return "boolean";
        }
    }

    public static class IntegerType
    extends Type.PrimitiveType {
        private static final IntegerType INSTANCE = new IntegerType();

        public static IntegerType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.INTEGER;
        }

        public String toString() {
            return "int";
        }
    }

    public static class LongType
    extends Type.PrimitiveType {
        private static final LongType INSTANCE = new LongType();

        public static LongType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.LONG;
        }

        public String toString() {
            return "long";
        }
    }

    public static class FloatType
    extends Type.PrimitiveType {
        private static final FloatType INSTANCE = new FloatType();

        public static FloatType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.FLOAT;
        }

        public String toString() {
            return "float";
        }
    }

    public static class DoubleType
    extends Type.PrimitiveType {
        private static final DoubleType INSTANCE = new DoubleType();

        public static DoubleType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.DOUBLE;
        }

        public String toString() {
            return "double";
        }
    }

    public static class DateType
    extends Type.PrimitiveType {
        private static final DateType INSTANCE = new DateType();

        public static DateType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.DATE;
        }

        public String toString() {
            return "date";
        }
    }

    public static class TimeType
    extends Type.PrimitiveType {
        private static final TimeType INSTANCE = new TimeType();

        public static TimeType get() {
            return INSTANCE;
        }

        private TimeType() {
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.TIME;
        }

        public String toString() {
            return "time";
        }
    }

    public static class TimestampType
    extends Type.PrimitiveType {
        private static final TimestampType INSTANCE_WITH_ZONE = new TimestampType(true);
        private static final TimestampType INSTANCE_WITHOUT_ZONE = new TimestampType(false);
        private final boolean adjustToUTC;

        public static TimestampType withZone() {
            return INSTANCE_WITH_ZONE;
        }

        public static TimestampType withoutZone() {
            return INSTANCE_WITHOUT_ZONE;
        }

        private TimestampType(boolean adjustToUTC) {
            this.adjustToUTC = adjustToUTC;
        }

        public boolean shouldAdjustToUTC() {
            return this.adjustToUTC;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.TIMESTAMP;
        }

        public String toString() {
            if (this.shouldAdjustToUTC()) {
                return "timestamptz";
            }
            return "timestamp";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TimestampType)) {
                return false;
            }
            TimestampType timestampType = (TimestampType)o;
            return this.adjustToUTC == timestampType.adjustToUTC;
        }

        @Override
        public int hashCode() {
            return Objects.hash(TimestampType.class, this.adjustToUTC);
        }
    }

    public static class TimestampNanoType
    extends Type.PrimitiveType {
        private static final TimestampNanoType INSTANCE_WITH_ZONE = new TimestampNanoType(true);
        private static final TimestampNanoType INSTANCE_WITHOUT_ZONE = new TimestampNanoType(false);
        private final boolean adjustToUTC;

        public static TimestampNanoType withZone() {
            return INSTANCE_WITH_ZONE;
        }

        public static TimestampNanoType withoutZone() {
            return INSTANCE_WITHOUT_ZONE;
        }

        private TimestampNanoType(boolean adjustToUTC) {
            this.adjustToUTC = adjustToUTC;
        }

        public boolean shouldAdjustToUTC() {
            return this.adjustToUTC;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.TIMESTAMP_NANO;
        }

        public String toString() {
            if (this.shouldAdjustToUTC()) {
                return "timestamptz_ns";
            }
            return "timestamp_ns";
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TimestampNanoType)) {
                return false;
            }
            return this.adjustToUTC == ((TimestampNanoType)other).adjustToUTC;
        }

        @Override
        public int hashCode() {
            return Objects.hash(TimestampNanoType.class, this.adjustToUTC);
        }
    }

    public static class StringType
    extends Type.PrimitiveType {
        private static final StringType INSTANCE = new StringType();

        public static StringType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.STRING;
        }

        public String toString() {
            return "string";
        }
    }

    public static class UUIDType
    extends Type.PrimitiveType {
        private static final UUIDType INSTANCE = new UUIDType();

        public static UUIDType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.UUID;
        }

        public String toString() {
            return "uuid";
        }
    }

    public static class BinaryType
    extends Type.PrimitiveType {
        private static final BinaryType INSTANCE = new BinaryType();

        public static BinaryType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.BINARY;
        }

        public String toString() {
            return "binary";
        }
    }

    public static class UnknownType
    extends Type.PrimitiveType {
        private static final UnknownType INSTANCE = new UnknownType();

        public static UnknownType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.UNKNOWN;
        }

        public String toString() {
            return "unknown";
        }
    }

    public static class VariantType
    implements Type {
        private static final VariantType INSTANCE = new VariantType();

        public static VariantType get() {
            return INSTANCE;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.VARIANT;
        }

        public String toString() {
            return "variant";
        }

        @Override
        public boolean isVariantType() {
            return true;
        }

        @Override
        public VariantType asVariantType() {
            return this;
        }

        Object writeReplace() throws ObjectStreamException {
            return new PrimitiveLikeHolder(this.toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VariantType)) {
                return false;
            }
            VariantType that = (VariantType)o;
            return this.typeId() == that.typeId();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{VariantType.class, this.typeId()});
        }
    }

    public static class MapType
    extends Type.NestedType {
        private final NestedField keyField;
        private final NestedField valueField;
        private transient List<NestedField> fields = null;

        public static MapType ofOptional(int keyId, int valueId, Type keyType, Type valueType) {
            Preconditions.checkNotNull(valueType, "Value type cannot be null");
            return new MapType(NestedField.required(keyId, "key", keyType), NestedField.optional(valueId, "value", valueType));
        }

        public static MapType ofRequired(int keyId, int valueId, Type keyType, Type valueType) {
            Preconditions.checkNotNull(valueType, "Value type cannot be null");
            return new MapType(NestedField.required(keyId, "key", keyType), NestedField.required(valueId, "value", valueType));
        }

        private MapType(NestedField keyField, NestedField valueField) {
            this.keyField = keyField;
            this.valueField = valueField;
        }

        public Type keyType() {
            return this.keyField.type();
        }

        public Type valueType() {
            return this.valueField.type();
        }

        @Override
        public Type fieldType(String name) {
            if ("key".equals(name)) {
                return this.keyField.type();
            }
            if ("value".equals(name)) {
                return this.valueField.type();
            }
            return null;
        }

        @Override
        public NestedField field(int id) {
            if (this.keyField.fieldId() == id) {
                return this.keyField;
            }
            if (this.valueField.fieldId() == id) {
                return this.valueField;
            }
            return null;
        }

        @Override
        public List<NestedField> fields() {
            return this.lazyFieldList();
        }

        public int keyId() {
            return this.keyField.fieldId();
        }

        public int valueId() {
            return this.valueField.fieldId();
        }

        public boolean isValueRequired() {
            return !this.valueField.isOptional;
        }

        public boolean isValueOptional() {
            return this.valueField.isOptional;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.MAP;
        }

        @Override
        public boolean isMapType() {
            return true;
        }

        @Override
        public MapType asMapType() {
            return this;
        }

        public String toString() {
            return String.format("map<%s, %s>", this.keyField.type(), this.valueField.type());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MapType)) {
                return false;
            }
            MapType mapType = (MapType)o;
            if (!this.keyField.equals(mapType.keyField)) {
                return false;
            }
            return this.valueField.equals(mapType.valueField);
        }

        public int hashCode() {
            return Objects.hash(MapType.class, this.keyField, this.valueField);
        }

        private List<NestedField> lazyFieldList() {
            if (this.fields == null) {
                this.fields = ImmutableList.of(this.keyField, this.valueField);
            }
            return this.fields;
        }
    }

    public static class ListType
    extends Type.NestedType {
        private final NestedField elementField;
        private transient List<NestedField> fields = null;

        public static ListType ofOptional(int elementId, Type elementType) {
            Preconditions.checkNotNull(elementType, "Element type cannot be null");
            return new ListType(NestedField.optional(elementId, "element", elementType));
        }

        public static ListType ofRequired(int elementId, Type elementType) {
            Preconditions.checkNotNull(elementType, "Element type cannot be null");
            return new ListType(NestedField.required(elementId, "element", elementType));
        }

        private ListType(NestedField elementField) {
            this.elementField = elementField;
        }

        public Type elementType() {
            return this.elementField.type();
        }

        @Override
        public Type fieldType(String name) {
            if ("element".equals(name)) {
                return this.elementType();
            }
            return null;
        }

        @Override
        public NestedField field(int id) {
            if (this.elementField.fieldId() == id) {
                return this.elementField;
            }
            return null;
        }

        @Override
        public List<NestedField> fields() {
            return this.lazyFieldList();
        }

        public int elementId() {
            return this.elementField.fieldId();
        }

        public boolean isElementRequired() {
            return !this.elementField.isOptional;
        }

        public boolean isElementOptional() {
            return this.elementField.isOptional;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.LIST;
        }

        @Override
        public boolean isListType() {
            return true;
        }

        @Override
        public ListType asListType() {
            return this;
        }

        public String toString() {
            return String.format("list<%s>", this.elementField.type());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ListType)) {
                return false;
            }
            ListType listType = (ListType)o;
            return this.elementField.equals(listType.elementField);
        }

        public int hashCode() {
            return Objects.hash(ListType.class, this.elementField);
        }

        private List<NestedField> lazyFieldList() {
            if (this.fields == null) {
                this.fields = ImmutableList.of(this.elementField);
            }
            return this.fields;
        }
    }

    public static class StructType
    extends Type.NestedType {
        private static final Joiner FIELD_SEP = Joiner.on(", ");
        private final NestedField[] fields;
        private transient Schema schema = null;
        private transient List<NestedField> fieldList = null;
        private transient Map<String, NestedField> fieldsByName = null;
        private transient Map<String, NestedField> fieldsByLowerCaseName = null;
        private transient Map<Integer, NestedField> fieldsById = null;

        public static StructType of(NestedField ... fields) {
            return StructType.of(Arrays.asList(fields));
        }

        public static StructType of(List<NestedField> fields) {
            return new StructType(fields);
        }

        private StructType(List<NestedField> fields) {
            Preconditions.checkNotNull(fields, "Field list cannot be null");
            this.fields = new NestedField[fields.size()];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = fields.get(i);
            }
        }

        @Override
        public List<NestedField> fields() {
            return this.lazyFieldList();
        }

        public NestedField field(String name) {
            return this.lazyFieldsByName().get(name);
        }

        @Override
        public NestedField field(int id) {
            return this.lazyFieldsById().get(id);
        }

        public NestedField caseInsensitiveField(String name) {
            return this.lazyFieldsByLowerCaseName().get(name.toLowerCase(Locale.ROOT));
        }

        @Override
        public Type fieldType(String name) {
            NestedField field = this.field(name);
            if (field != null) {
                return field.type();
            }
            return null;
        }

        @Override
        public Type.TypeID typeId() {
            return Type.TypeID.STRUCT;
        }

        @Override
        public boolean isStructType() {
            return true;
        }

        @Override
        public StructType asStructType() {
            return this;
        }

        public Schema asSchema() {
            if (this.schema == null) {
                this.schema = new Schema(Arrays.asList(this.fields));
            }
            return this.schema;
        }

        public String toString() {
            return String.format("struct<%s>", FIELD_SEP.join(this.fields));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StructType)) {
                return false;
            }
            StructType that = (StructType)o;
            return Arrays.equals(this.fields, that.fields);
        }

        public int hashCode() {
            return Objects.hash(NestedField.class, Arrays.hashCode(this.fields));
        }

        private List<NestedField> lazyFieldList() {
            if (this.fieldList == null) {
                this.fieldList = ImmutableList.copyOf(this.fields);
            }
            return this.fieldList;
        }

        private Map<String, NestedField> lazyFieldsByName() {
            if (this.fieldsByName == null) {
                ImmutableMap.Builder<String, NestedField> byNameBuilder = ImmutableMap.builder();
                for (NestedField field : this.fields) {
                    byNameBuilder.put(field.name(), field);
                }
                this.fieldsByName = byNameBuilder.build();
            }
            return this.fieldsByName;
        }

        private Map<String, NestedField> lazyFieldsByLowerCaseName() {
            if (this.fieldsByLowerCaseName == null) {
                ImmutableMap.Builder<String, NestedField> byLowerCaseNameBuilder = ImmutableMap.builder();
                for (NestedField field : this.fields) {
                    byLowerCaseNameBuilder.put(field.name().toLowerCase(Locale.ROOT), field);
                }
                this.fieldsByLowerCaseName = byLowerCaseNameBuilder.build();
            }
            return this.fieldsByLowerCaseName;
        }

        private Map<Integer, NestedField> lazyFieldsById() {
            if (this.fieldsById == null) {
                ImmutableMap.Builder<Integer, NestedField> byIdBuilder = ImmutableMap.builder();
                for (NestedField field : this.fields) {
                    byIdBuilder.put(field.fieldId(), field);
                }
                this.fieldsById = byIdBuilder.build();
            }
            return this.fieldsById;
        }
    }

    public static class NestedField
    implements Serializable {
        private final boolean isOptional;
        private final int id;
        private final String name;
        private final Type type;
        private final String doc;
        private final Literal<?> initialDefault;
        private final Literal<?> writeDefault;

        public static NestedField optional(int id, String name, Type type) {
            return new NestedField(true, id, name, type, null, null, null);
        }

        public static NestedField optional(int id, String name, Type type, String doc) {
            return new NestedField(true, id, name, type, doc, null, null);
        }

        public static NestedField required(int id, String name, Type type) {
            return new NestedField(false, id, name, type, null, null, null);
        }

        public static NestedField required(int id, String name, Type type, String doc) {
            return new NestedField(false, id, name, type, doc, null, null);
        }

        @Deprecated
        public static NestedField of(int id, boolean isOptional, String name, Type type) {
            return new NestedField(isOptional, id, name, type, null, null, null);
        }

        @Deprecated
        public static NestedField of(int id, boolean isOptional, String name, Type type, String doc) {
            return new NestedField(isOptional, id, name, type, doc, null, null);
        }

        public static Builder from(NestedField field) {
            return new Builder(field);
        }

        public static Builder required(String name) {
            return new Builder(false, name);
        }

        public static Builder optional(String name) {
            return new Builder(true, name);
        }

        public static Builder builder() {
            return new Builder();
        }

        private NestedField(boolean isOptional, int id, String name, Type type, String doc, Literal<?> initialDefault, Literal<?> writeDefault) {
            Preconditions.checkNotNull(name, "Name cannot be null");
            Preconditions.checkNotNull(type, "Type cannot be null");
            Preconditions.checkArgument(isOptional || !type.equals(UnknownType.get()), "Cannot create required field with unknown type: %s", (Object)name);
            this.isOptional = isOptional;
            this.id = id;
            this.name = name;
            this.type = type;
            this.doc = doc;
            this.initialDefault = NestedField.castDefault(initialDefault, type);
            this.writeDefault = NestedField.castDefault(writeDefault, type);
        }

        private static Literal<?> castDefault(Literal<?> defaultValue, Type type) {
            if (type.isNestedType() && defaultValue != null) {
                throw new IllegalArgumentException(String.format("Invalid default value for %s: %s (must be null)", type, defaultValue));
            }
            if (defaultValue != null) {
                Literal typedDefault = defaultValue.to(type);
                Preconditions.checkArgument(typedDefault != null, "Cannot cast default value to %s: %s", (Object)type, defaultValue);
                return typedDefault;
            }
            return null;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        public NestedField asOptional() {
            if (this.isOptional) {
                return this;
            }
            return new NestedField(true, this.id, this.name, this.type, this.doc, this.initialDefault, this.writeDefault);
        }

        public boolean isRequired() {
            return !this.isOptional;
        }

        public NestedField asRequired() {
            if (!this.isOptional) {
                return this;
            }
            return new NestedField(false, this.id, this.name, this.type, this.doc, this.initialDefault, this.writeDefault);
        }

        @Deprecated
        public NestedField withFieldId(int newId) {
            return new NestedField(this.isOptional, newId, this.name, this.type, this.doc, this.initialDefault, this.writeDefault);
        }

        public int fieldId() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public Type type() {
            return this.type;
        }

        public String doc() {
            return this.doc;
        }

        public Literal<?> initialDefaultLiteral() {
            return this.initialDefault;
        }

        public Object initialDefault() {
            return this.initialDefault != null ? this.initialDefault.value() : null;
        }

        public Literal<?> writeDefaultLiteral() {
            return this.writeDefault;
        }

        public Object writeDefault() {
            return this.writeDefault != null ? this.writeDefault.value() : null;
        }

        public String toString() {
            return String.format(Locale.ROOT, "%d: %s: %s %s", this.id, this.name, this.isOptional ? "optional" : "required", this.type) + (String)(this.doc != null ? " (" + this.doc + ")" : "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NestedField)) {
                return false;
            }
            NestedField that = (NestedField)o;
            if (this.isOptional != that.isOptional) {
                return false;
            }
            if (this.id != that.id) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
            if (!Objects.equals(this.doc, that.doc)) {
                return false;
            }
            if (!this.type.equals(that.type)) {
                return false;
            }
            if (!Objects.equals(this.initialDefault, that.initialDefault)) {
                return false;
            }
            return Objects.equals(this.writeDefault, that.writeDefault);
        }

        public int hashCode() {
            return Objects.hash(NestedField.class, this.id, this.isOptional, this.name, this.type);
        }

        public static class Builder {
            private boolean isOptional = true;
            private String name = null;
            private Integer id = null;
            private Type type = null;
            private String doc = null;
            private Literal<?> initialDefault = null;
            private Literal<?> writeDefault = null;

            private Builder() {
            }

            private Builder(boolean isFieldOptional, String fieldName) {
                this.isOptional = isFieldOptional;
                this.name = fieldName;
            }

            private Builder(NestedField toCopy) {
                this.isOptional = toCopy.isOptional;
                this.name = toCopy.name;
                this.id = toCopy.id;
                this.type = toCopy.type;
                this.doc = toCopy.doc;
                this.initialDefault = toCopy.initialDefault;
                this.writeDefault = toCopy.writeDefault;
            }

            public Builder asRequired() {
                this.isOptional = false;
                return this;
            }

            public Builder asOptional() {
                this.isOptional = true;
                return this;
            }

            public Builder isOptional(boolean fieldIsOptional) {
                this.isOptional = fieldIsOptional;
                return this;
            }

            public Builder withName(String fieldName) {
                this.name = fieldName;
                return this;
            }

            public Builder withId(int fieldId) {
                this.id = fieldId;
                return this;
            }

            public Builder ofType(Type fieldType) {
                this.type = fieldType;
                return this;
            }

            public Builder withDoc(String fieldDoc) {
                this.doc = fieldDoc;
                return this;
            }

            @Deprecated
            public Builder withInitialDefault(Object fieldInitialDefault) {
                return this.withInitialDefault(Expressions.lit(fieldInitialDefault));
            }

            public Builder withInitialDefault(Literal<?> fieldInitialDefault) {
                this.initialDefault = fieldInitialDefault;
                return this;
            }

            @Deprecated
            public Builder withWriteDefault(Object fieldWriteDefault) {
                return this.withWriteDefault(Expressions.lit(fieldWriteDefault));
            }

            public Builder withWriteDefault(Literal<?> fieldWriteDefault) {
                this.writeDefault = fieldWriteDefault;
                return this;
            }

            public NestedField build() {
                Preconditions.checkNotNull(this.id, "Id cannot be null");
                return new NestedField(this.isOptional, this.id, this.name, this.type, this.doc, this.initialDefault, this.writeDefault);
            }
        }
    }
}

