/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.util;

import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteBuffers {
    public static byte[] toByteArray(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (buffer.hasArray()) {
            byte[] array = buffer.array();
            if (buffer.arrayOffset() == 0 && buffer.position() == 0 && array.length == buffer.remaining()) {
                return array;
            }
            int start = buffer.arrayOffset() + buffer.position();
            int end = start + buffer.remaining();
            return Arrays.copyOfRange(array, start, end);
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.asReadOnlyBuffer().get(bytes);
        return bytes;
    }

    public static ByteBuffer reuse(ByteBuffer reuse, int length) {
        Preconditions.checkArgument(reuse.hasArray(), "Cannot reuse a buffer not backed by an array");
        Preconditions.checkArgument(reuse.arrayOffset() == 0, "Cannot reuse a buffer whose array offset is not 0");
        Preconditions.checkArgument(reuse.capacity() == length, "Cannot use a buffer whose capacity (%s) is not equal to the requested length (%s)", length, reuse.capacity());
        reuse.position(0);
        reuse.limit(length);
        return reuse;
    }

    public static ByteBuffer copy(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        byte[] copyArray = new byte[buffer.remaining()];
        ByteBuffer readerBuffer = buffer.asReadOnlyBuffer();
        readerBuffer.get(copyArray);
        return ByteBuffer.wrap(copyArray);
    }

    private ByteBuffers() {
    }
}

