/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.util;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.CharArraySet;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.fr.FrenchAnalyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.util.ElisionFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoader;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoaderAware;
import java.io.IOException;
import java.util.Map;

public class ElisionFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "elision";
    private final String articlesFile;
    private final boolean ignoreCase;
    private CharArraySet articles;

    public ElisionFilterFactory(Map<String, String> args2) {
        super(args2);
        this.articlesFile = this.get(args2, "articles");
        this.ignoreCase = this.getBoolean(args2, "ignoreCase", false);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    public ElisionFilterFactory() {
        throw ElisionFilterFactory.defaultCtorException();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        this.articles = this.articlesFile == null ? FrenchAnalyzer.DEFAULT_ARTICLES : this.getWordSet(loader, this.articlesFile, this.ignoreCase);
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ElisionFilter(input, this.articles);
    }

    @Override
    public TokenStream normalize(TokenStream input) {
        return this.create(input);
    }
}

